/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.IFSSHTTPBSerializable;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd16bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd8bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart16bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart32bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;

public abstract class StreamObject
implements IFSSHTTPBSerializable {
    private static final Set<StreamObjectTypeHeaderStart> compoundTypes = new HashSet<StreamObjectTypeHeaderStart>(Arrays.asList(StreamObjectTypeHeaderStart.DataElement, StreamObjectTypeHeaderStart.Knowledge, StreamObjectTypeHeaderStart.CellKnowledge, StreamObjectTypeHeaderStart.DataElementPackage, StreamObjectTypeHeaderStart.ObjectGroupDeclarations, StreamObjectTypeHeaderStart.ObjectGroupData, StreamObjectTypeHeaderStart.WaterlineKnowledge, StreamObjectTypeHeaderStart.ContentTagKnowledge, StreamObjectTypeHeaderStart.Request, StreamObjectTypeHeaderStart.FsshttpbSubResponse, StreamObjectTypeHeaderStart.SubRequest, StreamObjectTypeHeaderStart.ReadAccessResponse, StreamObjectTypeHeaderStart.SpecializedKnowledge, StreamObjectTypeHeaderStart.WriteAccessResponse, StreamObjectTypeHeaderStart.QueryChangesFilter, StreamObjectTypeHeaderStart.ResponseError, StreamObjectTypeHeaderStart.UserAgent, StreamObjectTypeHeaderStart.FragmentKnowledge, StreamObjectTypeHeaderStart.ObjectGroupMetadataDeclarations, StreamObjectTypeHeaderStart.LeafNodeObject, StreamObjectTypeHeaderStart.IntermediateNodeObject, StreamObjectTypeHeaderStart.TargetPartitionId));
    private static final Map<StreamObjectTypeHeaderStart, Class> streamObjectTypeMapping = new HashMap<StreamObjectTypeHeaderStart, Class>();
    StreamObjectHeaderEnd streamObjectHeaderEnd;
    private StreamObjectTypeHeaderStart streamObjectType;
    private int lengthOfItems;
    private StreamObjectHeaderStart streamObjectHeaderStart;

    protected StreamObject(StreamObjectTypeHeaderStart streamObjectType) {
        this.streamObjectType = streamObjectType;
    }

    public static Set<StreamObjectTypeHeaderStart> getCompoundTypes() {
        return compoundTypes;
    }

    public static Map<StreamObjectTypeHeaderStart, Class> getStreamObjectTypeMapping() {
        return streamObjectTypeMapping;
    }

    public static <T extends StreamObject> T getCurrent(byte[] byteArray, AtomicInteger index, Class<T> clazz) throws TikaException, IOException {
        AtomicInteger tmpIndex = new AtomicInteger(index.get());
        AtomicReference<StreamObjectHeaderStart> streamObjectHeader = new AtomicReference<StreamObjectHeaderStart>();
        int length = StreamObjectHeaderStart.tryParse(byteArray, tmpIndex.get(), streamObjectHeader);
        if (length == 0) {
            throw new StreamObjectParseErrorException(tmpIndex.get(), clazz.getName(), "Failed to extract either 16bit or 32bit stream object header in the current index.", null);
        }
        tmpIndex.addAndGet(length);
        StreamObject streamObject = StreamObject.parseStreamObject(streamObjectHeader.get(), byteArray, tmpIndex);
        if (!streamObject.getClass().equals(clazz)) {
            String destClassName = "(null)";
            if (streamObjectTypeMapping.containsKey((Object)streamObjectHeader.get().type)) {
                destClassName = streamObjectTypeMapping.get((Object)streamObjectHeader.get().type).getName();
            }
            throw new StreamObjectParseErrorException(tmpIndex.get(), clazz.getName(), String.format(Locale.US, "Failed to get stream object as expect type %s, actual type is %s", clazz.getName(), destClassName), null);
        }
        index.set(tmpIndex.get());
        return (T)streamObject;
    }

    public static StreamObject parseStreamObject(StreamObjectHeaderStart header, byte[] byteArray, AtomicInteger index) throws IOException, TikaException {
        if (streamObjectTypeMapping.containsKey((Object)header.type)) {
            StreamObject streamObject;
            Class headerTypeClass = streamObjectTypeMapping.get((Object)header.type);
            try {
                streamObject = (StreamObject)headerTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TikaException("Could not instantiate class " + String.valueOf(headerTypeClass), (Throwable)e);
            }
            int res = streamObject.deserializeFromByteArray(header, byteArray, index.get());
            index.addAndGet(res);
            return streamObject;
        }
        int tmpIndex = index.get();
        throw new StreamObjectParseErrorException(tmpIndex -= header.headerType == 0 ? 2 : 4, "Unknown", String.format(Locale.US, "Failed to create the specified stream object instance, the type %s of stream object header in the current index is not defined", header.type.getIntVal()), null);
    }

    public static <T extends StreamObject> boolean tryGetCurrent(byte[] byteArray, AtomicInteger index, AtomicReference<T> streamObject, Class<T> clazz) throws TikaException, IOException {
        AtomicInteger tmpIndex = new AtomicInteger(index.get());
        int length = 0;
        AtomicReference<StreamObjectHeaderStart> streamObjectHeader = new AtomicReference<StreamObjectHeaderStart>();
        length = StreamObjectHeaderStart.tryParse(byteArray, tmpIndex.get(), streamObjectHeader);
        if (length == 0) {
            return false;
        }
        tmpIndex.addAndGet(length);
        if (!streamObjectTypeMapping.containsKey((Object)streamObjectHeader.get().type) || !streamObjectTypeMapping.get((Object)streamObjectHeader.get().type).equals(clazz)) {
            return false;
        }
        streamObject.set(StreamObject.parseStreamObject(streamObjectHeader.get(), byteArray, tmpIndex));
        index.set(tmpIndex.get());
        return true;
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException, TikaException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        int lengthOfItems = this.serializeItemsToByteList(byteList);
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        if (this.streamObjectType.getIntVal() <= 63 && lengthOfItems <= 127) {
            header.set(new StreamObjectHeaderStart16bit(this.streamObjectType, lengthOfItems));
        } else {
            header.set(new StreamObjectHeaderStart32bit(this.streamObjectType, lengthOfItems));
        }
        byteList.addAll(0, ((StreamObjectHeaderStart)header.get()).serializeToByteList());
        if (compoundTypes.contains((Object)this.streamObjectType)) {
            if (this.streamObjectType.getIntVal() <= 63) {
                byteList.addAll(new StreamObjectHeaderEnd8bit(this.streamObjectType.getIntVal()).serializeToByteList());
            } else {
                byteList.addAll(new StreamObjectHeaderEnd16bit(this.streamObjectType.getIntVal()).serializeToByteList());
            }
        }
        return byteList;
    }

    public int deserializeFromByteArray(StreamObjectHeaderStart header, byte[] byteArray, int startIndex) throws IOException, TikaException {
        this.streamObjectType = header.type;
        this.lengthOfItems = header.length;
        if (header instanceof StreamObjectHeaderStart32bit && header.length == Short.MAX_VALUE) {
            this.lengthOfItems = (int)((StreamObjectHeaderStart32bit)header).largeLength.getDecodedValue();
        }
        AtomicInteger index = new AtomicInteger(startIndex);
        this.streamObjectHeaderStart = header;
        this.deserializeItemsFromByteArray(byteArray, index, this.lengthOfItems);
        if (compoundTypes.contains((Object)this.streamObjectType)) {
            StreamObjectHeaderEnd end = null;
            BitReader bitReader = new BitReader(byteArray, index.get());
            int aField = bitReader.readInt32(2);
            if (aField == 1) {
                end = BasicObject.parse(byteArray, index, StreamObjectHeaderEnd8bit.class);
            }
            if (aField == 3) {
                end = BasicObject.parse(byteArray, index, StreamObjectHeaderEnd16bit.class);
            }
            if (end.type.getIntVal() != this.streamObjectType.getIntVal()) {
                throw new StreamObjectParseErrorException(index.get(), null, "Unexpected the stream header end value " + this.streamObjectType.getIntVal(), null);
            }
            this.streamObjectHeaderEnd = end;
        }
        return index.get() - startIndex;
    }

    protected abstract int serializeItemsToByteList(List<Byte> var1) throws IOException, TikaException;

    protected abstract void deserializeItemsFromByteArray(byte[] var1, AtomicInteger var2, int var3) throws TikaException, IOException;

    static {
        for (StreamObjectTypeHeaderStart value : StreamObjectTypeHeaderStart.values()) {
            String className = StreamObject.class.getPackage().getName() + "." + value.name();
            try {
                streamObjectTypeMapping.put(value, Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

