/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker.service;

import com.github.javafaker.service.FakeValuesInterface;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class FakeValues
implements FakeValuesInterface {
    private final Locale locale;
    private final String filename;
    private final String path;
    private Map values;

    FakeValues(Locale locale) {
        this(locale, FakeValues.getFilename(locale), FakeValues.getFilename(locale));
    }

    private static String getFilename(Locale locale) {
        StringBuilder filename = new StringBuilder(FakeValues.language(locale));
        if (!"".equals(locale.getCountry())) {
            filename.append("-").append(locale.getCountry());
        }
        return filename.toString();
    }

    private static String language(Locale l) {
        if (l.getLanguage().equals("iw")) {
            return "he";
        }
        return l.getLanguage();
    }

    FakeValues(Locale locale, String filename, String path) {
        this.locale = locale;
        this.filename = filename;
        this.path = path;
    }

    @Override
    public Map get(String key) {
        if (this.values == null) {
            this.values = this.loadValues();
        }
        return this.values == null ? null : (Map)this.values.get(key);
    }

    private Map loadValues() {
        String path;
        String pathWithLocaleAndFilename = "/" + this.locale.getLanguage() + "/" + this.filename;
        String pathWithFilename = "/" + this.filename + ".yml";
        String pathWithLocale = "/" + this.locale.getLanguage() + ".yml";
        List<String> paths = Arrays.asList(pathWithLocaleAndFilename, pathWithFilename, pathWithLocale);
        InputStream stream = null;
        Iterator<String> iterator = paths.iterator();
        while (iterator.hasNext() && (stream = this.findStream(path = iterator.next())) == null) {
        }
        if (stream == null) {
            return null;
        }
        Map valuesMap = (Map)new Yaml().loadAs(stream, Map.class);
        Map localeBased = (Map)valuesMap.get(this.locale.getLanguage());
        if (localeBased == null) {
            localeBased = (Map)valuesMap.get(this.filename);
        }
        return (Map)localeBased.get("faker");
    }

    private InputStream findStream(String filename) {
        InputStream streamOnClass = this.getClass().getResourceAsStream(filename);
        if (streamOnClass != null) {
            return streamOnClass;
        }
        return this.getClass().getClassLoader().getResourceAsStream(filename);
    }

    boolean supportsPath(String path) {
        return this.path.equals(path);
    }
}

