/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroinput;

import org.apache.hop.avro.transforms.avroinput.AvroFileInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AvroFileInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = AvroFileInputMeta.class;
    private AvroFileInputMeta input;
    private Combo wFilenameField;
    private Text wOutputField;
    private TextVar wRowsLimit;

    public AvroFileInputDialog(Shell parent, IVariables variables, AvroFileInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AvroFileInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AvroFileInputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlFilenameField = new Label((Composite)this.shell, 131072);
        wlFilenameField.setText(BaseMessages.getString(PKG, (String)"AvroFileInputDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, 0);
        fdlFilenameField.right = new FormAttachment(middle, -margin);
        fdlFilenameField.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new Combo((Composite)this.shell, 18436);
        this.wFilenameField.setText(this.transformName);
        PropsUi.setLook((Widget)this.wFilenameField);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, 0);
        fdFilenameField.top = new FormAttachment((Control)wlFilenameField, 0, 0x1000000);
        fdFilenameField.right = new FormAttachment(100, 0);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        lastControl = this.wFilenameField;
        Label wlOutputField = new Label((Composite)this.shell, 131072);
        wlOutputField.setText(BaseMessages.getString(PKG, (String)"AvroFileInputDialog.OutputField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputField);
        FormData fdlOutputField = new FormData();
        fdlOutputField.left = new FormAttachment(0, 0);
        fdlOutputField.right = new FormAttachment(middle, -margin);
        fdlOutputField.top = new FormAttachment((Control)lastControl, margin);
        wlOutputField.setLayoutData((Object)fdlOutputField);
        this.wOutputField = new Text((Composite)this.shell, 18436);
        this.wOutputField.setText(this.transformName);
        PropsUi.setLook((Widget)this.wOutputField);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(middle, 0);
        fdOutputField.top = new FormAttachment((Control)wlOutputField, 0, 0x1000000);
        fdOutputField.right = new FormAttachment(100, 0);
        this.wOutputField.setLayoutData((Object)fdOutputField);
        lastControl = this.wOutputField;
        Label wlRowsLimit = new Label((Composite)this.shell, 131072);
        wlRowsLimit.setText(BaseMessages.getString(PKG, (String)"AvroFileInputDialog.RowsLimit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRowsLimit);
        FormData fdlRowsLimit = new FormData();
        fdlRowsLimit.left = new FormAttachment(0, 0);
        fdlRowsLimit.right = new FormAttachment(middle, -margin);
        fdlRowsLimit.top = new FormAttachment((Control)lastControl, margin);
        wlRowsLimit.setLayoutData((Object)fdlRowsLimit);
        this.wRowsLimit = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wRowsLimit.setText(this.transformName);
        PropsUi.setLook((Widget)this.wRowsLimit);
        FormData fdRowsLimit = new FormData();
        fdRowsLimit.left = new FormAttachment(middle, 0);
        fdRowsLimit.top = new FormAttachment((Control)wlRowsLimit, 0, 0x1000000);
        fdRowsLimit.right = new FormAttachment(100, 0);
        this.wRowsLimit.setLayoutData((Object)fdRowsLimit);
        lastControl = this.wRowsLimit;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        try {
            IRowMeta fields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            this.wFilenameField.setItems(fields.getFieldNames());
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting input fields", e);
        }
        this.wFilenameField.setText(Const.NVL((String)this.input.getDataFilenameField(), (String)""));
        this.wOutputField.setText(Const.NVL((String)this.input.getOutputFieldName(), (String)""));
        this.wRowsLimit.setText(Const.NVL((String)this.input.getRowsLimit(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setDataFilenameField(this.wFilenameField.getText());
        this.input.setOutputFieldName(this.wOutputField.getText());
        this.input.setRowsLimit(this.wRowsLimit.getText());
        this.transformName = this.wTransformName.getText();
        this.transformMeta.setChanged();
        this.dispose();
    }
}

