/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItem;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class BaseGuiWidgets {
    protected String instanceId;
    protected String guiPluginClassName;
    protected Object guiPluginObject;

    public BaseGuiWidgets(String instanceId) {
        this.instanceId = instanceId;
    }

    public void registerGuiPluginObject(Object guiPluginObject) {
        this.guiPluginObject = guiPluginObject;
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        this.guiPluginClassName = guiPluginObject.getClass().getName();
        guiRegistry.registerGuiPluginObject(HopGui.getInstance().getId(), this.guiPluginClassName, this.instanceId, guiPluginObject);
    }

    protected void addDeRegisterGuiPluginObjectListener(Control control) {
        control.addDisposeListener(e -> GuiRegistry.getInstance().removeGuiPluginObjects(HopGui.getInstance().getId(), this.instanceId));
    }

    public void dispose() {
        String hopGuiId = HopGui.getInstance().getId();
        GuiRegistry.getInstance().removeGuiPluginObjects(hopGuiId, this.instanceId);
    }

    protected static Object findGuiPluginInstance(ClassLoader classLoader, String listenerClassName, String instanceId) throws Exception {
        try {
            String hopGuiId = HopGui.getInstance().getId();
            Object guiPluginObject = GuiRegistry.getInstance().findGuiPluginObject(hopGuiId, listenerClassName, instanceId);
            if (guiPluginObject == null) {
                guiPluginObject = classLoader.loadClass(listenerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                GuiRegistry.getInstance().registerGuiPluginObject(hopGuiId, listenerClassName, instanceId, guiPluginObject);
            }
            return guiPluginObject;
        }
        catch (Exception e) {
            throw new HopException("Error finding GuiPlugin instance for class '" + listenerClassName + "' and instance ID : " + instanceId, (Throwable)e);
        }
    }

    protected String[] getComboItems(GuiToolbarItem toolbarItem) {
        try {
            Object[] arguments;
            Method method;
            Object singleton = BaseGuiWidgets.findGuiPluginInstance(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), this.instanceId);
            if (singleton == null) {
                LogChannel.UI.logError("Could not get instance of class '" + toolbarItem.getListenerClass() + " for toolbar item " + String.valueOf(toolbarItem) + ", combo values method : " + toolbarItem.getGetComboValuesMethod());
                return new String[0];
            }
            try {
                method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), ILogChannel.class, IHopMetadataProvider.class);
                arguments = new Object[]{LogChannel.UI, HopGui.getInstance().getMetadataProvider()};
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), ILogChannel.class, IHopMetadataProvider.class, String.class);
                    arguments = new Object[]{LogChannel.UI, HopGui.getInstance().getMetadataProvider(), this.instanceId};
                }
                catch (NoSuchMethodException nsme2) {
                    try {
                        method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), new Class[0]);
                        arguments = new Object[]{};
                    }
                    catch (NoSuchMethodException nsme3) {
                        throw new HopException("Unable to find method '" + toolbarItem.getGetComboValuesMethod() + "' without parameters or with parameters ILogChannel and IHopMetadataProvider in class '" + toolbarItem.getListenerClass() + "'", (Throwable)nsme2);
                    }
                }
            }
            List values = (List)method.invoke(singleton, arguments);
            return values.toArray(new String[0]);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting list of combo items for method '" + toolbarItem.getGetComboValuesMethod() + "' in class : " + toolbarItem.getListenerClass(), (Throwable)e);
            return new String[0];
        }
    }

    protected Listener getListener(ClassLoader classLoader, String listenerClassName, String listenerMethodName) {
        return e -> {
            try {
                Class<?> listenerClass = classLoader.loadClass(listenerClassName);
                Method listenerMethod = listenerClass.getMethod(listenerMethodName, this.guiPluginObject.getClass());
                listenerMethod.invoke(null, this.guiPluginObject);
                return;
            }
            catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException listenerClass) {
                try {
                    Object guiPluginInstance = BaseGuiWidgets.findGuiPluginInstance(classLoader, listenerClassName, this.instanceId);
                    Method listenerMethod = guiPluginInstance.getClass().getDeclaredMethod(listenerMethodName, new Class[0]);
                    listenerMethod.invoke(guiPluginInstance, new Object[0]);
                    return;
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    LogChannel.UI.logError("Unable to call method " + listenerMethodName + " in class " + listenerClassName + " : " + exception.getMessage(), (Throwable)exception);
                }
            }
        };
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getGuiPluginClassName() {
        return this.guiPluginClassName;
    }

    public void setGuiPluginClassName(String guiPluginClassName) {
        this.guiPluginClassName = guiPluginClassName;
    }

    public Object getGuiPluginObject() {
        return this.guiPluginObject;
    }

    public void setGuiPluginObject(Object guiPluginObject) {
        this.guiPluginObject = guiPluginObject;
    }
}

