/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_JsonToRowWithErrFn;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_JsonToRowWithErrFn_ParseWithError;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_ParseResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonToRow {
    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> withSchema(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        RowJson.verifySchemaSupported(rowSchema);
        return new JsonToRowFn(rowSchema, RowJson.RowJsonDeserializer.NullBehavior.ACCEPT_MISSING_OR_NULL);
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> withSchemaAndNullBehavior(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
        RowJson.verifySchemaSupported(rowSchema);
        return new JsonToRowFn(rowSchema, nullBehavior);
    }

    public static @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn withExceptionReporting(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        return JsonToRowWithErrFn.forSchema(rowSchema);
    }

    @AutoValue
    public static abstract class ParseResult
    implements POutput {
        abstract @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn getJsonToRowWithErrFn();

        abstract @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> getParsedLine();

        abstract @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> getFailedParse();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        abstract @UnknownKeyFor @NonNull @Initialized Pipeline getCallingPipeline();

        public static @UnknownKeyFor @NonNull @Initialized Builder resultBuilder() {
            return new AutoValue_JsonToRow_ParseResult.Builder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
            return this.getCallingPipeline();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
            return ImmutableMap.of(JsonToRowWithErrFn.PARSED_LINE, this.getParsedLine(), JsonToRowWithErrFn.PARSE_ERROR, this.getFailedParse());
        }

        @Override
        public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> getResults() {
            return this.getParsedLine();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> getFailedToParseLines() {
            return this.getFailedParse();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonToRowWithErrFn(@UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setParsedLine(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFailedParse(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCallingPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline var1);

            abstract @UnknownKeyFor @NonNull @Initialized ParseResult build();
        }
    }

    @AutoValue
    public static abstract class JsonToRowWithErrFn
    extends PTransform<PCollection<String>, ParseResult> {
        private static final @UnknownKeyFor @NonNull @Initialized String LINE_FIELD_NAME = "line";
        private static final @UnknownKeyFor @NonNull @Initialized String ERROR_FIELD_NAME = "err";
        public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_ROW_SCHEMA = Schema.of(Schema.Field.of("line", Schema.FieldType.STRING));
        public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_ROW_WITH_ERR_MSG_SCHEMA = Schema.of(Schema.Field.of("line", Schema.FieldType.STRING), Schema.Field.of("err", Schema.FieldType.STRING));
        static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> PARSED_LINE = new TupleTag<Row>(){};
        static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> PARSE_ERROR = new TupleTag<Row>(){};

        abstract @UnknownKeyFor @NonNull @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized String getLineFieldName();

        abstract @UnknownKeyFor @NonNull @Initialized String getErrorFieldName();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getExtendedErrorInfo();

        abstract @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior getNullBehavior();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        static @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn forSchema(@UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
            RowJson.verifySchemaSupported(rowSchema);
            return new AutoValue_JsonToRow_JsonToRowWithErrFn.Builder().setSchema(rowSchema).setNullBehavior(RowJson.RowJsonDeserializer.NullBehavior.ACCEPT_MISSING_OR_NULL).setExtendedErrorInfo(false).setLineFieldName(LINE_FIELD_NAME).setErrorFieldName(ERROR_FIELD_NAME).build();
        }

        public @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn withExtendedErrorInfo() {
            return this.toBuilder().setExtendedErrorInfo(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn setLineField(@UnknownKeyFor @NonNull @Initialized String lineField) {
            return this.toBuilder().setLineFieldName(lineField).build();
        }

        public @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn setErrorField(@UnknownKeyFor @NonNull @Initialized String errorField) {
            if (!this.getExtendedErrorInfo()) {
                throw new IllegalArgumentException("This option is only available with Extended Error Info.");
            }
            return this.toBuilder().setErrorFieldName(errorField).build();
        }

        public @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn withNullBehavior(@UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
            return this.toBuilder().setNullBehavior(nullBehavior).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ParseResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> jsonStrings) {
            PCollectionTuple result = (PCollectionTuple)((Object)jsonStrings.apply(ParDo.of(ParseWithError.create(this)).withOutputTags(PARSED_LINE, TupleTagList.of(PARSE_ERROR))));
            PCollection<Row> failures = this.getExtendedErrorInfo() ? result.get(PARSE_ERROR).setRowSchema(ERROR_ROW_WITH_ERR_MSG_SCHEMA) : result.get(PARSE_ERROR).setRowSchema(ERROR_ROW_SCHEMA);
            return ParseResult.resultBuilder().setCallingPipeline(jsonStrings.getPipeline()).setJsonToRowWithErrFn(this).setParsedLine(result.get(PARSED_LINE).setRowSchema(this.getSchema())).setFailedParse(failures).build();
        }

        @AutoValue
        protected static abstract class ParseWithError
        extends DoFn<String, Row> {
            private volatile transient @Nullable @UnknownKeyFor @Initialized ObjectMapper objectMapper;

            protected ParseWithError() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn getJsonToRowWithErrFn();

            public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

            public static @UnknownKeyFor @NonNull @Initialized ParseWithError create(@UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn jsonToRowWithErrFn) {
                return new AutoValue_JsonToRow_JsonToRowWithErrFn_ParseWithError.Builder().setJsonToRowWithErrFn(jsonToRowWithErrFn).build();
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver output) {
                try {
                    output.get(PARSED_LINE).output(RowJsonUtils.jsonToRow(this.objectMapper(), element));
                }
                catch (Exception ex) {
                    if (this.getJsonToRowWithErrFn().getExtendedErrorInfo()) {
                        output.get(PARSE_ERROR).output(Row.withSchema(ERROR_ROW_WITH_ERR_MSG_SCHEMA).addValue(element).addValue(ex.getMessage()).build());
                    }
                    output.get(PARSE_ERROR).output(Row.withSchema(ERROR_ROW_SCHEMA).addValue(element).build());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper() {
                if (this.objectMapper == null) {
                    ParseWithError parseWithError = this;
                    synchronized (parseWithError) {
                        if (this.objectMapper == null) {
                            this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(this.getJsonToRowWithErrFn().getSchema()).withNullBehavior(this.getJsonToRowWithErrFn().getNullBehavior()));
                        }
                    }
                }
                return this.objectMapper;
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonToRowWithErrFn(@UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn var1);

                public abstract @UnknownKeyFor @NonNull @Initialized ParseWithError build();
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLineFieldName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorFieldName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setExtendedErrorInfo(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNullBehavior(@UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior var1);

            abstract @UnknownKeyFor @NonNull @Initialized JsonToRowWithErrFn build();
        }
    }

    static class JsonToRowFn
    extends PTransform<PCollection<String>, PCollection<Row>> {
        private volatile transient @Nullable @UnknownKeyFor @Initialized ObjectMapper objectMapper;
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior nullBehavior;

        private JsonToRowFn(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
            this.schema = schema;
            this.nullBehavior = nullBehavior;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> jsonStrings) {
            return ((PCollection)((Object)jsonStrings.apply(ParDo.of(new DoFn<String, Row>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    context.output(RowJsonUtils.jsonToRow(this.objectMapper(), (String)context.element()));
                }
            })))).setRowSchema(this.schema);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private @UnknownKeyFor @NonNull @Initialized ObjectMapper objectMapper() {
            if (this.objectMapper == null) {
                JsonToRowFn jsonToRowFn = this;
                synchronized (jsonToRowFn) {
                    if (this.objectMapper == null) {
                        this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(this.schema).withNullBehavior(this.nullBehavior));
                    }
                }
            }
            return this.objectMapper;
        }
    }
}

