/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionAdapter;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VPropertiesAction;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;

class PopupMenuAdapter
extends MouseAdapter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private VActionContext actionContext_;
    private VPane pane_;
    private VPropertiesAction propertiesAction_;

    public PopupMenuAdapter(VPane pane, VActionContext actionContext) {
        this.pane_ = pane;
        this.actionContext_ = actionContext;
        this.propertiesAction_ = new VPropertiesAction();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getComponent(), event.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getComponent(), event.getPoint());
        }
    }

    private void showPopupMenu(Component component, Point point) {
        JMenuItem menuItem;
        VAction[] actions;
        VObject pointObject = this.pane_.getObjectAt(point);
        VNode rootObject = this.pane_.getRoot();
        int itemCount = 0;
        VObject subjectObject = null;
        if (pointObject != null) {
            subjectObject = pointObject;
        } else if (rootObject != null) {
            subjectObject = rootObject;
            if (component instanceof JTree) {
                ((JTree)component).getSelectionModel().clearSelection();
            } else if (component instanceof JTable) {
                ((JTable)component).getSelectionModel().clearSelection();
            }
        }
        JPopupMenu menu = new JPopupMenu();
        if (subjectObject != null && (actions = subjectObject.getActions()) != null) {
            for (int i = 0; i < actions.length; ++i) {
                menuItem = new JMenuItem(actions[i].getText());
                menuItem.addActionListener(new VActionAdapter(actions[i], this.actionContext_));
                menuItem.setEnabled(actions[i].isEnabled());
                menu.add(menuItem);
                ++itemCount;
            }
            if (actions.length > 0) {
                menu.addSeparator();
            }
        }
        if (subjectObject != null) {
            menuItem = new JMenuItem(this.propertiesAction_.getText());
            if (subjectObject.getPropertiesPane() != null) {
                this.propertiesAction_.setObject(subjectObject);
                menuItem.addActionListener(new VActionAdapter(this.propertiesAction_, this.actionContext_));
                menuItem.setEnabled(true);
            } else {
                menuItem.setEnabled(false);
            }
            menu.add(menuItem);
            ++itemCount;
        }
        if (itemCount > 0) {
            menu.show(component, point.x, point.y);
        }
    }
}

