/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBCellEditor;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.DBCellSelector;
import com.ibm.as400.vaccess.ErrorDialogAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLResultSetTableModel;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultEditorKit;

public class SQLResultSetTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    transient JTable table_;
    transient JScrollPane tablePane_;
    SQLResultSetTableModel model_;
    private Color tableColor_ = null;
    private boolean tableShowHorizontalLines_ = true;
    private boolean tableShowVerticalLines_ = true;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient ListSelectionEventSupport selectionListeners_ = new ListSelectionEventSupport(this);
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    DBCellRenderer rightCell_ = new DBCellRenderer(4);
    DBCellRenderer leftCell_ = new DBCellRenderer(2);
    DBCellSelector cellSelector_ = new DBCellSelector();
    DBCellEditor cellEditor_ = new DBCellEditor();
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_TIME = 2;
    private static final int TYPE_TIMESTAMP = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_BIT = 5;
    private static final int TYPE_NUMBER = 6;

    public SQLResultSetTablePane() {
        this.model_ = new SQLResultSetTableModel();
        this.initializeTransient();
    }

    public SQLResultSetTablePane(SQLConnection connection, String query) {
        this.model_ = new SQLResultSetTableModel(connection, query);
        this.initializeTransient();
    }

    public SQLResultSetTablePane(ResultSet resultSet, boolean cacheAll) {
        this.model_ = new SQLResultSetTableModel(resultSet, cacheAll);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionListeners_.addListSelectionListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
        super.addVetoableChangeListener(listener);
    }

    public void clearWarnings() {
        this.model_.clearWarnings();
    }

    public void close() {
        this.model_.close();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public String getColumnTitle(int columnIndex) {
        try {
            return (String)this.table_.getColumnModel().getColumn(columnIndex).getHeaderValue();
        }
        catch (Exception e) {
            Trace.log(4, "getColumnTitle() error:" + e);
            return null;
        }
    }

    public int getColumnWidth(int columnIndex) {
        try {
            return this.table_.getColumnModel().getColumn(columnIndex).getPreferredWidth();
        }
        catch (Exception e) {
            Trace.log(4, "getColumnWidth() error:" + e);
            return 0;
        }
    }

    public SQLConnection getConnection() {
        return this.model_.getConnection();
    }

    public SQLResultSetTableModel getDataModel() {
        return this.model_;
    }

    public Color getGridColor() {
        return this.tableColor_;
    }

    public String getQuery() {
        return this.model_.getQuery();
    }

    public ResultSet getResultSet() {
        return this.model_.getResultSet();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    public boolean getShowHorizontalLines() {
        return this.tableShowHorizontalLines_;
    }

    public boolean getShowVerticalLines() {
        return this.tableShowVerticalLines_;
    }

    public String getStringValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.model_.getRowCount()) {
            Trace.log(4, "getStringValueAt() column out of range");
            return null;
        }
        try {
            TableColumnModel cmodel = this.getColumnModel();
            Component cellComp = cmodel.getColumn(columnIndex).getCellRenderer().getTableCellRendererComponent(this.table_, this.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex);
            if (cellComp instanceof JLabel) {
                return ((JLabel)cellComp).getText();
            }
            return null;
        }
        catch (Exception e) {
            Trace.log(4, "getStringValueAt() error:" + e);
            return null;
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.model_.getValueAt(rowIndex, this.getColumnModel().getColumn(columnIndex).getModelIndex());
        }
        catch (Exception e) {
            Trace.log(4, "getStringValueAt() error:" + e);
            return null;
        }
    }

    public SQLWarning getWarnings() {
        return this.model_.getWarnings();
    }

    void handleFocus(FocusEvent event) {
        this.processFocusEvent(new FocusEvent(this, event.getID(), event.isTemporary()));
    }

    private void initializeTransient() {
        boolean useNewBehavior;
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.model_);
        this.model_.setTable(this.table_);
        this.table_.setAutoResizeMode(0);
        this.table_.setSelectionMode(2);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setColumnSelectionAllowed(true);
        this.table_.setCellSelectionEnabled(true);
        try {
            Class.forName("javax.swing.ActionMap");
            useNewBehavior = true;
        }
        catch (Throwable t) {
            Trace.log(4, "Unable to load JDK 1.3 classes. Will use old behavior for SQLResultSetTablePane.");
            useNewBehavior = false;
        }
        if (useNewBehavior) {
            Object keyToLookFor = null;
            JTextField dummyField = new JTextField();
            ActionMap dummyActions = dummyField.getActionMap();
            Object[] allKeys = dummyActions.allKeys();
            for (int i = 0; i < allKeys.length && keyToLookFor == null; ++i) {
                if (!(dummyActions.get(allKeys[i]) instanceof DefaultEditorKit.CopyAction)) continue;
                keyToLookFor = allKeys[i];
            }
            if (keyToLookFor != null) {
                InputMap dummyInputs = dummyField.getInputMap();
                KeyStroke[] allPossibleKeys = dummyInputs.allKeys();
                for (int i = 0; i < allPossibleKeys.length; ++i) {
                    Object actionForKey = dummyInputs.get(allPossibleKeys[i]);
                    if (!actionForKey.equals(keyToLookFor)) continue;
                    this.table_.getInputMap().put(allPossibleKeys[i], keyToLookFor);
                }
                if (this.table_.getInputMap().size() > 0) {
                    AbstractAction copyAction = new AbstractAction("copy"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (e.getSource() == SQLResultSetTablePane.this.table_) {
                                StringBuffer textToCopy = new StringBuffer();
                                int[] rows = SQLResultSetTablePane.this.table_.getSelectedRows();
                                int[] columns = SQLResultSetTablePane.this.table_.getSelectedColumns();
                                for (int i = 0; i < rows.length; ++i) {
                                    for (int j = 0; j < columns.length; ++j) {
                                        if (!SQLResultSetTablePane.this.table_.isCellSelected(rows[i], columns[j])) continue;
                                        textToCopy.append(SQLResultSetTablePane.this.table_.getValueAt(rows[i], columns[j]));
                                        textToCopy.append('\t');
                                    }
                                    textToCopy.append('\n');
                                }
                                StringSelection dataToTransfer = new StringSelection(textToCopy.toString());
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(dataToTransfer, dataToTransfer);
                            } else {
                                Trace.log(4, "Copy action received from unknown source: " + e.getSource());
                            }
                        }
                    };
                    this.table_.getActionMap().put(keyToLookFor, copyAction);
                } else {
                    Trace.log(4, "Table copy function not enabled. No key bindings found.");
                }
            } else {
                Trace.log(4, "Table copy function not enabled. No copy actions found.");
            }
        }
        if (this.tableColor_ == null) {
            this.tableColor_ = this.table_.getGridColor();
        }
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.model_.addErrorListener(this.errorListeners_);
        this.model_.addWorkingListener(this.worker_);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
        this.setLayout(new BorderLayout());
        this.tablePane_ = new JScrollPane(this.table_);
        this.add("Center", this.tablePane_);
        this.table_.setDoubleBuffered(true);
        this.tablePane_.getViewport().setBackingStoreEnabled(true);
        this.tablePane_.setDoubleBuffered(true);
        this.tablePane_.getViewport().setDoubleBuffered(true);
        if (!useNewBehavior) {
            this.tablePane_.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        }
        this.table_.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                SQLResultSetTablePane.this.handleFocus(event);
            }

            @Override
            public void focusLost(FocusEvent event) {
                SQLResultSetTablePane.this.handleFocus(event);
            }
        });
        this.addFocusListener(new SerializationListener(this));
        this.addFocusListener(new SerializationListener(this.model_, this.table_));
    }

    public void load() {
        this.model_.load();
        this.refreshHeadings();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.model_.addErrorListener(this.errorListeners_);
        this.worker_ = new WorkingCursorAdapter(this);
        this.model_.addWorkingListener(this.worker_);
        this.selectionListeners_ = new ListSelectionEventSupport(this);
        this.initializeTransient();
        this.table_.setGridColor(this.tableColor_);
        this.table_.setShowHorizontalLines(this.tableShowHorizontalLines_);
        this.table_.setShowVerticalLines(this.tableShowVerticalLines_);
    }

    public void refreshHeadings() {
        Runnable refreshHeading = new Runnable(){

            @Override
            public void run() {
                TableColumnModel model = SQLResultSetTablePane.this.table_.getColumnModel();
                int oldColumnCount = model.getColumnCount();
                TableColumn[] oldColumns = new TableColumn[oldColumnCount];
                Enumeration<TableColumn> e = model.getColumns();
                int i = 0;
                while (e.hasMoreElements()) {
                    oldColumns[i] = e.nextElement();
                    ++i;
                }
                for (i = 0; i < oldColumnCount; ++i) {
                    model.removeColumn(oldColumns[i]);
                }
                int numColumns = SQLResultSetTablePane.this.model_.getColumnCount();
                int size = 0;
                if (SQLResultSetTablePane.this.table_.getFont() != null) {
                    size = SQLResultSetTablePane.this.table_.getFontMetrics(SQLResultSetTablePane.this.table_.getFont()).charWidth('M');
                }
                for (int i2 = 0; i2 < numColumns; ++i2) {
                    int type;
                    TableColumn col = new TableColumn(i2);
                    col.setIdentifier(SQLResultSetTablePane.this.model_.getColumnID(i2));
                    int sqltype = SQLResultSetTablePane.this.model_.getColumnType(i2);
                    switch (sqltype) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            type = 6;
                            break;
                        }
                        case 91: {
                            type = 4;
                            break;
                        }
                        case 92: {
                            type = 2;
                            break;
                        }
                        case 93: {
                            type = 3;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            type = 5;
                            break;
                        }
                        default: {
                            type = 1;
                        }
                    }
                    String title = SQLResultSetTablePane.this.model_.getColumnName(i2);
                    if (type == 1 || type == 5 || type == 4 || type == 2 || type == 3) {
                        col.setCellRenderer(SQLResultSetTablePane.this.leftCell_);
                        col.setHeaderRenderer(new VObjectHeaderRenderer(title, 2));
                    } else {
                        col.setCellRenderer(SQLResultSetTablePane.this.rightCell_);
                        col.setHeaderRenderer(new VObjectHeaderRenderer(title, 4));
                    }
                    if (size != 0) {
                        int colTitleSize;
                        int colDataSize = SQLResultSetTablePane.this.model_.getColumnWidth(i2);
                        if (type == 5) {
                            colDataSize *= 2;
                        }
                        int colSize = colDataSize > (colTitleSize = title.length()) ? colDataSize : colTitleSize;
                        col.setPreferredWidth(colSize * size + 10);
                    }
                    if (!SQLResultSetTablePane.this.model_.isUpdatable()) {
                        col.setCellEditor(SQLResultSetTablePane.this.cellSelector_);
                    } else if (type == 1) {
                        col.setCellEditor(SQLResultSetTablePane.this.cellEditor_);
                    }
                    SQLResultSetTablePane.this.table_.addColumn(col);
                }
                if (oldColumnCount == 0 && numColumns > 0) {
                    if (SQLResultSetTablePane.this.tablePane_ != null) {
                        SQLResultSetTablePane.this.remove(SQLResultSetTablePane.this.tablePane_);
                    }
                    SQLResultSetTablePane.this.tablePane_ = new JScrollPane(SQLResultSetTablePane.this.table_);
                    SQLResultSetTablePane.this.add("Center", SQLResultSetTablePane.this.tablePane_);
                }
                SQLResultSetTablePane.this.validate();
            }
        };
        try {
            SwingUtilities.invokeAndWait(refreshHeading);
        }
        catch (Error e) {
            Trace.log(1, "invokeAndWait error:" + e);
            refreshHeading.run();
        }
        catch (Exception e) {
            Trace.log(2, "invokeAndWait exception:" + e);
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selectionListeners_.removeListSelectionListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
        super.removeVetoableChangeListener(listener);
    }

    public void setColumnTitle(int columnIndex, String title) {
        try {
            this.table_.getColumnModel().getColumn(columnIndex).setHeaderValue(title);
        }
        catch (Exception e) {
            Trace.log(4, "setColumnTitle() error:" + e);
        }
        this.validate();
        this.repaint();
    }

    public void setColumnWidth(int columnIndex, int width) {
        try {
            this.table_.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
            this.table_.getColumnModel().getColumn(columnIndex).setWidth(width);
        }
        catch (Exception e) {
            Trace.log(4, "setColumnWidth() error:" + e);
        }
        this.validate();
        this.repaint();
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        this.model_.setConnection(connection);
    }

    public void setGridColor(Color color) {
        this.table_.setGridColor(color);
        this.tableColor_ = color;
    }

    public void setQuery(String query) throws PropertyVetoException {
        this.model_.setQuery(query);
    }

    public void setResultSet(ResultSet resultSet) {
        this.model_.setResultSet(resultSet);
    }

    public void setSelectionModel(ListSelectionModel model) {
        this.table_.getSelectionModel().removeListSelectionListener(this.selectionListeners_);
        this.table_.setSelectionModel(model);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
    }

    public void setShowHorizontalLines(boolean show) {
        this.table_.setShowHorizontalLines(show);
        this.tableShowHorizontalLines_ = show;
    }

    public void setShowVerticalLines(boolean show) {
        this.table_.setShowVerticalLines(show);
        this.tableShowVerticalLines_ = show;
    }

    public static void main(String[] args) {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = "X";
            boolean loop = true;
            while (line != null && !"exit".equalsIgnoreCase(line)) {
                Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                Connection connection = DriverManager.getConnection("jdbc:as400://" + args[0], args[1], args[2]);
                Statement statement = connection.createStatement(1004, 1007);
                ResultSet rs = statement.executeQuery("SELECT * FROM QSYS2.SYSCOLUMNS");
                SQLResultSetTablePane table = new SQLResultSetTablePane(rs, false);
                JFrame frame = new JFrame("My Window");
                frame.getContentPane().add(table);
                table.addErrorListener(new ErrorDialogAdapter(frame));
                frame.pack();
                frame.show();
                table.load();
                System.out.println("Table loaded Sleeping for 10 minutes");
                try {
                    Thread.sleep(600000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = input.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

