/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsoninput.reader;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transforms.file.BaseFileInputTransformData;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInput;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputData;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputMeta;

public class InputsReader
implements Iterable<InputStream> {
    private JsonInput transform;
    private JsonInputMeta meta;
    private JsonInputData data;
    private ErrorHandler errorHandler;
    private static final String CONST_REMOVE = "remove";

    public InputsReader(JsonInput transform, JsonInputMeta meta, JsonInputData data, ErrorHandler errorHandler) {
        this.transform = transform;
        this.meta = meta;
        this.data = data;
        this.errorHandler = errorHandler;
    }

    @Override
    public Iterator<InputStream> iterator() {
        if (!this.meta.isInFields() || this.meta.getIsAFile()) {
            Iterator<FileObject> files;
            if (((JsonInputMeta.InputFiles)this.meta.inputFiles).acceptingFilenames) {
                files = new FileNamesIterator((IVariables)this.transform, this.errorHandler, this.getFieldIterator());
            } else {
                if (this.data.files == null) {
                    this.data.files = this.meta.getFileInputList((IVariables)this.transform);
                }
                files = this.data.files.getFiles().listIterator(this.data.currentFileIndex);
            }
            return new FileContentIterator(files, this.data, this.errorHandler);
        }
        if (this.meta.isReadUrl()) {
            return new URLContentIterator(this.errorHandler, this.getFieldIterator());
        }
        return new ChainedIterator<InputStream, String>((Iterator)this.getFieldIterator(), this.errorHandler){

            @Override
            protected InputStream tryNext() throws IOException {
                String next = (String)this.inner.next();
                return next == null ? null : IOUtils.toInputStream((String)next, (String)InputsReader.this.meta.getEncoding());
            }
        };
    }

    public Iterator<JsonNode> jsonFieldIterator() {
        return new JsonFieldIterator(new RowIterator((ITransform)this.transform, this.data, this.errorHandler), this.data.indexSourceField);
    }

    protected StringFieldIterator getFieldIterator() {
        return new StringFieldIterator(new RowIterator((ITransform)this.transform, this.data, this.errorHandler), this.data.indexSourceField);
    }

    public static interface ErrorHandler {
        public void error(Exception var1);

        public void fileOpenError(FileObject var1, FileSystemException var2);

        public void fileCloseError(FileObject var1, FileSystemException var2);
    }

    protected class FileNamesIterator
    extends ChainedIterator<FileObject, String> {
        private IVariables vars;

        public FileNamesIterator(IVariables varSpace, ErrorHandler handler, Iterator<String> fileNames) {
            super(fileNames, handler);
            this.vars = varSpace;
        }

        @Override
        public FileObject tryNext() throws HopFileException {
            String fileName = InputsReader.this.transform.resolve((String)this.inner.next());
            return fileName == null ? null : HopVfs.getFileObject((String)fileName);
        }
    }

    protected class StringFieldIterator
    implements Iterator<String> {
        private RowIterator rowIter;
        private int idx;

        public StringFieldIterator(RowIterator rowIter, int idx) {
            this.rowIter = rowIter;
            this.idx = idx;
        }

        @Override
        public boolean hasNext() {
            return this.rowIter.hasNext();
        }

        @Override
        public String next() {
            Object[] row = this.rowIter.next();
            if (row == null || row.length <= this.idx) {
                return null;
            }
            Object v = row[this.idx];
            if (v == null) {
                return null;
            }
            if (v instanceof String) {
                String vString = (String)v;
                return vString;
            }
            throw new ClassCastException("Field at index " + this.idx + " is " + v.getClass().getName() + ", expected String.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(InputsReader.CONST_REMOVE);
        }
    }

    protected class FileContentIterator
    extends ChainedIterator<InputStream, FileObject> {
        ErrorHandler handler;
        BaseFileInputTransformData data;

        FileContentIterator(Iterator<FileObject> inner, BaseFileInputTransformData data, ErrorHandler handler) {
            super(inner, handler);
            this.data = data;
        }

        @Override
        public InputStream tryNext() {
            if (this.hasNext()) {
                if (this.data.file != null) {
                    try {
                        this.data.file.close();
                    }
                    catch (FileSystemException e) {
                        this.handler.fileCloseError(this.data.file, e);
                    }
                }
                try {
                    this.data.file = (FileObject)this.inner.next();
                    ++this.data.currentFileIndex;
                    if (InputsReader.this.transform.onNewFile(this.data.file)) {
                        return HopVfs.getInputStream((FileObject)this.data.file);
                    }
                }
                catch (FileSystemException e) {
                    this.handler.fileOpenError(this.data.file, e);
                }
            }
            return null;
        }
    }

    protected class URLContentIterator
    extends ChainedIterator<InputStream, String> {
        public URLContentIterator(ErrorHandler handler, Iterator<String> urls) {
            super(urls, handler);
        }

        @Override
        protected InputStream tryNext() throws Exception {
            if (this.hasNext()) {
                URL url = new URL(InputsReader.this.transform.resolve((String)this.inner.next()));
                URLConnection connection = url.openConnection();
                return connection.getInputStream();
            }
            return null;
        }
    }

    protected class JsonFieldIterator
    implements Iterator<JsonNode> {
        private final RowIterator rowIter;
        private final int idx;

        public JsonFieldIterator(RowIterator rowIter, int idx) {
            this.rowIter = rowIter;
            this.idx = idx;
        }

        @Override
        public boolean hasNext() {
            return this.rowIter.hasNext();
        }

        @Override
        public JsonNode next() {
            Object[] row = this.rowIter.next();
            if (row == null || row.length <= this.idx) {
                return null;
            }
            Object v = row[this.idx];
            if (v == null) {
                return null;
            }
            if (v instanceof JsonNode) {
                JsonNode node = (JsonNode)v;
                return node;
            }
            throw new ClassCastException("Field at index " + this.idx + " is " + v.getClass().getName() + ", expected JsonNode.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(InputsReader.CONST_REMOVE);
        }
    }

    protected class RowIterator
    implements Iterator<Object[]> {
        private ITransform transform;
        private ErrorHandler errorHandler;
        private boolean gotNext;

        public RowIterator(ITransform transform, JsonInputData data, ErrorHandler errorHandler) {
            this.transform = transform;
            this.errorHandler = errorHandler;
            this.gotNext = data.readrow != null;
        }

        protected void fetchNext() {
            try {
                InputsReader.this.data.readrow = this.transform.getRow();
                this.gotNext = true;
            }
            catch (HopException e) {
                this.errorHandler.error((Exception)((Object)e));
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.gotNext) {
                this.fetchNext();
            }
            return InputsReader.this.data.readrow != null;
        }

        @Override
        public Object[] next() {
            if (this.hasNext()) {
                this.gotNext = false;
                return InputsReader.this.data.readrow;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(InputsReader.CONST_REMOVE);
        }
    }

    protected abstract class ChainedIterator<T, C>
    implements Iterator<T> {
        protected Iterator<C> inner;
        protected ErrorHandler handler;

        ChainedIterator(Iterator<C> inner, ErrorHandler handler) {
            this.inner = inner;
            this.handler = handler;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public T next() {
            try {
                return this.tryNext();
            }
            catch (Exception e) {
                this.handler.error(e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(InputsReader.CONST_REMOVE);
        }

        protected abstract T tryNext() throws Exception;
    }
}

