/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.util.TimeValue;

public class AsyncFullDuplexServerExample {
    public static void main(String[] args) throws Exception {
        int port = 8080;
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        HttpAsyncServer server = AsyncServerBootstrap.bootstrap().setExceptionCallback(e -> e.printStackTrace()).setIOReactorConfig(config).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println(connection.getRemoteAddress() + " " + new RequestLine(request));
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println(connection.getRemoteAddress() + " " + new StatusLine(response));
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection kept alive)");
                } else {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection closed)");
                }
            }
        }).register("/echo", () -> new AsyncServerExchangeHandler(){
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            CapacityChannel inputCapacityChannel;
            DataStreamChannel outputDataChannel;
            boolean endStream;

            private void ensureCapacity(int chunk) {
                if (this.buffer.remaining() < chunk) {
                    ByteBuffer oldBuffer = this.buffer;
                    oldBuffer.flip();
                    this.buffer = ByteBuffer.allocate(oldBuffer.remaining() + (chunk > 2048 ? chunk : 2048));
                    this.buffer.put(oldBuffer);
                }
            }

            public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
                BasicHttpResponse response = new BasicHttpResponse(200);
                responseChannel.sendResponse((HttpResponse)response, entityDetails, context);
            }

            public void consume(ByteBuffer src) throws IOException {
                if (this.buffer.position() == 0 && this.outputDataChannel != null) {
                    this.outputDataChannel.write(src);
                }
                if (src.hasRemaining()) {
                    this.ensureCapacity(src.remaining());
                    this.buffer.put(src);
                    if (this.outputDataChannel != null) {
                        this.outputDataChannel.requestOutput();
                    }
                }
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                if (this.buffer.hasRemaining()) {
                    capacityChannel.update(this.buffer.remaining());
                    this.inputCapacityChannel = null;
                } else {
                    this.inputCapacityChannel = capacityChannel;
                }
            }

            public void streamEnd(List<? extends Header> trailers) throws IOException {
                this.endStream = true;
                if (this.buffer.position() == 0) {
                    if (this.outputDataChannel != null) {
                        this.outputDataChannel.endStream();
                    }
                } else if (this.outputDataChannel != null) {
                    this.outputDataChannel.requestOutput();
                }
            }

            public int available() {
                return this.buffer.position();
            }

            public void produce(DataStreamChannel channel) throws IOException {
                CapacityChannel capacityChannel;
                this.outputDataChannel = channel;
                this.buffer.flip();
                if (this.buffer.hasRemaining()) {
                    channel.write(this.buffer);
                }
                this.buffer.compact();
                if (this.buffer.position() == 0 && this.endStream) {
                    channel.endStream();
                }
                if ((capacityChannel = this.inputCapacityChannel) != null && this.buffer.hasRemaining()) {
                    capacityChannel.update(this.buffer.remaining());
                }
            }

            public void failed(Exception cause) {
                if (!(cause instanceof SocketException)) {
                    cause.printStackTrace(System.out);
                }
            }

            public void releaseResources() {
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("HTTP server shutting down");
            server.close(CloseMode.GRACEFUL);
        }));
        server.start();
        Future future = server.listen((SocketAddress)new InetSocketAddress(port), URIScheme.HTTP);
        ListenerEndpoint listenerEndpoint = (ListenerEndpoint)future.get();
        System.out.print("Listening on " + listenerEndpoint.getAddress());
        server.awaitShutdown(TimeValue.MAX_VALUE);
    }
}

