/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.cluster.unit;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.cluster.unit.ClusterListUnitCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.UnitListOptionsMixin;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.UnitListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Shows a list of deployed units"})
public class ClusterUnitListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private UnitListOptionsMixin listOptions;
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private ClusterListUnitCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this.listOptions::toListUnitCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list units")).print(new UnitListDecorator(this.plain)));
    }
}

