/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sysprops.parser;

import org.apache.bifromq.sysprops.parser.PropParser;
import org.apache.bifromq.sysprops.parser.SysPropParseException;

public class LongParser
implements PropParser<Long> {
    public static final LongParser POSITIVE = new LongParser(1L, Long.MAX_VALUE);
    public static final LongParser NON_NEGATIVE = new LongParser(0L, Long.MAX_VALUE);
    private final long lowBound;
    private final long highBoundEx;

    private LongParser(long lowBound, long highBoundEx) {
        this.lowBound = lowBound;
        this.highBoundEx = highBoundEx;
    }

    @Override
    public Long parse(String value) {
        long val;
        long l = val = this.lowBound >= 0L ? Long.parseUnsignedLong(value) : Long.parseLong(value);
        if (this.lowBound <= val && val < this.highBoundEx) {
            return val;
        }
        throw new SysPropParseException(String.format("%d is out of bound [%d,%d)", val, this.lowBound, this.highBoundEx));
    }

    public static LongParser from(long lowBound, long highBoundEx) {
        assert (lowBound < highBoundEx);
        return new LongParser(lowBound, highBoundEx);
    }
}

