/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AuthenticationParameters;

@ApiModel(description="Bearer authentication directly embedded in request auth headers")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BearerAuthenticationParameters
extends AuthenticationParameters {
    private final String bearerToken;

    @ApiModelProperty(value="Bearer token (input-only)")
    @JsonProperty(value="bearerToken")
    public String getBearerToken() {
        return this.bearerToken;
    }

    @JsonCreator
    public BearerAuthenticationParameters(@JsonProperty(value="bearerToken") String bearerToken, @JsonProperty(value="authenticationType", required=true) AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.bearerToken = bearerToken;
    }

    public BearerAuthenticationParameters(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        super(authenticationType);
        this.bearerToken = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
        return new Builder(authenticationType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BearerAuthenticationParameters bearerAuthenticationParameters = (BearerAuthenticationParameters)o;
        return super.equals(o) && Objects.equals(this.bearerToken, bearerAuthenticationParameters.bearerToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bearerToken);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BearerAuthenticationParameters {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    bearerToken: ").append("*").append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String bearerToken;
        private AuthenticationParameters.AuthenticationTypeEnum authenticationType;

        private Builder() {
        }

        private Builder(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
        }

        public Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public Builder setAuthenticationType(AuthenticationParameters.AuthenticationTypeEnum authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public BearerAuthenticationParameters build() {
            BearerAuthenticationParameters inst = new BearerAuthenticationParameters(this.bearerToken, this.authenticationType);
            return inst;
        }
    }
}

