/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentFileParser;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.RESTFileScanTaskParser;
import org.apache.iceberg.util.JsonUtil;

public class TableScanResponseParser {
    static final String FILE_SCAN_TASKS = "file-scan-tasks";
    static final String DELETE_FILES = "delete-files";

    private TableScanResponseParser() {
    }

    public static List<DeleteFile> parseDeleteFiles(JsonNode node, Map<Integer, PartitionSpec> specsById) {
        if (node.has(DELETE_FILES)) {
            JsonNode deleteFiles = JsonUtil.get(DELETE_FILES, node);
            Preconditions.checkArgument((boolean)deleteFiles.isArray(), (String)"Cannot parse delete files from non-array: %s", (Object)deleteFiles);
            ImmutableList.Builder deleteFilesBuilder = ImmutableList.builder();
            for (JsonNode deleteFileNode : deleteFiles) {
                DeleteFile deleteFile = (DeleteFile)ContentFileParser.fromJson(deleteFileNode, specsById);
                deleteFilesBuilder.add((Object)deleteFile);
            }
            return deleteFilesBuilder.build();
        }
        return Lists.newArrayList();
    }

    public static List<FileScanTask> parseFileScanTasks(JsonNode node, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById, boolean caseSensitive) {
        if (node.has(FILE_SCAN_TASKS)) {
            JsonNode scanTasks = JsonUtil.get(FILE_SCAN_TASKS, node);
            Preconditions.checkArgument((boolean)scanTasks.isArray(), (String)"Cannot parse file scan tasks from non-array: %s", (Object)scanTasks);
            ArrayList fileScanTaskList = Lists.newArrayList();
            for (JsonNode fileScanTaskNode : scanTasks) {
                FileScanTask fileScanTask = RESTFileScanTaskParser.fromJson(fileScanTaskNode, deleteFiles, specsById, caseSensitive);
                fileScanTaskList.add(fileScanTask);
            }
            return fileScanTaskList;
        }
        return null;
    }

    public static void serializeScanTasks(List<FileScanTask> fileScanTasks, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById, JsonGenerator gen) throws IOException {
        HashMap deleteFilePathToIndex = Maps.newHashMap();
        if (deleteFiles != null && !deleteFiles.isEmpty()) {
            Preconditions.checkArgument((specsById != null ? 1 : 0) != 0, (Object)"Cannot serialize response without specs by ID defined");
            gen.writeArrayFieldStart(DELETE_FILES);
            for (int i = 0; i < deleteFiles.size(); ++i) {
                DeleteFile deleteFile = deleteFiles.get(i);
                deleteFilePathToIndex.put(String.valueOf(deleteFile.path()), i);
                ContentFileParser.toJson((ContentFile)deleteFiles.get(i), specsById.get(deleteFile.specId()), gen);
            }
            gen.writeEndArray();
        }
        if (fileScanTasks != null) {
            gen.writeArrayFieldStart(FILE_SCAN_TASKS);
            HashSet deleteFileReferences = Sets.newHashSet();
            for (FileScanTask fileScanTask : fileScanTasks) {
                PartitionSpec spec;
                if (deleteFiles != null) {
                    for (DeleteFile taskDelete : fileScanTask.deletes()) {
                        deleteFileReferences.add((Integer)deleteFilePathToIndex.get(taskDelete.path().toString()));
                    }
                }
                Preconditions.checkArgument(((spec = specsById.get(((DataFile)fileScanTask.file()).specId())) != null ? 1 : 0) != 0, (String)"Cannot serialize scan task with unknown spec %s", (int)((DataFile)fileScanTask.file()).specId());
                RESTFileScanTaskParser.toJson(fileScanTask, deleteFileReferences, spec, gen);
            }
            gen.writeEndArray();
        }
    }
}

