/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupSummariesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLogGroupsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, ListLogGroupsResponse> {
    private static final SdkField<List<LogGroupSummary>> LOG_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroups").getter(ListLogGroupsResponse.getter(ListLogGroupsResponse::logGroups)).setter(ListLogGroupsResponse.setter(Builder::logGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLogGroupsResponse.getter(ListLogGroupsResponse::nextToken)).setter(ListLogGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLogGroupsResponse.memberNameToFieldInitializer();
    private final List<LogGroupSummary> logGroups;
    private final String nextToken;

    private ListLogGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.logGroups = builder.logGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLogGroups() {
        return this.logGroups != null && !(this.logGroups instanceof SdkAutoConstructList);
    }

    public final List<LogGroupSummary> logGroups() {
        return this.logGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroups() ? this.logGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogGroupsResponse)) {
            return false;
        }
        ListLogGroupsResponse other = (ListLogGroupsResponse)((Object)obj);
        return this.hasLogGroups() == other.hasLogGroups() && Objects.equals(this.logGroups(), other.logGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLogGroupsResponse").add("LogGroups", this.hasLogGroups() ? this.logGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroups": {
                return Optional.ofNullable(clazz.cast(this.logGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logGroups", LOG_GROUPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLogGroupsResponse, T> g) {
        return obj -> g.apply((ListLogGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<LogGroupSummary> logGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogGroupsResponse model) {
            super(model);
            this.logGroups(model.logGroups);
            this.nextToken(model.nextToken);
        }

        public final List<LogGroupSummary.Builder> getLogGroups() {
            List<LogGroupSummary.Builder> result = LogGroupSummariesCopier.copyToBuilder(this.logGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogGroups(Collection<LogGroupSummary.BuilderImpl> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copyFromBuilder(logGroups);
        }

        @Override
        public final Builder logGroups(Collection<LogGroupSummary> logGroups) {
            this.logGroups = LogGroupSummariesCopier.copy(logGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(LogGroupSummary ... logGroups) {
            this.logGroups(Arrays.asList(logGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroups(Consumer<LogGroupSummary.Builder> ... logGroups) {
            this.logGroups(Stream.of(logGroups).map(c -> (LogGroupSummary)((LogGroupSummary.Builder)LogGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLogGroupsResponse build() {
            return new ListLogGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLogGroupsResponse> {
        public Builder logGroups(Collection<LogGroupSummary> var1);

        public Builder logGroups(LogGroupSummary ... var1);

        public Builder logGroups(Consumer<LogGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

