/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;

public abstract class PolarisStorageIntegration<T extends PolarisStorageConfigurationInfo> {
    private final String integrationIdentifierOrId;
    private final T config;

    public PolarisStorageIntegration(T config, String identifierOrId) {
        this.config = config;
        this.integrationIdentifierOrId = identifierOrId;
    }

    protected T config() {
        return this.config;
    }

    public String getStorageIdentifierOrId() {
        return this.integrationIdentifierOrId;
    }

    public abstract AccessConfig getSubscopedCreds(@Nonnull RealmConfig var1, boolean var2, @Nonnull Set<String> var3, @Nonnull Set<String> var4, Optional<String> var5);

    @Nonnull
    public abstract Map<String, Map<PolarisStorageActions, ValidationResult>> validateAccessToLocations(@Nonnull RealmConfig var1, @Nonnull T var2, @Nonnull Set<PolarisStorageActions> var3, @Nonnull Set<String> var4);

    public static final class ValidationResult {
        private final boolean success;
        private final String message;

        public ValidationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValidationResult)) {
                return false;
            }
            ValidationResult that = (ValidationResult)o;
            return this.success == that.success;
        }

        public int hashCode() {
            return Boolean.hashCode(this.success);
        }

        public String toString() {
            return "ValidationResult{success=" + this.success + ", message='" + this.message + "'}";
        }
    }
}

