/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.util.ObjectParser;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.services.storage.Storage;
import com.google.cloud.storage.ChecksumResponseParser;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.XmlObjectParser;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.ListPartsRequest;
import com.google.cloud.storage.multipartupload.model.ListPartsResponse;
import com.google.cloud.storage.multipartupload.model.UploadPartRequest;
import com.google.cloud.storage.multipartupload.model.UploadPartResponse;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MultipartUploadHttpRequestManager {
    private final HttpRequestFactory requestFactory;
    private final ObjectParser objectParser;
    private final HeaderProvider headerProvider;

    MultipartUploadHttpRequestManager(HttpRequestFactory requestFactory, ObjectParser objectParser, HeaderProvider headerProvider) {
        this.requestFactory = requestFactory;
        this.objectParser = objectParser;
        this.headerProvider = headerProvider;
    }

    CreateMultipartUploadResponse sendCreateMultipartUploadRequest(URI uri, CreateMultipartUploadRequest request) throws IOException {
        String createUri = UriTemplate.expand((String)(uri.toString() + "{bucket}/{key}?uploads"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(createUri), (HttpContent)new ByteArrayContent(request.getContentType(), new byte[0]));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        this.addHeadersForCreateMultipartUpload(request, httpRequest.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (CreateMultipartUploadResponse)httpRequest.execute().parseAs(CreateMultipartUploadResponse.class);
    }

    ListPartsResponse sendListPartsRequest(URI uri, ListPartsRequest request) throws IOException {
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"bucket", (Object)request.bucket()).put((Object)"key", (Object)request.key()).put((Object)"uploadId", (Object)request.uploadId());
        if (request.getMaxParts() != null) {
            params.put((Object)"max-parts", (Object)request.getMaxParts());
        }
        if (request.getPartNumberMarker() != null) {
            params.put((Object)"part-number-marker", (Object)request.getPartNumberMarker());
        }
        String listUri = UriTemplate.expand((String)(uri.toString() + "{bucket}/{key}{?uploadId,max-parts,part-number-marker}"), (Object)params.build(), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildGetRequest(new GenericUrl(listUri));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (ListPartsResponse)httpRequest.execute().parseAs(ListPartsResponse.class);
    }

    AbortMultipartUploadResponse sendAbortMultipartUploadRequest(URI uri, AbortMultipartUploadRequest request) throws IOException {
        String abortUri = UriTemplate.expand((String)(uri.toString() + "{bucket}/{key}{?uploadId}"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildDeleteRequest(new GenericUrl(abortUri));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (AbortMultipartUploadResponse)httpRequest.execute().parseAs(AbortMultipartUploadResponse.class);
    }

    CompleteMultipartUploadResponse sendCompleteMultipartUploadRequest(URI uri, CompleteMultipartUploadRequest request) throws IOException {
        String completeUri = UriTemplate.expand((String)(uri.toString() + "{bucket}/{key}{?uploadId}"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        byte[] bytes = new XmlMapper().writeValueAsBytes((Object)request.multipartUpload());
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(completeUri), (HttpContent)new ByteArrayContent("application/xml", bytes));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
         @Nullable Crc32cValue.Crc32cLengthKnown crc32cValue = Hasher.defaultHasher().hash(ByteBuffer.wrap(bytes));
        this.addChecksumHeader(crc32cValue, httpRequest.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return ChecksumResponseParser.parseCompleteResponse(httpRequest.execute());
    }

    UploadPartResponse sendUploadPartRequest(URI uri, UploadPartRequest request, RewindableContent rewindableContent) throws IOException {
        String uploadUri = UriTemplate.expand((String)(uri.toString() + "{bucket}/{key}{?partNumber,uploadId}"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"partNumber", (Object)request.partNumber(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildPutRequest(new GenericUrl(uploadUri), (HttpContent)rewindableContent);
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        this.addChecksumHeader(rewindableContent.getCrc32c(), httpRequest.getHeaders());
        httpRequest.setThrowExceptionOnExecuteError(true);
        return ChecksumResponseParser.parseUploadResponse(httpRequest.execute());
    }

    static MultipartUploadHttpRequestManager createFrom(HttpStorageOptions options) {
        Storage storage = options.getStorageRpcV1().getStorage();
        ImmutableMap.Builder stableHeaders = ImmutableMap.builder().put((Object)"User-Agent", (Object)("gcloud-java/" + options.getLibraryVersion())).put((Object)"x-goog-api-client", (Object)String.format("gl-java/%s gccl/%s %s/%s", GaxProperties.getJavaVersion(), options.getLibraryVersion(), MultipartUploadHttpRequestManager.formatName(StandardSystemProperty.OS_NAME.value()), MultipartUploadHttpRequestManager.formatSemver(StandardSystemProperty.OS_VERSION.value())));
        Utils.ifNonNull(options.getProjectId(), pid -> stableHeaders.put((Object)"x-goog-user-project", pid));
        return new MultipartUploadHttpRequestManager(storage.getRequestFactory(), new XmlObjectParser(new XmlMapper()), options.getMergedHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)stableHeaders.build())));
    }

    private void addChecksumHeader( @Nullable Crc32cValue.Crc32cLengthKnown crc32c, HttpHeaders headers) {
        if (crc32c != null) {
            headers.put("x-goog-hash", (Object)("crc32c=" + (String)Utils.crc32cCodec.encode(crc32c.getValue())));
        }
    }

    private void addHeadersForCreateMultipartUpload(CreateMultipartUploadRequest request, HttpHeaders headers) {
        if (request.getCannedAcl() != null) {
            headers.put("x-goog-acl", (Object)request.getCannedAcl().getXmlEntry());
        }
        if (request.getMetadata() != null) {
            for (Map.Entry<String, String> entry : request.getMetadata().entrySet()) {
                if (entry.getKey() == null && entry.getValue() == null) continue;
                headers.put("x-goog-meta-" + MultipartUploadHttpRequestManager.urlEncode(entry.getKey()), (Object)MultipartUploadHttpRequestManager.urlEncode(entry.getValue()));
            }
        }
        if (request.getContentType() != null) {
            headers.put("Content-Type", (Object)request.getContentType());
        }
        if (request.getStorageClass() != null) {
            headers.put("x-goog-storage-class", (Object)request.getStorageClass().toString());
        }
        if (request.getKmsKeyName() != null && !request.getKmsKeyName().isEmpty()) {
            headers.put("x-goog-encryption-kms-key-name", (Object)request.getKmsKeyName());
        }
        if (request.getObjectLockMode() != null) {
            headers.put("x-goog-object-lock-mode", (Object)request.getObjectLockMode().toString());
        }
        if (request.getObjectLockRetainUntilDate() != null) {
            headers.put("x-goog-object-lock-retain-until-date", Utils.offsetDateTimeRfc3339Codec.encode(request.getObjectLockRetainUntilDate()));
        }
        if (request.getCustomTime() != null) {
            headers.put("x-goog-custom-time", Utils.offsetDateTimeRfc3339Codec.encode(request.getCustomTime()));
        }
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(0, "Unable to load UTF-8 charset for encoding", e);
        }
    }

    private static String formatName(String name) {
        return name.toLowerCase().replaceAll("[^\\w\\d\\-]", "-");
    }

    private static String formatSemver(String version) {
        return MultipartUploadHttpRequestManager.formatSemver(version, version);
    }

    private static String formatSemver(String version, String defaultValue) {
        if (version == null) {
            return null;
        }
        Matcher m = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*").matcher(version);
        if (m.find()) {
            return m.group(1);
        }
        return defaultValue;
    }
}

