/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.heartbeat;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.PipeRuntimeCoordinator;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.thrift.async.AsyncMethodCallback;

public class DataNodeHeartbeatHandler
implements AsyncMethodCallback<TDataNodeHeartbeatResp> {
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final boolean SCHEMA_REGION_SHOULD_CACHE_CONSENSUS_SAMPLE = "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(CONF.getSchemaRegionConsensusProtocolClass());
    private static final boolean DATA_REGION_SHOULD_CACHE_CONSENSUS_SAMPLE = "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(CONF.getDataRegionConsensusProtocolClass());
    private final int nodeId;
    private final LoadManager loadManager;
    private final Map<Integer, Long> deviceNum;
    private final Map<Integer, Long> timeSeriesNum;
    private final Map<Integer, Long> regionDisk;
    private final Consumer<Map<Integer, Long>> seriesUsageRespProcess;
    private final Consumer<Map<Integer, Long>> deviceUsageRespProcess;
    private final PipeRuntimeCoordinator pipeRuntimeCoordinator;

    public DataNodeHeartbeatHandler(int nodeId, LoadManager loadManager, Map<Integer, Long> deviceNum, Map<Integer, Long> timeSeriesNum, Map<Integer, Long> regionDisk, Consumer<Map<Integer, Long>> seriesUsageRespProcess, Consumer<Map<Integer, Long>> deviceUsageRespProcess, PipeRuntimeCoordinator pipeRuntimeCoordinator) {
        this.nodeId = nodeId;
        this.loadManager = loadManager;
        this.deviceNum = deviceNum;
        this.timeSeriesNum = timeSeriesNum;
        this.regionDisk = regionDisk;
        this.seriesUsageRespProcess = seriesUsageRespProcess;
        this.deviceUsageRespProcess = deviceUsageRespProcess;
        this.pipeRuntimeCoordinator = pipeRuntimeCoordinator;
    }

    public void onComplete(TDataNodeHeartbeatResp heartbeatResp) {
        this.loadManager.getLoadCache().cacheDataNodeHeartbeatSample(this.nodeId, new NodeHeartbeatSample(heartbeatResp));
        RegionStatus regionStatus = RegionStatus.valueOf((String)heartbeatResp.getStatus());
        heartbeatResp.getJudgedLeaders().forEach((regionGroupId, isLeader) -> {
            RegionStatus nextRegionStatus = regionStatus;
            if (nextRegionStatus == RegionStatus.Removing) {
                nextRegionStatus = this.loadManager.getLoadCache().getRegionCacheLastSampleStatus((TConsensusGroupId)regionGroupId, this.nodeId);
            }
            this.loadManager.getLoadCache().cacheRegionHeartbeatSample((TConsensusGroupId)regionGroupId, this.nodeId, new RegionHeartbeatSample(heartbeatResp.getHeartbeatTimestamp(), nextRegionStatus), false);
            if ((TConsensusGroupType.SchemaRegion.equals((Object)regionGroupId.getType()) && SCHEMA_REGION_SHOULD_CACHE_CONSENSUS_SAMPLE || TConsensusGroupType.DataRegion.equals((Object)regionGroupId.getType()) && DATA_REGION_SHOULD_CACHE_CONSENSUS_SAMPLE) && Boolean.TRUE.equals(isLeader)) {
                this.loadManager.getLoadCache().cacheConsensusSample((TConsensusGroupId)regionGroupId, new ConsensusGroupHeartbeatSample((Long)heartbeatResp.getConsensusLogicalTimeMap().get(regionGroupId), this.nodeId));
            }
        });
        if (heartbeatResp.getRegionDeviceUsageMap() != null) {
            this.deviceNum.putAll(heartbeatResp.getRegionDeviceUsageMap());
            this.deviceUsageRespProcess.accept(heartbeatResp.getRegionDeviceUsageMap());
        }
        if (heartbeatResp.getRegionSeriesUsageMap() != null) {
            this.timeSeriesNum.putAll(heartbeatResp.getRegionSeriesUsageMap());
            this.seriesUsageRespProcess.accept(heartbeatResp.getRegionSeriesUsageMap());
        }
        if (heartbeatResp.getRegionDisk() != null) {
            this.regionDisk.putAll(heartbeatResp.getRegionDisk());
        }
        if (heartbeatResp.getPipeMetaList() != null) {
            this.pipeRuntimeCoordinator.parseHeartbeat(this.nodeId, heartbeatResp.getPipeMetaList(), heartbeatResp.getPipeCompletedList(), heartbeatResp.getPipeRemainingEventCountList(), heartbeatResp.getPipeRemainingTimeList());
        }
        if (heartbeatResp.isSetConfirmedConfigNodeEndPoints()) {
            this.loadManager.getLoadCache().updateConfirmedConfigNodeEndPoints(this.nodeId, heartbeatResp.getConfirmedConfigNodeEndPoints());
        }
        if (heartbeatResp.isSetRegionDisk()) {
            this.loadManager.getLoadCache().updateRegionSizeMap(this.nodeId, heartbeatResp.getRegionDisk());
        }
    }

    public void onError(Exception e) {
        if (ThriftClient.isConnectionBroken((Throwable)e)) {
            this.loadManager.forceUpdateNodeCache(NodeType.DataNode, this.nodeId, new NodeHeartbeatSample(NodeStatus.Unknown));
        }
        this.loadManager.getLoadCache().resetHeartbeatProcessing(this.nodeId);
    }
}

