/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ShowQueriesOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private TsBlock tsBlock;
    private boolean hasConsumed;
    private final Coordinator coordinator;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ShowQueriesOperator.class);

    public ShowQueriesOperator(OperatorContext operatorContext, PlanNodeId sourceId, Coordinator coordinator) {
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.coordinator = coordinator;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.tsBlock;
        this.hasConsumed = true;
        this.tsBlock = null;
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.hasConsumed) {
            return false;
        }
        if (this.tsBlock == null) {
            this.tsBlock = this.buildTsBlock();
        }
        return true;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.hasConsumed;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long calculateMaxPeekMemory() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    private TsBlock buildTsBlock() {
        List<TSDataType> outputDataTypes = DatasetHeaderFactory.getShowQueriesHeader().getRespDataTypes();
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        List<IQueryExecution> queryExecutions = this.coordinator.getAllQueryExecutions();
        if (!queryExecutions.isEmpty()) {
            TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = builder.getValueColumnBuilders();
            long currTime = System.currentTimeMillis();
            String[] splits = queryExecutions.get(0).getQueryId().split("_");
            int dataNodeId = Integer.parseInt(splits[splits.length - 1]);
            for (IQueryExecution queryExecution : queryExecutions) {
                timeColumnBuilder.writeLong(TimestampPrecisionUtils.convertToCurrPrecision(queryExecution.getStartExecutionTime(), TimeUnit.MILLISECONDS));
                columnBuilders[0].writeBinary(BytesUtils.valueOf((String)queryExecution.getQueryId()));
                columnBuilders[1].writeInt(dataNodeId);
                columnBuilders[2].writeFloat((float)(currTime - queryExecution.getStartExecutionTime()) / 1000.0f);
                columnBuilders[3].writeBinary(BytesUtils.valueOf((String)queryExecution.getExecuteSQL().orElse("UNKNOWN")));
                builder.declarePosition();
            }
        }
        return builder.build();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId);
    }
}

