/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CreateSubscriptionResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=788");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=790");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=789");
    private final ResponseHeader responseHeader;
    private final UInteger subscriptionId;
    private final Double revisedPublishingInterval;
    private final UInteger revisedLifetimeCount;
    private final UInteger revisedMaxKeepAliveCount;

    public CreateSubscriptionResponse(ResponseHeader responseHeader, UInteger subscriptionId, Double revisedPublishingInterval, UInteger revisedLifetimeCount, UInteger revisedMaxKeepAliveCount) {
        this.responseHeader = responseHeader;
        this.subscriptionId = subscriptionId;
        this.revisedPublishingInterval = revisedPublishingInterval;
        this.revisedLifetimeCount = revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public Double getRevisedPublishingInterval() {
        return this.revisedPublishingInterval;
    }

    public UInteger getRevisedLifetimeCount() {
        return this.revisedLifetimeCount;
    }

    public UInteger getRevisedMaxKeepAliveCount() {
        return this.revisedMaxKeepAliveCount;
    }

    protected CreateSubscriptionResponse(CreateSubscriptionResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((CreateSubscriptionResponseBuilder)b).responseHeader;
        this.subscriptionId = ((CreateSubscriptionResponseBuilder)b).subscriptionId;
        this.revisedPublishingInterval = ((CreateSubscriptionResponseBuilder)b).revisedPublishingInterval;
        this.revisedLifetimeCount = ((CreateSubscriptionResponseBuilder)b).revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = ((CreateSubscriptionResponseBuilder)b).revisedMaxKeepAliveCount;
    }

    public static CreateSubscriptionResponseBuilder<?, ?> builder() {
        return new CreateSubscriptionResponseBuilderImpl();
    }

    public CreateSubscriptionResponseBuilder<?, ?> toBuilder() {
        return new CreateSubscriptionResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSubscriptionResponse)) {
            return false;
        }
        CreateSubscriptionResponse other = (CreateSubscriptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$revisedPublishingInterval = this.getRevisedPublishingInterval();
        Double other$revisedPublishingInterval = other.getRevisedPublishingInterval();
        if (this$revisedPublishingInterval == null ? other$revisedPublishingInterval != null : !((Object)this$revisedPublishingInterval).equals(other$revisedPublishingInterval)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UInteger this$revisedLifetimeCount = this.getRevisedLifetimeCount();
        UInteger other$revisedLifetimeCount = other.getRevisedLifetimeCount();
        if (this$revisedLifetimeCount == null ? other$revisedLifetimeCount != null : !((Object)this$revisedLifetimeCount).equals(other$revisedLifetimeCount)) {
            return false;
        }
        UInteger this$revisedMaxKeepAliveCount = this.getRevisedMaxKeepAliveCount();
        UInteger other$revisedMaxKeepAliveCount = other.getRevisedMaxKeepAliveCount();
        return !(this$revisedMaxKeepAliveCount == null ? other$revisedMaxKeepAliveCount != null : !((Object)this$revisedMaxKeepAliveCount).equals(other$revisedMaxKeepAliveCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateSubscriptionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $revisedPublishingInterval = this.getRevisedPublishingInterval();
        result = result * 59 + ($revisedPublishingInterval == null ? 43 : ((Object)$revisedPublishingInterval).hashCode());
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UInteger $revisedLifetimeCount = this.getRevisedLifetimeCount();
        result = result * 59 + ($revisedLifetimeCount == null ? 43 : ((Object)$revisedLifetimeCount).hashCode());
        UInteger $revisedMaxKeepAliveCount = this.getRevisedMaxKeepAliveCount();
        result = result * 59 + ($revisedMaxKeepAliveCount == null ? 43 : ((Object)$revisedMaxKeepAliveCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CreateSubscriptionResponse(responseHeader=" + this.getResponseHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", revisedPublishingInterval=" + this.getRevisedPublishingInterval() + ", revisedLifetimeCount=" + this.getRevisedLifetimeCount() + ", revisedMaxKeepAliveCount=" + this.getRevisedMaxKeepAliveCount() + ")";
    }

    private static final class CreateSubscriptionResponseBuilderImpl
    extends CreateSubscriptionResponseBuilder<CreateSubscriptionResponse, CreateSubscriptionResponseBuilderImpl> {
        private CreateSubscriptionResponseBuilderImpl() {
        }

        @Override
        protected CreateSubscriptionResponseBuilderImpl self() {
            return this;
        }

        @Override
        public CreateSubscriptionResponse build() {
            return new CreateSubscriptionResponse(this);
        }
    }

    public static abstract class CreateSubscriptionResponseBuilder<C extends CreateSubscriptionResponse, B extends CreateSubscriptionResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private UInteger subscriptionId;
        private Double revisedPublishingInterval;
        private UInteger revisedLifetimeCount;
        private UInteger revisedMaxKeepAliveCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateSubscriptionResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CreateSubscriptionResponse instance, CreateSubscriptionResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.subscriptionId(instance.subscriptionId);
            b.revisedPublishingInterval(instance.revisedPublishingInterval);
            b.revisedLifetimeCount(instance.revisedLifetimeCount);
            b.revisedMaxKeepAliveCount(instance.revisedMaxKeepAliveCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B revisedPublishingInterval(Double revisedPublishingInterval) {
            this.revisedPublishingInterval = revisedPublishingInterval;
            return (B)this.self();
        }

        public B revisedLifetimeCount(UInteger revisedLifetimeCount) {
            this.revisedLifetimeCount = revisedLifetimeCount;
            return (B)this.self();
        }

        public B revisedMaxKeepAliveCount(UInteger revisedMaxKeepAliveCount) {
            this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateSubscriptionResponse.CreateSubscriptionResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", subscriptionId=" + this.subscriptionId + ", revisedPublishingInterval=" + this.revisedPublishingInterval + ", revisedLifetimeCount=" + this.revisedLifetimeCount + ", revisedMaxKeepAliveCount=" + this.revisedMaxKeepAliveCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CreateSubscriptionResponse> {
        @Override
        public Class<CreateSubscriptionResponse> getType() {
            return CreateSubscriptionResponse.class;
        }

        @Override
        public CreateSubscriptionResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            Double revisedPublishingInterval = decoder.readDouble("RevisedPublishingInterval");
            UInteger revisedLifetimeCount = decoder.readUInt32("RevisedLifetimeCount");
            UInteger revisedMaxKeepAliveCount = decoder.readUInt32("RevisedMaxKeepAliveCount");
            return new CreateSubscriptionResponse(responseHeader, subscriptionId, revisedPublishingInterval, revisedLifetimeCount, revisedMaxKeepAliveCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CreateSubscriptionResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeDouble("RevisedPublishingInterval", value.getRevisedPublishingInterval());
            encoder.writeUInt32("RevisedLifetimeCount", value.getRevisedLifetimeCount());
            encoder.writeUInt32("RevisedMaxKeepAliveCount", value.getRevisedMaxKeepAliveCount());
        }
    }
}

