/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.NoneClassStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAId;

public class ClassMapping
extends ClassMetaData
implements ClassStrategy {
    private static final long serialVersionUID = 1L;
    public static final ClassMapping[] EMPTY_MAPPINGS = new ClassMapping[0];
    private static final Localizer _loc = Localizer.forPackage(ClassMapping.class);
    private final ClassMappingInfo _info;
    private final Discriminator _discrim;
    private final Version _version;
    private ClassStrategy _strategy = null;
    private Table _table = null;
    private ColumnIO _io = null;
    private Column[] _cols = Schemas.EMPTY_COLUMNS;
    private ForeignKey _fk = null;
    private int _subclassMode = Integer.MAX_VALUE;
    private ClassMapping[] _joinSubMaps = null;
    private ClassMapping[] _assignMaps = null;
    private final Map _joinables = new ConcurrentHashMap();

    protected ClassMapping(Class type, MappingRepository repos) {
        super(type, repos);
        this._discrim = repos.newDiscriminator(this);
        this._version = repos.newVersion(this);
        this._info = repos.newMappingInfo(this);
    }

    protected ClassMapping(ValueMetaData vmd) {
        super(vmd);
        this._discrim = this.getMappingRepository().newDiscriminator(this);
        this._version = this.getMappingRepository().newVersion(this);
        this._info = this.getMappingRepository().newMappingInfo(this);
    }

    public Discriminator getDiscriminator() {
        return this._discrim;
    }

    public Version getVersion() {
        return this._version;
    }

    public Object getObjectId(JDBCStore store, Result res, ForeignKey fk, boolean subs, Joins joins) throws SQLException {
        ValueMapping embed = this.getEmbeddingMapping();
        if (embed != null) {
            return embed.getFieldMapping().getDefiningMapping().getObjectId(store, res, fk, subs, joins);
        }
        return this.getObjectId(this, store, res, fk, subs, joins);
    }

    private Object getObjectId(ClassMapping cls, JDBCStore store, Result res, ForeignKey fk, boolean subs, Joins joins) throws SQLException {
        Object oid;
        if (!this.isPrimaryKeyObjectId(true)) {
            return this.getPCSuperclassMapping().getObjectId(cls, store, res, fk, subs, joins);
        }
        if (this.getIdentityType() == 0) {
            throw new InternalException();
        }
        Column[] pks = this.getPrimaryKeyColumns();
        if (this.getIdentityType() == 1) {
            Column col = fk == null ? pks[0] : fk.getColumn(pks[0]);
            long id = res.getLong(col, joins);
            return id == 0L && res.wasNull() ? null : store.newDataStoreId(id, cls, subs);
        }
        Object[] vals = new Object[this.getPrimaryKeyFields().length];
        boolean canReadDiscriminator = true;
        boolean isNullPK = true;
        for (Column pk : pks) {
            Joinable join = this.assertJoinable(pk);
            FieldMapping fm = this.getFieldMapping(join.getFieldIndex());
            int pkIdx = fm.getPrimaryKeyIndex();
            canReadDiscriminator &= this.isSelfReference(fk, join.getColumns());
            if (vals[pkIdx] != null) continue;
            res.startDataRequest(fm);
            vals[pkIdx] = join.getPrimaryKeyValue(res, join.getColumns(), fk, store, joins);
            res.endDataRequest();
            isNullPK = isNullPK && vals[pkIdx] == null;
        }
        if (isNullPK) {
            return null;
        }
        ClassMapping dcls = cls;
        if (subs && canReadDiscriminator) {
            res.startDataRequest(cls.getDiscriminator());
            try {
                Class<?> dtype = cls.getDiscriminator().getClass(store, cls, res);
                if (dtype != cls.getDescribedType()) {
                    dcls = cls.getMappingRepository().getMapping(dtype, store.getContext().getClassLoader(), true);
                }
            }
            catch (Exception dtype) {
                // empty catch block
            }
            res.endDataRequest();
        }
        if ((oid = ApplicationIds.fromPKValues(vals, dcls)) instanceof OpenJPAId) {
            ((OpenJPAId)oid).setManagedInstanceType(dcls.getDescribedType(), subs);
        }
        return oid;
    }

    boolean isSelfReference(ForeignKey fk, Column[] cols) {
        if (fk == null) {
            return true;
        }
        for (Column col : cols) {
            if (fk.getColumn(col) == col) continue;
            return false;
        }
        return true;
    }

    public Object toDataStoreValue(Object obj, Column[] cols, JDBCStore store) {
        OpenJPAStateManager sm;
        Object ret;
        Object[] objectArray = ret = cols.length == 1 ? null : new Object[cols.length];
        if (ImplHelper.isManageable(obj)) {
            PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, this.getRepository().getConfiguration());
            sm = (OpenJPAStateManager)pc.pcGetStateManager();
            if (sm == null) {
                ret = this.getValueFromUnmanagedInstance(obj, cols, true);
                FieldMapping[] fmsPK = this.getPrimaryKeyFieldMappings();
                List<FieldMapping> fms = this.getFieldMappings(cols, true);
                if (fmsPK.length > 0 && fmsPK[0].isEmbedded() && cols.length > 1 && fms.size() == 1) {
                    Object[] tmpRet = new Object[cols.length];
                    for (int i = 0; i < cols.length; ++i) {
                        Joinable join = this.assertJoinable(cols[i]);
                        tmpRet[i] = join.getJoinValue(ret, cols[i], store);
                    }
                    ret = tmpRet;
                }
            } else if (sm.isDetached()) {
                obj = store.getContext().find(sm.getObjectId(), false, null);
                sm = store.getContext().getStateManager(obj);
            }
        } else {
            sm = store.getContext().getStateManager(obj);
        }
        if (sm == null) {
            return ret;
        }
        for (int i = 0; i < cols.length; ++i) {
            Object val = this.assertJoinable(cols[i]).getJoinValue(sm, cols[i], store);
            if (cols.length == 1) {
                ret = val;
                continue;
            }
            ret[i] = val;
        }
        return ret;
    }

    public Joinable assertJoinable(Column col) {
        Joinable join = this.getJoinable(col);
        if (join == null) {
            throw new MetaDataException(_loc.get("no-joinable", col.getQualifiedPath().toString()));
        }
        return join;
    }

    public Joinable getJoinable(Column col) {
        Joinable join;
        if (this.getEmbeddingMetaData() != null && (join = this.getEmbeddingMapping().getFieldMapping().getDefiningMapping().getJoinable(col)) != null) {
            return join;
        }
        ClassMapping sup = this.getJoinablePCSuperclassMapping();
        if (sup != null && (join = sup.getJoinable(col)) != null) {
            return join;
        }
        return (Joinable)this._joinables.get(col);
    }

    public void setJoinable(Column col, Joinable joinable) {
        Joinable join = (Joinable)this._joinables.get(col);
        if (join == null || join.getFieldIndex() != -1 && this.getField(join.getFieldIndex()).getPrimaryKeyIndex() == -1) {
            this._joinables.put(col, joinable);
        }
    }

    public Boolean isForeignKeyObjectId(ForeignKey fk) {
        if (this.getIdentityType() == 0 || !this.isPrimaryKeyObjectId(false)) {
            return Boolean.FALSE;
        }
        Column[] cols = fk.getPrimaryKeyColumns();
        if (this.getIdentityType() == 1) {
            if (cols.length != 1 || cols[0] != this.getPrimaryKeyColumns()[0]) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        for (Column col : cols) {
            Joinable join = this.assertJoinable(col);
            if (join.getFieldIndex() == -1 || this.getField(join.getFieldIndex()).getPrimaryKeyIndex() != -1) continue;
            return Boolean.FALSE;
        }
        if (this.isPrimaryKeyObjectId(true) && cols.length == this.getPrimaryKeyColumns().length) {
            return Boolean.TRUE;
        }
        return null;
    }

    public ClassMappingInfo getMappingInfo() {
        return this._info;
    }

    public ClassStrategy getStrategy() {
        return this._strategy;
    }

    public void setStrategy(ClassStrategy strategy, Boolean adapt) {
        ClassStrategy orig = this._strategy;
        this._strategy = strategy;
        if (strategy != null) {
            try {
                strategy.setClassMapping(this);
                if (adapt != null) {
                    strategy.map(adapt);
                }
            }
            catch (RuntimeException re) {
                this._strategy = orig;
                throw re;
            }
        }
    }

    public Table getTable() {
        return this._table;
    }

    public void setTable(Table table) {
        this._table = table;
    }

    public Column[] getPrimaryKeyColumns() {
        if (this.getIdentityType() == 2 && this.isMapped() && this._cols.length == 0) {
            FieldMapping[] pks = this.getPrimaryKeyFieldMappings();
            ArrayList<Column> cols = new ArrayList<Column>(pks.length);
            for (FieldMapping pk : pks) {
                Column[] fieldCols = pk.getColumns();
                if (fieldCols.length == 0) {
                    this._cols = new Column[0];
                    return this._cols;
                }
                for (Column fieldCol : fieldCols) {
                    cols.add(fieldCol);
                }
            }
            this._cols = cols.toArray(new Column[cols.size()]);
        }
        return this._cols;
    }

    public void setPrimaryKeyColumns(Column[] cols) {
        if (cols == null) {
            cols = Schemas.EMPTY_COLUMNS;
        }
        this._cols = cols;
    }

    public ColumnIO getColumnIO() {
        return this._io == null ? ColumnIO.UNRESTRICTED : this._io;
    }

    public void setColumnIO(ColumnIO io) {
        this._io = io;
    }

    public ForeignKey getJoinForeignKey() {
        return this._fk;
    }

    public void setJoinForeignKey(ForeignKey fk) {
        this._fk = fk;
    }

    public void refSchemaComponents() {
        if (this.getEmbeddingMetaData() == null) {
            Column[] pks;
            if (this._table != null && this._table.getPrimaryKey() != null) {
                this._table.getPrimaryKey().ref();
            }
            if (this._fk != null) {
                this._fk.ref();
            }
            for (Column pk : pks = this.getPrimaryKeyColumns()) {
                pk.ref();
            }
        } else {
            FieldMapping[] fields;
            for (FieldMapping field : fields = this.getFieldMappings()) {
                field.refSchemaComponents();
            }
        }
    }

    public void clearMapping() {
        this._strategy = null;
        this._cols = Schemas.EMPTY_COLUMNS;
        this._fk = null;
        this._table = null;
        this._info.clear();
        this.setResolve(10, false);
    }

    public void syncMappingInfo() {
        if (this.getEmbeddingMetaData() == null) {
            this._info.syncWith(this);
        } else {
            FieldMapping[] fields;
            this._info.clear();
            for (FieldMapping field : fields = this.getFieldMappings()) {
                field.syncMappingInfo();
            }
        }
    }

    protected void setDescribedType(Class type) {
        super.setDescribedType(type);
        if (this._info != null) {
            this._info.setClassName(type.getName());
        }
    }

    public int getSubclassFetchMode() {
        if (this._subclassMode == Integer.MAX_VALUE) {
            this._subclassMode = this.getPCSuperclass() != null ? this.getPCSuperclassMapping().getSubclassFetchMode() : -99;
        }
        return this._subclassMode;
    }

    public void setSubclassFetchMode(int mode) {
        this._subclassMode = mode;
    }

    public MappingRepository getMappingRepository() {
        return (MappingRepository)this.getRepository();
    }

    public ValueMapping getEmbeddingMapping() {
        return (ValueMapping)this.getEmbeddingMetaData();
    }

    @Override
    public boolean isMapped() {
        if (!super.isMapped()) {
            return false;
        }
        if (this._strategy != null) {
            return this._strategy != NoneClassStrategy.getInstance();
        }
        return !"none".equals(this._info.getStrategy());
    }

    public ClassMapping getPCSuperclassMapping() {
        return (ClassMapping)this.getPCSuperclassMetaData();
    }

    public ClassMapping getMappedPCSuperclassMapping() {
        return (ClassMapping)this.getMappedPCSuperclassMetaData();
    }

    public ClassMapping getJoinablePCSuperclassMapping() {
        ClassMapping sup = this.getMappedPCSuperclassMapping();
        if (sup == null) {
            return null;
        }
        if (this._fk != null || this._table == null || this._table.equals(sup.getTable())) {
            return sup;
        }
        return null;
    }

    public ClassMapping[] getPCSubclassMappings() {
        return (ClassMapping[])this.getPCSubclassMetaDatas();
    }

    public ClassMapping[] getMappedPCSubclassMappings() {
        return (ClassMapping[])this.getMappedPCSubclassMetaDatas();
    }

    public ClassMapping[] getJoinablePCSubclassMappings() {
        ClassMapping[] subs = this.getMappedPCSubclassMappings();
        if (this._joinSubMaps == null) {
            if (subs.length == 0) {
                this._joinSubMaps = subs;
            } else {
                ArrayList<ClassMapping> joinable = new ArrayList<ClassMapping>(subs.length);
                for (ClassMapping sub : subs) {
                    if (!this.isSubJoinable(sub)) continue;
                    joinable.add(sub);
                }
                this._joinSubMaps = joinable.toArray(new ClassMapping[joinable.size()]);
            }
        }
        return this._joinSubMaps;
    }

    private boolean isSubJoinable(ClassMapping sub) {
        if (sub == null) {
            return false;
        }
        if (sub == this) {
            return true;
        }
        return this.isSubJoinable(sub.getJoinablePCSuperclassMapping());
    }

    public ClassMapping[] getIndependentAssignableMappings() {
        ClassMapping[] subs = this.getMappedPCSubclassMappings();
        if (this._assignMaps == null) {
            if (subs.length == 0) {
                this._assignMaps = this.isMapped() ? new ClassMapping[]{this} : subs;
            } else {
                int size = (int)((double)subs.length * 1.33 + 2.0);
                LinkedHashSet<ClassMapping> independent = new LinkedHashSet<ClassMapping>(size);
                if (this.isMapped()) {
                    independent.add(this);
                }
                independent.addAll(Arrays.asList(subs));
                ArrayList<ClassMapping> clear = null;
                for (Object e : independent) {
                    ClassMapping map = (ClassMapping)e;
                    ClassMapping sup = map.getJoinablePCSuperclassMapping();
                    if (sup == null || !independent.contains(sup)) continue;
                    if (clear == null) {
                        clear = new ArrayList<ClassMapping>(independent.size() - 1);
                    }
                    clear.add(map);
                }
                if (clear != null) {
                    independent.removeAll(clear);
                }
                this._assignMaps = independent.toArray(new ClassMapping[independent.size()]);
            }
        }
        return this._assignMaps;
    }

    public FieldMapping[] getFieldMappings() {
        return (FieldMapping[])this.getFields();
    }

    public FieldMapping[] getDeclaredFieldMappings() {
        return (FieldMapping[])this.getDeclaredFields();
    }

    public FieldMapping[] getPrimaryKeyFieldMappings() {
        return (FieldMapping[])this.getPrimaryKeyFields();
    }

    public FieldMapping getVersionFieldMapping() {
        return (FieldMapping)this.getVersionField();
    }

    public FieldMapping[] getDefaultFetchGroupFieldMappings() {
        return (FieldMapping[])this.getDefaultFetchGroupFields();
    }

    public FieldMapping[] getDefinedFieldMappings() {
        return (FieldMapping[])this.getDefinedFields();
    }

    public FieldMapping[] getFieldMappingsInListingOrder() {
        return (FieldMapping[])this.getFieldsInListingOrder();
    }

    public FieldMapping[] getDefinedFieldMappingsInListingOrder() {
        return (FieldMapping[])this.getDefinedFieldsInListingOrder();
    }

    public FieldMapping getFieldMapping(int index) {
        return (FieldMapping)this.getField(index);
    }

    public FieldMapping getDeclaredFieldMapping(int index) {
        return (FieldMapping)this.getDeclaredField(index);
    }

    public FieldMapping getFieldMapping(String name) {
        return (FieldMapping)this.getField(name);
    }

    public FieldMapping getDeclaredFieldMapping(String name) {
        return (FieldMapping)this.getDeclaredField(name);
    }

    public FieldMapping[] getDeclaredUnmanagedFieldMappings() {
        return (FieldMapping[])this.getDeclaredUnmanagedFields();
    }

    public FieldMapping addDeclaredFieldMapping(String name, Class type) {
        return (FieldMapping)this.addDeclaredField(name, type);
    }

    @Override
    protected void resolveMapping(boolean runtime) {
        FieldMapping[] fms;
        Log log;
        super.resolveMapping(runtime);
        MappingRepository repos = this.getMappingRepository();
        if (this._strategy == null) {
            repos.getStrategyInstaller().installStrategy(this);
        }
        if ((log = this.getRepository().getLog()).isTraceEnabled()) {
            log.trace(_loc.get("strategy", this, this._strategy.getAlias()));
        }
        this.defineSuperclassFields(this.getJoinablePCSuperclassMapping() == null);
        this.resolveNonRelationMappings();
        for (FieldMapping fieldMapping : fms = this.getFieldMappings()) {
            if (fieldMapping.getDefiningMetaData() != this) continue;
            boolean fill = this.getMappingRepository().getMappingDefaults().defaultMissingInfo();
            ForeignKey fk = fieldMapping.getForeignKey();
            if (fill && fk != null && fk.getPrimaryKeyColumns().length == 0) {
                fieldMapping.setResolve(1);
                if (fieldMapping.getStrategy() != null) {
                    fieldMapping.getStrategy().map(false);
                }
            }
            fieldMapping.resolve(2);
        }
        for (FieldMapping fm : fms = this.getDeclaredUnmanagedFieldMappings()) {
            fm.resolve(2);
        }
        if (this._cols != null) {
            ColumnIO io = this.getColumnIO();
            for (int i = 0; i < this._cols.length; ++i) {
                if (io.isInsertable(i, false)) {
                    this._cols[i].setFlag(8, true);
                }
                if (!io.isUpdatable(i, false)) continue;
                this._cols[i].setFlag(16, true);
            }
        }
        this._info.getUniques(this, true);
        this._info.getIndices(this, true);
    }

    void resolveNonRelationMappings() {
        FieldMapping[] fms;
        for (FieldMapping fieldMapping : fms = this.getPrimaryKeyFieldMappings()) {
            fieldMapping.resolve(2);
        }
        for (FieldMapping fm : fms = this.getFieldMappings()) {
            if (fm.getDefiningMetaData() != this || fm.isTypePC() || fm.getKey().isTypePC() || fm.getElement().isTypePC()) continue;
            fm.resolve(2);
        }
        this._discrim.resolve(2);
        this._version.resolve(2);
    }

    @Override
    protected void initializeMapping() {
        FieldMapping[] fields;
        super.initializeMapping();
        for (FieldMapping field : fields = this.getDefinedFieldMappings()) {
            field.resolve(8);
        }
        this._discrim.resolve(8);
        this._version.resolve(8);
        this._strategy.initialize();
    }

    @Override
    protected void clearDefinedFieldCache() {
        super.clearDefinedFieldCache();
    }

    @Override
    protected void clearSubclassCache() {
        super.clearSubclassCache();
        this._joinSubMaps = null;
        this._assignMaps = null;
    }

    @Override
    public void copy(ClassMetaData cls) {
        super.copy(cls);
        if (this._subclassMode == Integer.MAX_VALUE) {
            this._subclassMode = ((ClassMapping)cls).getSubclassFetchMode();
        }
    }

    @Override
    protected boolean validateDataStoreExtensionPrefix(String prefix) {
        return "jdbc-".equals(prefix);
    }

    @Override
    public String getAlias() {
        return this.assertStrategy().getAlias();
    }

    @Override
    public void map(boolean adapt) {
        this.assertStrategy().map(adapt);
    }

    @Override
    public void initialize() {
        this.assertStrategy().initialize();
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().insert(sm, store, rm);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().update(sm, store, rm);
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().delete(sm, store, rm);
    }

    @Override
    public Boolean isCustomInsert(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomInsert(sm, store);
    }

    @Override
    public Boolean isCustomUpdate(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomUpdate(sm, store);
    }

    @Override
    public Boolean isCustomDelete(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomDelete(sm, store);
    }

    @Override
    public void customInsert(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customInsert(sm, store);
    }

    @Override
    public void customUpdate(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customUpdate(sm, store);
    }

    @Override
    public void customDelete(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customDelete(sm, store);
    }

    @Override
    public void setClassMapping(ClassMapping owner) {
        this.assertStrategy().setClassMapping(owner);
    }

    @Override
    public boolean isPrimaryKeyObjectId(boolean hasAll) {
        return this.assertStrategy().isPrimaryKeyObjectId(hasAll);
    }

    @Override
    public Joins joinSuperclass(Joins joins, boolean toThis) {
        return this.assertStrategy().joinSuperclass(joins, toThis);
    }

    @Override
    public boolean supportsEagerSelect(Select sel, OpenJPAStateManager sm, JDBCStore store, ClassMapping base, JDBCFetchConfiguration fetch) {
        return this.assertStrategy().supportsEagerSelect(sel, sm, store, base, fetch);
    }

    @Override
    public ResultObjectProvider customLoad(JDBCStore store, boolean subclasses, JDBCFetchConfiguration fetch, long startIdx, long endIdx) throws SQLException {
        return this.assertStrategy().customLoad(store, subclasses, fetch, startIdx, endIdx);
    }

    @Override
    public boolean customLoad(OpenJPAStateManager sm, JDBCStore store, PCState state, JDBCFetchConfiguration fetch) throws SQLException, ClassNotFoundException {
        return this.assertStrategy().customLoad(sm, store, state, fetch);
    }

    @Override
    public boolean customLoad(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result result) throws SQLException {
        return this.assertStrategy().customLoad(sm, store, fetch, result);
    }

    private ClassStrategy assertStrategy() {
        if (this._strategy == null) {
            throw new InternalException();
        }
        return this._strategy;
    }

    private List<FieldMapping> getFieldMappings(Column[] cols, boolean prime) {
        if (cols == null || cols.length == 0) {
            return null;
        }
        ArrayList<FieldMapping> result = null;
        for (Column c : cols) {
            List<FieldMapping> fms = this.hasColumn(c, prime);
            if (fms == null) continue;
            if (result == null) {
                result = new ArrayList<FieldMapping>();
            }
            for (FieldMapping fm : fms) {
                if (result.contains(fm)) continue;
                result.add(fm);
            }
        }
        return result;
    }

    private List<FieldMapping> hasColumn(Column c, boolean prime) {
        FieldMapping[] fms;
        ArrayList<FieldMapping> result = null;
        for (FieldMapping fm : fms = prime ? this.getPrimaryKeyFieldMappings() : this.getFieldMappings()) {
            Column[] cols = fm.getColumns();
            if (!this.contains(cols, c)) continue;
            if (result == null) {
                result = new ArrayList<FieldMapping>();
            }
            result.add(fm);
        }
        return result;
    }

    boolean contains(Column[] cols, Column c) {
        for (Column col : cols) {
            if (col != c) continue;
            return true;
        }
        return false;
    }

    private Object getValueFromUnmanagedInstance(Object obj, Column[] cols, boolean prime) {
        List<FieldMapping> fms = this.getFieldMappings(cols, prime);
        if (fms == null) {
            return null;
        }
        if (fms.size() == 1) {
            return Reflection.getValue(obj, fms.get(0).getName(), true);
        }
        Object[] result = new Object[fms.size()];
        int i = 0;
        for (FieldMapping fm : fms) {
            result[i++] = Reflection.getValue(obj, fm.getName(), true);
        }
        return result;
    }

    public boolean isVerticalStrategy() {
        String strat = this.getMappingInfo().getHierarchyStrategy();
        return strat != null && strat.equals("vertical");
    }
}

