/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.IntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public final class TextFormattedIntermediateResponseAccessLogMessage
extends TextFormattedRequestAccessLogMessage
implements IntermediateResponseAccessLogMessage {
    private static final long serialVersionUID = -8154114903633681042L;
    @NotNull
    private final AccessLogOperationType operationType;
    @NotNull
    private final Set<String> responseControlOIDs;
    @Nullable
    private final String intermediateResponseName;
    @Nullable
    private final String oid;
    @Nullable
    private final String valueString;

    TextFormattedIntermediateResponseAccessLogMessage(@NotNull TextFormattedLogMessage logMessage, @NotNull AccessLogOperationType operationType) {
        super(logMessage);
        this.operationType = operationType;
        this.oid = this.getString(TextFormattedAccessLogFields.INTERMEDIATE_RESPONSE_OID);
        this.intermediateResponseName = this.getString(TextFormattedAccessLogFields.INTERMEDIATE_RESPONSE_NAME);
        this.valueString = this.getString(TextFormattedAccessLogFields.INTERMEDIATE_RESPONSE_VALUE);
        this.responseControlOIDs = this.getCommaDelimitedStringSet(TextFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.INTERMEDIATE_RESPONSE;
    }

    @Override
    @NotNull
    public AccessLogOperationType getOperationType() {
        return this.operationType;
    }

    @Override
    @Nullable
    public String getOID() {
        return this.oid;
    }

    @Override
    @Nullable
    public String getResponseName() {
        return this.intermediateResponseName;
    }

    @Override
    @Nullable
    public String getValueString() {
        return this.valueString;
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }
}

