/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.setup;

import org.apache.jena.tdb1.base.block.FileMode;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.setup.StoreParamsConst;
import org.apache.jena.tdb1.setup.StoreParamsDynamic;

public class StoreParamsBuilder {
    private Item<FileMode> fileMode = new Item<FileMode>(StoreParamsConst.fileMode, false);
    private Item<Integer> blockReadCacheSize = new Item<Integer>(StoreParamsConst.blockReadCacheSize, false);
    private Item<Integer> blockWriteCacheSize = new Item<Integer>(StoreParamsConst.blockWriteCacheSize, false);
    private Item<Integer> Node2NodeIdCacheSize = new Item<Integer>(StoreParamsConst.Node2NodeIdCacheSize, false);
    private Item<Integer> NodeId2NodeCacheSize = new Item<Integer>(StoreParamsConst.NodeId2NodeCacheSize, false);
    private Item<Integer> NodeMissCacheSize = new Item<Integer>(100, false);
    private Item<Double> NodeCacheInitialCapacityFactor = new Item<Double>(StoreParamsConst.NodeCacheInitialCapacityFactor, false);
    private Item<Integer> blockSize = new Item<Integer>(8192, false);
    private Item<String> indexNode2Id = new Item<String>("node2id", false);
    private Item<String> indexId2Node = new Item<String>("nodes", false);
    private Item<String> primaryIndexTriples = new Item<String>("SPO", false);
    private Item<String[]> tripleIndexes = new Item<String[]>(StoreParamsConst.tripleIndexes, false);
    private Item<String> primaryIndexQuads = new Item<String>("GSPO", false);
    private Item<String[]> quadIndexes = new Item<String[]>(StoreParamsConst.quadIndexes, false);
    private Item<String> primaryIndexPrefix = new Item<String>("GPU", false);
    private Item<String[]> prefixIndexes = new Item<String[]>(StoreParamsConst.prefixIndexes, false);
    private Item<String> indexPrefix = new Item<String>("prefixIdx", false);
    private Item<String> prefixNode2Id = new Item<String>("prefix2id", false);
    private Item<String> prefixId2Node = new Item<String>("prefixes", false);

    public static StoreParamsBuilder create() {
        return new StoreParamsBuilder();
    }

    public static StoreParamsBuilder create(StoreParams params) {
        return new StoreParamsBuilder(params);
    }

    public static StoreParams modify(StoreParams baseParams, StoreParamsDynamic additionalParams) {
        StoreParamsBuilder b = new StoreParamsBuilder(baseParams);
        if (additionalParams.isSetFileMode()) {
            b.fileMode(additionalParams.getFileMode());
        }
        if (additionalParams.isSetBlockReadCacheSize()) {
            b.blockReadCacheSize(additionalParams.getBlockReadCacheSize());
        }
        if (additionalParams.isSetBlockWriteCacheSize()) {
            b.blockWriteCacheSize(additionalParams.getBlockWriteCacheSize());
        }
        if (additionalParams.isSetNode2NodeIdCacheSize()) {
            b.node2NodeIdCacheSize(additionalParams.getNode2NodeIdCacheSize());
        }
        if (additionalParams.isSetNodeId2NodeCacheSize()) {
            b.nodeId2NodeCacheSize(additionalParams.getNodeId2NodeCacheSize());
        }
        if (additionalParams.isSetNodeMissCacheSize()) {
            b.nodeMissCacheSize(additionalParams.getNodeMissCacheSize());
        }
        if (additionalParams.isSetNodeCacheInitialCapacityFactor()) {
            b.nodeCacheInitialCapacityFactor(additionalParams.getNodeCacheInitialCapacityFactor());
        }
        return b.build();
    }

    private StoreParamsBuilder() {
    }

    private StoreParamsBuilder(StoreParams other) {
        this.fileMode = other.fileMode;
        this.blockSize = other.blockSize;
        this.blockReadCacheSize = other.blockReadCacheSize;
        this.blockWriteCacheSize = other.blockWriteCacheSize;
        this.Node2NodeIdCacheSize = other.Node2NodeIdCacheSize;
        this.NodeId2NodeCacheSize = other.NodeId2NodeCacheSize;
        this.NodeMissCacheSize = other.NodeMissCacheSize;
        this.NodeCacheInitialCapacityFactor = other.NodeCacheInitialCapacityFactor;
        this.indexNode2Id = other.indexNode2Id;
        this.indexId2Node = other.indexId2Node;
        this.primaryIndexTriples = other.primaryIndexTriples;
        this.tripleIndexes = other.tripleIndexes;
        this.primaryIndexQuads = other.primaryIndexQuads;
        this.quadIndexes = other.quadIndexes;
        this.primaryIndexPrefix = other.primaryIndexPrefix;
        this.prefixIndexes = other.prefixIndexes;
        this.indexPrefix = other.indexPrefix;
        this.prefixNode2Id = other.prefixNode2Id;
        this.prefixId2Node = other.prefixId2Node;
    }

    public StoreParams build() {
        return new StoreParams(this.fileMode, this.blockSize, this.blockReadCacheSize, this.blockWriteCacheSize, this.Node2NodeIdCacheSize, this.NodeId2NodeCacheSize, this.NodeMissCacheSize, this.NodeCacheInitialCapacityFactor, this.indexNode2Id, this.indexId2Node, this.primaryIndexTriples, this.tripleIndexes, this.primaryIndexQuads, this.quadIndexes, this.primaryIndexPrefix, this.prefixIndexes, this.indexPrefix, this.prefixNode2Id, this.prefixId2Node);
    }

    public FileMode getFileMode() {
        return (FileMode)((Object)this.fileMode.value);
    }

    public StoreParamsBuilder fileMode(FileMode fileMode) {
        this.fileMode = new Item<FileMode>(fileMode, true);
        return this;
    }

    public int getBlockSize() {
        return (Integer)this.blockSize.value;
    }

    public StoreParamsBuilder blockSize(int blockSize) {
        this.blockSize = new Item<Integer>(blockSize, true);
        return this;
    }

    public int getBlockReadCacheSize() {
        return (Integer)this.blockReadCacheSize.value;
    }

    public StoreParamsBuilder blockReadCacheSize(int blockReadCacheSize) {
        this.blockReadCacheSize = new Item<Integer>(blockReadCacheSize, true);
        return this;
    }

    public int getBlockWriteCacheSize() {
        return (Integer)this.blockWriteCacheSize.value;
    }

    public StoreParamsBuilder blockWriteCacheSize(int blockWriteCacheSize) {
        this.blockWriteCacheSize = new Item<Integer>(blockWriteCacheSize, true);
        return this;
    }

    public int getNode2NodeIdCacheSize() {
        return (Integer)this.Node2NodeIdCacheSize.value;
    }

    public StoreParamsBuilder node2NodeIdCacheSize(int node2NodeIdCacheSize) {
        this.Node2NodeIdCacheSize = new Item<Integer>(node2NodeIdCacheSize, true);
        return this;
    }

    public int getNodeId2NodeCacheSize() {
        return (Integer)this.NodeId2NodeCacheSize.value;
    }

    public StoreParamsBuilder nodeId2NodeCacheSize(int nodeId2NodeCacheSize) {
        this.NodeId2NodeCacheSize = new Item<Integer>(nodeId2NodeCacheSize, true);
        return this;
    }

    public int getNodeMissCacheSize() {
        return (Integer)this.NodeMissCacheSize.value;
    }

    public StoreParamsBuilder nodeMissCacheSize(int nodeMissCacheSize) {
        this.NodeMissCacheSize = new Item<Integer>(nodeMissCacheSize, true);
        return this;
    }

    public double getNodeCacheInitialCapacityFactor() {
        return (Double)this.NodeCacheInitialCapacityFactor.value;
    }

    public StoreParamsBuilder nodeCacheInitialCapacityFactor(double nodeCacheInitialCapacityFactor) {
        this.NodeCacheInitialCapacityFactor = new Item<Double>(nodeCacheInitialCapacityFactor, true);
        return this;
    }

    public String getIndexNode2Id() {
        return (String)this.indexNode2Id.value;
    }

    public StoreParamsBuilder indexNode2Id(String indexNode2Id) {
        this.indexNode2Id = new Item<String>(indexNode2Id, true);
        return this;
    }

    public String getIndexId2Node() {
        return (String)this.indexId2Node.value;
    }

    public StoreParamsBuilder indexId2Node(String indexId2Node) {
        this.indexId2Node = new Item<String>(indexId2Node, true);
        return this;
    }

    public String getPrimaryIndexTriples() {
        return (String)this.primaryIndexTriples.value;
    }

    public StoreParamsBuilder primaryIndexTriples(String primaryIndexTriples) {
        this.primaryIndexTriples = new Item<String>(primaryIndexTriples, true);
        return this;
    }

    public String[] getTripleIndexes() {
        return (String[])this.tripleIndexes.value;
    }

    public StoreParamsBuilder tripleIndexes(String[] tripleIndexes) {
        this.tripleIndexes = new Item<String[]>(tripleIndexes, true);
        return this;
    }

    public String getPrimaryIndexQuads() {
        return (String)this.primaryIndexQuads.value;
    }

    public StoreParamsBuilder primaryIndexQuads(String primaryIndexQuads) {
        this.primaryIndexQuads = new Item<String>(primaryIndexQuads, true);
        return this;
    }

    public String[] getQuadIndexes() {
        return (String[])this.quadIndexes.value;
    }

    public StoreParamsBuilder quadIndexes(String[] quadIndexes) {
        this.quadIndexes = new Item<String[]>(quadIndexes, true);
        return this;
    }

    public String getPrimaryIndexPrefix() {
        return (String)this.primaryIndexPrefix.value;
    }

    public StoreParamsBuilder primaryIndexPrefix(String primaryIndexPrefix) {
        this.primaryIndexPrefix = new Item<String>(primaryIndexPrefix, true);
        return this;
    }

    public String[] getPrefixIndexes() {
        return (String[])this.prefixIndexes.value;
    }

    public StoreParamsBuilder prefixIndexes(String[] prefixIndexes) {
        this.prefixIndexes = new Item<String[]>(prefixIndexes, true);
        return this;
    }

    public String getIndexPrefix() {
        return (String)this.indexPrefix.value;
    }

    public StoreParamsBuilder indexPrefix(String indexPrefix) {
        this.indexPrefix = new Item<String>(indexPrefix, true);
        return this;
    }

    public String getPrefixNode2Id() {
        return (String)this.prefixNode2Id.value;
    }

    public StoreParamsBuilder prefixNode2Id(String prefixNode2Id) {
        this.prefixNode2Id = new Item<String>(prefixNode2Id, true);
        return this;
    }

    public String getPrefixId2Node() {
        return (String)this.prefixId2Node.value;
    }

    public StoreParamsBuilder prefixId2Node(String prefixId2Node) {
        this.prefixId2Node = new Item<String>(prefixId2Node, true);
        return this;
    }

    static class Item<X> {
        final X value;
        final boolean isSet;

        Item(X value, boolean isSet) {
            this.value = value;
            this.isSet = isSet;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isSet ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.isSet != other.isSet) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

