/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.apache.jena.vocabulary.SWRL;
import org.apache.jena.vocabulary.SWRLB;
import org.apache.jena.vocabulary.XSD;

public interface OntVocabulary {
    public static final OntVocabulary EMPTY = new Impls.BaseImpl(Map.of());
    public static final OntVocabulary RDFS = new Impls.RDFSImpl();
    public static final OntVocabulary OWL2_FULL = new Impls.OWL2Impl(Impls.OWL2Impl.Type.FULL);
    public static final OntVocabulary OWL2_EL = new Impls.OWL2Impl(Impls.OWL2Impl.Type.EL);
    public static final OntVocabulary OWL2_QL = new Impls.OWL2Impl(Impls.OWL2Impl.Type.QL);
    public static final OntVocabulary OWL2_RL = new Impls.OWL2Impl(Impls.OWL2Impl.Type.RL);
    public static final OntVocabulary OWL1_FULL = new Impls.OWL1Impl(Impls.OWL1Impl.Type.FULL);
    public static final OntVocabulary OWL1_LITE = new Impls.OWL1Impl(Impls.OWL1Impl.Type.LITE);
    public static final OntVocabulary DC = new Impls.DCImpl();
    public static final OntVocabulary SKOS = new Impls.SKOSImpl();
    public static final OntVocabulary SWRL = new Impls.SWRLImpl();

    public Set<? extends Resource> get(String var1);

    default public <X extends Resource> Set<X> get(Resource uri) {
        return this.get(Objects.requireNonNull(uri.getURI()));
    }

    default public Set<Property> getBuiltinAnnotationProperties() {
        return this.get(OWL2.AnnotationProperty);
    }

    default public Set<Property> getBuiltinDatatypeProperties() {
        return this.get(OWL2.DatatypeProperty);
    }

    default public Set<Property> getBuiltinObjectProperties() {
        return this.get(OWL2.ObjectProperty);
    }

    default public Set<Resource> getBuiltinDatatypes() {
        return this.get(org.apache.jena.vocabulary.RDFS.Datatype);
    }

    default public Set<Resource> getBuiltinClasses() {
        return this.get(OWL2.Class);
    }

    default public Set<Resource> getBuiltinSWRLs() {
        return this.get(org.apache.jena.vocabulary.SWRL.Builtin);
    }

    default public Set<Resource> getSystemResources() {
        return this.get(org.apache.jena.vocabulary.RDFS.Resource);
    }

    default public Set<Property> getSystemProperties() {
        return this.get(RDF.Property);
    }

    default public OntVocabulary and(OntVocabulary other) {
        return Impls.create(this, Objects.requireNonNull(other));
    }

    public static final class Impls {
        public static OntVocabulary create(OntVocabulary ... vocabularies) {
            return new BaseImpl(Arrays.stream(vocabularies).map(Impls::asMap).flatMap(x -> x.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
                HashSet res = new HashSet(a);
                res.addAll(b);
                return res;
            })));
        }

        public static OntVocabulary create(Resource key, Resource ... values) {
            return Impls.create(key, (Collection<? extends Resource>)Arrays.stream(values).collect(Collectors.toUnmodifiableSet()));
        }

        public static OntVocabulary create(Resource key, Collection<? extends Resource> values) {
            return Impls.create(Objects.requireNonNull(key).getURI(), values);
        }

        public static OntVocabulary create(String key, Collection<? extends Resource> values) {
            HashMap<String, Set<? extends Resource>> map = new HashMap<String, Set<? extends Resource>>();
            map.put(Objects.requireNonNull(key), Impls.toUnmodifiableSet(Objects.requireNonNull(values)));
            return new BaseImpl(map);
        }

        public static OntVocabulary create(Class<?> ... schemas) {
            return new BaseImpl(Impls.getConstants(Property.class, schemas), Impls.getConstants(Resource.class, schemas));
        }

        private static Stream<Field> directFields(Class<?> vocabulary, Class<?> type) {
            return Arrays.stream(vocabulary.getDeclaredFields()).filter(x -> Modifier.isPublic(x.getModifiers())).filter(x -> Modifier.isStatic(x.getModifiers())).filter(x -> type.equals(x.getType()));
        }

        private static Stream<Field> fields(Class<?> vocabulary, Class<?> type) {
            Stream<Field> res = Impls.directFields(vocabulary, type);
            return vocabulary.getSuperclass() != null ? Stream.concat(res, Impls.fields(vocabulary.getSuperclass(), type)) : res;
        }

        private static <T> Stream<T> constants(Class<?> vocabulary, Class<T> type) {
            return Impls.fields(vocabulary, type).map(x -> Impls.getValue(x, type)).filter(Objects::nonNull);
        }

        private static <T> T getValue(Field field, Class<T> type) {
            try {
                return type.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new OntJenaException.IllegalState("Unable to get an object of the type " + type.getSimpleName() + " from the field " + field.getName(), e);
            }
        }

        private static <T> Set<T> getConstants(Class<? extends T> type, Class<?> ... vocabularies) {
            return Arrays.stream(vocabularies).flatMap(x -> Impls.constants(x, type)).collect(Collectors.toUnmodifiableSet());
        }

        private static Map<String, Set<? extends Resource>> asMap(OntVocabulary voc) {
            if (voc instanceof BaseImpl) {
                return ((BaseImpl)voc).map;
            }
            HashMap<String, Set<? extends Resource>> res = new HashMap<String, Set<? extends Resource>>();
            Stream.of(OWL2.AnnotationProperty, OWL2.DatatypeProperty, OWL2.ObjectProperty, org.apache.jena.vocabulary.RDFS.Datatype, OWL2.Class, org.apache.jena.vocabulary.SWRL.Builtin, RDF.Property, org.apache.jena.vocabulary.RDFS.Resource).forEach(x -> res.put(x.getURI(), voc.get((Resource)x)));
            return res;
        }

        private static <X> Set<X> toUnmodifiableSet(Collection<X> input) {
            if (input instanceof Set && input.getClass().getName().equals("java.util.Collections$UnmodifiableSet")) {
                return (Set)input;
            }
            return input.stream().peek(Objects::requireNonNull).collect(Collectors.toUnmodifiableSet());
        }

        public static class BaseImpl
        implements OntVocabulary {
            private final Map<String, Set<? extends Resource>> map;

            private BaseImpl(Set<Property> properties, Set<Resource> resources) {
                this(null, null, null, null, null, null, properties, resources);
            }

            protected BaseImpl(Set<Property> annotationProperties, Set<Property> dataProperties, Set<Property> objectProperties, Set<Resource> classes, Set<Resource> datatypes, Set<Resource> swrlBuiltins, Set<Property> allProperties, Set<Resource> allResources) {
                this.map = BaseImpl.collectBuiltIns(annotationProperties, dataProperties, objectProperties, classes, datatypes, swrlBuiltins, allProperties, allResources);
            }

            private static Map<String, Set<? extends Resource>> collectBuiltIns(Set<Property> annotationProperties, Set<Property> dataProperties, Set<Property> objectProperties, Set<Resource> classes, Set<Resource> datatypes, Set<Resource> swrlBuiltins, Set<Property> allProperties, Set<Resource> allResources) {
                return Stream.of(BaseImpl.pair(OWL2.AnnotationProperty, annotationProperties), BaseImpl.pair(OWL2.DatatypeProperty, dataProperties), BaseImpl.pair(OWL2.ObjectProperty, objectProperties), BaseImpl.pair(OWL2.Class, classes), BaseImpl.pair(org.apache.jena.vocabulary.RDFS.Datatype, datatypes), BaseImpl.pair(org.apache.jena.vocabulary.SWRL.Builtin, swrlBuiltins), BaseImpl.pair(RDF.Property, allProperties), BaseImpl.pair(org.apache.jena.vocabulary.RDFS.Resource, allResources)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(it -> ((Resource)it.getKey()).getURI(), it -> Set.copyOf((Collection)it.getValue())));
            }

            private static Map.Entry<Resource, Set<? extends Resource>> pair(Resource key, Set<? extends Resource> value) {
                return value == null ? null : Map.entry(key, value);
            }

            protected BaseImpl(Map<String, Set<? extends Resource>> map) {
                this.map = Map.copyOf(Objects.requireNonNull(map));
            }

            @Override
            public Set<? extends Resource> get(String key) {
                return this.map.getOrDefault(key, Collections.emptySet());
            }
        }

        protected static class SWRLImpl
        extends BaseImpl {
            public static final Set<Resource> BUILTINS = Impls.getConstants(Property.class, SWRLB.class);
            private static final Class<?>[] VOCABULARIES = new Class[]{SWRL.class, SWRLB.class};
            public static final Set<Property> PROPERTIES = Impls.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Impls.getConstants(Resource.class, VOCABULARIES);

            protected SWRLImpl() {
                super(null, null, null, null, null, BUILTINS, PROPERTIES, RESOURCES);
            }
        }

        protected static class SKOSImpl
        extends BaseImpl {
            public static final Set<Property> ANNOTATION_PROPERTIES = Set.of(org.apache.jena.vocabulary.SKOS.altLabel, org.apache.jena.vocabulary.SKOS.changeNote, org.apache.jena.vocabulary.SKOS.definition, org.apache.jena.vocabulary.SKOS.editorialNote, org.apache.jena.vocabulary.SKOS.example, org.apache.jena.vocabulary.SKOS.hiddenLabel, org.apache.jena.vocabulary.SKOS.historyNote, org.apache.jena.vocabulary.SKOS.note, org.apache.jena.vocabulary.SKOS.prefLabel, org.apache.jena.vocabulary.SKOS.scopeNote);
            public static final Set<Property> OBJECT_PROPERTIES = Set.of(org.apache.jena.vocabulary.SKOS.broadMatch, org.apache.jena.vocabulary.SKOS.broader, org.apache.jena.vocabulary.SKOS.broaderTransitive, org.apache.jena.vocabulary.SKOS.closeMatch, org.apache.jena.vocabulary.SKOS.exactMatch, org.apache.jena.vocabulary.SKOS.hasTopConcept, org.apache.jena.vocabulary.SKOS.inScheme, org.apache.jena.vocabulary.SKOS.mappingRelation, org.apache.jena.vocabulary.SKOS.member, org.apache.jena.vocabulary.SKOS.memberList, org.apache.jena.vocabulary.SKOS.narrowMatch, org.apache.jena.vocabulary.SKOS.narrower, org.apache.jena.vocabulary.SKOS.narrowerTransitive, org.apache.jena.vocabulary.SKOS.related, org.apache.jena.vocabulary.SKOS.relatedMatch, org.apache.jena.vocabulary.SKOS.semanticRelation, org.apache.jena.vocabulary.SKOS.topConceptOf);
            public static final Set<Resource> CLASSES = Set.of(org.apache.jena.vocabulary.SKOS.Collection, org.apache.jena.vocabulary.SKOS.Concept, org.apache.jena.vocabulary.SKOS.ConceptScheme, org.apache.jena.vocabulary.SKOS.OrderedCollection);
            public static final Set<Property> PROPERTIES = Impls.getConstants(Property.class, SKOS.class);
            public static final Set<Resource> RESOURCES = Impls.getConstants(Resource.class, SKOS.class);

            protected SKOSImpl() {
                super(ANNOTATION_PROPERTIES, null, OBJECT_PROPERTIES, CLASSES, null, null, PROPERTIES, RESOURCES);
            }
        }

        protected static class DCImpl
        extends BaseImpl {
            public static final Set<Property> ALL_PROPERTIES = Impls.getConstants(Property.class, DC.class);

            protected DCImpl() {
                super(ALL_PROPERTIES, null, null, null, null, null, ALL_PROPERTIES, null);
            }
        }

        protected static class OWL1Impl
        extends BaseImpl {
            private static final Set<Resource> OWL1_DATATYPES = Set.of(RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, org.apache.jena.vocabulary.RDFS.Literal, XSD.xstring, XSD.normalizedString, XSD.token, XSD.language, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.xdouble, XSD.xfloat, XSD.xboolean, XSD.nonNegativeInteger, XSD.nonPositiveInteger, XSD.positiveInteger, XSD.negativeInteger, XSD.xlong, XSD.xint, XSD.xshort, XSD.xbyte, XSD.unsignedLong, XSD.unsignedInt, XSD.unsignedShort, XSD.unsignedByte, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp);
            public static final Set<Resource> ALL_KNOWN_DATATYPES = OWL1Impl.initOWL1BuiltInRDFDatatypes(TypeMapper.getInstance()).stream().map(RDFDatatype::getURI).map(ResourceFactory::createResource).collect(Collectors.toUnmodifiableSet());
            public static final Set<Resource> OWL1_FULL_CLASSES = Set.of(OWL.Nothing, OWL.Thing);
            public static final Set<Resource> OWL1_LITE_CLASSES = Set.of(OWL.Thing);
            public static final Set<Property> OWL1_ANNOTATION_PROPERTIES = Set.of(org.apache.jena.vocabulary.RDFS.label, org.apache.jena.vocabulary.RDFS.comment, org.apache.jena.vocabulary.RDFS.seeAlso, org.apache.jena.vocabulary.RDFS.isDefinedBy, OWL.versionInfo, OWL.backwardCompatibleWith, OWL.priorVersion, OWL.incompatibleWith);
            public static final Set<Property> OWL1_DATA_PROPERTIES = Set.of();
            public static final Set<Property> OWL1_OBJECT_PROPERTIES = Set.of();
            private static final Class<?>[] VOCABULARIES = new Class[]{XSD.class, RDF.class, RDFS.class, OWL.class};
            public static final Set<Property> PROPERTIES = Impls.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Impls.getConstants(Resource.class, VOCABULARIES);

            protected OWL1Impl(Type type) {
                super(OWL1_ANNOTATION_PROPERTIES, OWL1_DATA_PROPERTIES, OWL1_OBJECT_PROPERTIES, OWL1Impl.classes(type), OWL1Impl.datatypes(type), null, PROPERTIES, RESOURCES);
            }

            private static Set<Resource> classes(Type type) {
                if (type == Type.LITE) {
                    return OWL1_LITE_CLASSES;
                }
                return OWL1_FULL_CLASSES;
            }

            private static Set<Resource> datatypes(Type type) {
                if (type == Type.FULL) {
                    return ALL_KNOWN_DATATYPES;
                }
                return OWL1_DATATYPES;
            }

            private static Set<RDFDatatype> initOWL1BuiltInRDFDatatypes(TypeMapper types) {
                OWL1_DATATYPES.forEach(iri -> types.getSafeTypeByName(iri.getURI()));
                Set exclude = OWL2Impl.OWL2_DATATYPES.stream().filter(it -> !OWL1_DATATYPES.contains(it)).map(Resource::getURI).collect(Collectors.toUnmodifiableSet());
                HashSet res = new HashSet();
                types.listTypes().forEachRemaining(it -> {
                    if (!exclude.contains(it.getURI())) {
                        res.add(it);
                    }
                });
                return Collections.unmodifiableSet(res);
            }

            public static enum Type {
                FULL,
                DL,
                LITE;

            }
        }

        protected static class OWL2Impl
        extends BaseImpl {
            public static final Set<Resource> OWL2_DATATYPES = Set.of(OWL2.real, OWL2.rational, RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, org.apache.jena.vocabulary.RDFS.Literal, XSD.xstring, XSD.normalizedString, XSD.token, XSD.language, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.xdouble, XSD.xfloat, XSD.xboolean, XSD.nonNegativeInteger, XSD.nonPositiveInteger, XSD.positiveInteger, XSD.negativeInteger, XSD.xlong, XSD.xint, XSD.xshort, XSD.xbyte, XSD.unsignedLong, XSD.unsignedInt, XSD.unsignedShort, XSD.unsignedByte, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp);
            public static final Set<Resource> OWL2_EL_QL_DATATYPES = Set.of(OWL2.real, OWL2.rational, RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, org.apache.jena.vocabulary.RDFS.Literal, XSD.xstring, XSD.normalizedString, XSD.token, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.nonNegativeInteger, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp);
            public static final Set<Resource> OWL2_RL_DATATYPES = Set.of(RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, org.apache.jena.vocabulary.RDFS.Literal, XSD.xstring, XSD.normalizedString, XSD.token, XSD.language, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.xdouble, XSD.xfloat, XSD.xboolean, XSD.nonNegativeInteger, XSD.nonPositiveInteger, XSD.positiveInteger, XSD.negativeInteger, XSD.xlong, XSD.xint, XSD.xshort, XSD.xbyte, XSD.unsignedLong, XSD.unsignedInt, XSD.unsignedShort, XSD.unsignedByte, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp);
            public static final Set<Resource> ALL_KNOWN_DATATYPES = OWL2Impl.initOWL2BuiltInRDFDatatypes(TypeMapper.getInstance()).stream().map(RDFDatatype::getURI).map(ResourceFactory::createResource).collect(Collectors.toUnmodifiableSet());
            public static final Set<Resource> OWL2_CLASSES = Set.of(OWL2.Nothing, OWL2.Thing);
            public static final Set<Property> OWL2_ANNOTATION_PROPERTIES = Set.of(org.apache.jena.vocabulary.RDFS.label, org.apache.jena.vocabulary.RDFS.comment, org.apache.jena.vocabulary.RDFS.seeAlso, org.apache.jena.vocabulary.RDFS.isDefinedBy, OWL2.versionInfo, OWL2.backwardCompatibleWith, OWL2.priorVersion, OWL2.incompatibleWith, OWL2.deprecated);
            public static final Set<Property> OWL2_DATA_PROPERTIES = Set.of(OWL2.topDataProperty, OWL2.bottomDataProperty);
            public static final Set<Property> OWL2_OBJECT_PROPERTIES = Set.of(OWL2.topObjectProperty, OWL2.bottomObjectProperty);
            private static final Class<?>[] VOCABULARIES = new Class[]{XSD.class, RDF.class, RDFS.class, OWL2.class};
            public static final Set<Property> PROPERTIES = Impls.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Impls.getConstants(Resource.class, VOCABULARIES);

            protected OWL2Impl(Type type) {
                super(OWL2_ANNOTATION_PROPERTIES, type == Type.RL ? Set.of() : OWL2_DATA_PROPERTIES, type == Type.RL ? Set.of() : OWL2_OBJECT_PROPERTIES, OWL2_CLASSES, OWL2Impl.datatypes(type), null, PROPERTIES, RESOURCES);
            }

            private static Set<Resource> datatypes(Type type) {
                if (type == Type.DL) {
                    return OWL2_DATATYPES;
                }
                if (type == Type.EL || type == Type.QL) {
                    return OWL2_EL_QL_DATATYPES;
                }
                if (type == Type.RL) {
                    return OWL2_RL_DATATYPES;
                }
                return ALL_KNOWN_DATATYPES;
            }

            private static Set<RDFDatatype> initOWL2BuiltInRDFDatatypes(TypeMapper types) {
                Stream.of(OWL2.real, OWL2.rational).forEach(d -> types.registerDatatype((RDFDatatype)new BaseDatatype(d.getURI())));
                OWL2_DATATYPES.forEach(iri -> types.getSafeTypeByName(iri.getURI()));
                HashSet res = new HashSet();
                types.listTypes().forEachRemaining(res::add);
                return Collections.unmodifiableSet(res);
            }

            protected static enum Type {
                FULL,
                DL,
                EL,
                QL,
                RL;

            }
        }

        protected static class RDFSImpl
        extends BaseImpl {
            public static final Set<Property> ANNOTATION_PROPERTIES = Set.of(org.apache.jena.vocabulary.RDFS.label, org.apache.jena.vocabulary.RDFS.comment, org.apache.jena.vocabulary.RDFS.seeAlso, org.apache.jena.vocabulary.RDFS.isDefinedBy);
            private static final Class<?>[] VOCABULARIES = new Class[]{RDF.class, RDFS.class};
            public static final Set<Property> PROPERTIES = Impls.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Impls.getConstants(Resource.class, VOCABULARIES);

            protected RDFSImpl() {
                super(ANNOTATION_PROPERTIES, null, null, null, null, null, PROPERTIES, RESOURCES);
            }
        }
    }
}

