/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.repositories;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.UnionGraph;
import org.apache.jena.ontapi.impl.GraphListenerBase;
import org.apache.jena.ontapi.impl.OntModelEvent;
import org.apache.jena.ontapi.impl.repositories.OntUnionGraphRepository;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public class OntUnionGraphListener
extends GraphListenerBase
implements UnionGraph.EventManager {
    private final List<GraphListener> inactive = new ArrayList<GraphListener>();
    final OntUnionGraphRepository ontGraphRepository;

    protected OntUnionGraphListener(OntUnionGraphRepository ontGraphRepository) {
        this.ontGraphRepository = Objects.requireNonNull(ontGraphRepository);
    }

    @Override
    public void off() {
        this.inactive.addAll(this.listeners);
        this.listeners.clear();
    }

    @Override
    public void on() {
        this.listeners.addAll(this.inactive);
        this.inactive.clear();
    }

    @Override
    public void onAddTriple(UnionGraph graph, Triple triple) {
        if (this.isNameTriple(triple) && !graph.getBaseGraph().contains(triple)) {
            OntUnionGraphRepository.checkIDCanBeChanged(graph);
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.onAddTriple(graph, triple));
    }

    @Override
    public void onDeleteTriple(UnionGraph graph, Triple triple) {
        if (this.isNameTriple(triple) && graph.getBaseGraph().contains(triple)) {
            OntUnionGraphRepository.checkIDCanBeChanged(graph);
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.onDeleteTriple(graph, triple));
    }

    @Override
    public void onAddSubGraph(UnionGraph graph, Graph subGraph) {
        Node ontology;
        if (Graphs.isOntGraph(Graphs.getPrimary(subGraph)) && !(ontology = Graphs.findOntologyNameNode(Graphs.getPrimary(subGraph)).orElseThrow(() -> new OntJenaException.IllegalArgument("Unnamed or misconfigured graph is specified"))).isURI()) {
            throw new OntJenaException.IllegalArgument("Anonymous graph specified");
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.onAddSubGraph(graph, subGraph));
    }

    @Override
    public void onClear(UnionGraph graph) {
        OntUnionGraphRepository.checkIDCanBeChanged(graph);
        Graphs.findOntologyNameNode(graph.getBaseGraph()).ifPresent(this.ontGraphRepository::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubGraphAdded(UnionGraph thisGraph, Graph subGraph) {
        if (Graphs.isOntGraph(Graphs.getPrimary(subGraph))) {
            Graph ontSubGraphBase = OntUnionGraphRepository.getBase(subGraph);
            Node ontSubGraphIri = Graphs.findOntologyNameNode(ontSubGraphBase).filter(Node::isURI).orElseThrow(() -> new IllegalStateException("Expected to be named"));
            Graph thisOntBaseGraph = thisGraph.getBaseGraph();
            Node ontology = Graphs.ontologyNode(thisOntBaseGraph).orElseGet(() -> Graphs.createOntologyHeaderNode(thisOntBaseGraph, null));
            thisOntBaseGraph.add(ontology, OWL2.imports.asNode(), ontSubGraphIri);
            UnionGraph ontSubGraph = this.ontGraphRepository.put(subGraph);
            if (subGraph != ontSubGraph) {
                Graph justAddedGraph = thisGraph.subGraphs().filter(it -> OntUnionGraphRepository.graphEquals(it, subGraph)).findFirst().orElseThrow(() -> new IllegalStateException("Where is just added graph?"));
                try {
                    thisGraph.getEventManager().off();
                    thisGraph.removeSubGraph(justAddedGraph).addSubGraph(ontSubGraph);
                }
                finally {
                    thisGraph.getEventManager().on();
                }
            }
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySubGraphAdded(thisGraph, subGraph));
    }

    @Override
    public void notifySuperGraphAdded(UnionGraph graph, UnionGraph superGraph) {
        Node graphName;
        Node superGraphOntology = Graphs.ontologyNode(superGraph.getBaseGraph()).orElse(null);
        if (superGraphOntology != null && (graphName = (Node)Graphs.findOntologyNameNode(graph.getBaseGraph()).filter(Node::isURI).orElse(null)) != null) {
            superGraph.getBaseGraph().add(superGraphOntology, OWL2.imports.asNode(), graphName);
            this.ontGraphRepository.put(superGraph);
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySuperGraphAdded(graph, superGraph));
    }

    @Override
    public void onRemoveSubGraph(UnionGraph graph, Graph subGraph) {
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.onRemoveSubGraph(graph, graph));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubGraphRemoved(UnionGraph graph, Graph subGraph) {
        Graph ontSubGraphBase;
        Node ontSubGraphIri;
        if (subGraph instanceof UnionGraph && Graphs.isOntGraph(((UnionGraph)subGraph).getBaseGraph()) && (ontSubGraphIri = (Node)Graphs.findOntologyNameNode(ontSubGraphBase = ((UnionGraph)subGraph).getBaseGraph()).filter(Node::isURI).orElse(null)) != null) {
            Graph thisOntBaseGraph = graph.getBaseGraph();
            Node ontology = Graphs.ontologyNode(thisOntBaseGraph).orElseGet(() -> Graphs.createOntologyHeaderNode(thisOntBaseGraph, null));
            thisOntBaseGraph.delete(ontology, OWL2.imports.asNode(), ontSubGraphIri);
            List<Graph> toDetach = graph.subGraphs().filter(it -> it instanceof UnionGraph).filter(it -> Graphs.findOntologyNameNode(((UnionGraph)it).getBaseGraph()).filter(Node::isURI).filter(arg_0 -> ((Node)ontSubGraphIri).equals(arg_0)).isPresent()).toList();
            try {
                graph.getEventManager().off();
                toDetach.forEach(graph::removeSubGraph);
            }
            finally {
                graph.getEventManager().on();
            }
        }
        this.listeners(UnionGraph.Listener.class).forEach(it -> it.notifySubGraphRemoved(graph, graph));
    }

    @Override
    protected void addTripleEvent(Graph g, Triple t) {
        UnionGraph thisGraph = (UnionGraph)g;
        if (this.isNameTriple(t)) {
            this.ontGraphRepository.remap(thisGraph);
        } else if (this.isImportTriple(t, thisGraph.getBaseGraph())) {
            UnionGraph.EventManager manager = thisGraph.getEventManager();
            try {
                manager.off();
                UnionGraph add = this.ontGraphRepository.get(t.getObject());
                thisGraph.addSubGraphIfAbsent(add);
            }
            catch (Exception ex) {
                thisGraph.getBaseGraph().delete(t);
                throw ex;
            }
            finally {
                manager.on();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteTripleEvent(Graph g, Triple t) {
        UnionGraph thisGraph = (UnionGraph)g;
        if (this.isNameTriple(t)) {
            this.ontGraphRepository.remap(thisGraph);
        } else if (this.isImportTriple(t, thisGraph.getBaseGraph())) {
            UnionGraph.EventManager manager = thisGraph.getEventManager();
            try {
                manager.off();
                UnionGraph toRemove = this.ontGraphRepository.get(t.getObject());
                thisGraph.removeSubGraph(toRemove);
            }
            finally {
                manager.on();
            }
        }
    }

    public void notifyEvent(Graph source, Object event) {
        UnionGraph graph = (UnionGraph)source;
        this.handleChangeIDEvents(graph, event);
        this.handleAddDataGraphEvents(graph, event);
        this.handleReadDataGraphEvents(graph, event);
        this.handleDeleteDataGraphEvents(graph, event);
        super.notifyEvent(source, event);
    }

    private void handleReadDataGraphEvents(UnionGraph graph, Object event) {
        if (OntModelEvent.isEventOfType(event, "startReadDataGraph")) {
            OntUnionGraphRepository.checkIDCanBeChanged(graph);
        }
        if (OntModelEvent.isEventOfType(event, "endReadDataGraph")) {
            this.ontGraphRepository.remap(graph);
            this.ontGraphRepository.put(graph);
        }
    }

    private void handleChangeIDEvents(UnionGraph graph, Object event) {
        if (OntModelEvent.isEventOfType(event, "startChangeID")) {
            OntUnionGraphRepository.checkIDCanBeChanged(graph);
        }
        if (OntModelEvent.isEventOfType(event, "endChangeID")) {
            this.ontGraphRepository.remap(graph);
        }
    }

    private void handleAddDataGraphEvents(UnionGraph graph, Object event) {
        if (OntModelEvent.isEventOfType(event, "startAddDataGraph")) {
            Graph data = (Graph)((OntModelEvent)((Object)event)).getContent();
            Node prevName = Graphs.findOntologyNameNode(graph.getBaseGraph()).orElse(null);
            Graph header = GraphMemFactory.createDefaultGraph();
            Iterators.forEach(Graphs.listOntHeaderTriples(graph.getBaseGraph()), arg_0 -> ((Graph)header).add(arg_0));
            Iterators.forEach(Graphs.listOntHeaderTriples(data), arg_0 -> ((Graph)header).add(arg_0));
            Node newName = Graphs.findOntologyNameNode(header).orElse(null);
            if (newName == null) {
                throw new OntJenaException.IllegalArgument("Cancel. Adding data will result in invalid ontology ID");
            }
            if (!Objects.equals(newName, prevName)) {
                OntUnionGraphRepository.checkIDCanBeChanged(graph);
            }
        }
        if (OntModelEvent.isEventOfType(event, "finishAddDataGraph")) {
            this.ontGraphRepository.remap(graph);
            this.ontGraphRepository.put(graph);
        }
    }

    private void handleDeleteDataGraphEvents(UnionGraph graph, Object event) {
        if (OntModelEvent.isEventOfType(event, "startDeleteDataGraph")) {
            Graph data = (Graph)((OntModelEvent)((Object)event)).getContent();
            Graph header = GraphMemFactory.createDefaultGraph();
            Iterators.forEach(Graphs.listOntHeaderTriples(graph.getBaseGraph()), arg_0 -> ((Graph)header).add(arg_0));
            Iterators.forEach(Graphs.listOntHeaderTriples(data), arg_0 -> ((Graph)header).delete(arg_0));
            Node newName = Graphs.findOntologyNameNode(header).orElse(null);
            if (newName == null) {
                throw new OntJenaException.IllegalArgument("Cancel. Deleting data will result in invalid ontology ID");
            }
            Node prevName = Graphs.findOntologyNameNode(graph.getBaseGraph()).orElse(null);
            if (!Objects.equals(newName, prevName)) {
                OntUnionGraphRepository.checkIDCanBeChanged(graph);
            }
        }
        if (OntModelEvent.isEventOfType(event, "finishDeleteDataGraph")) {
            OntUnionGraphRepository.removeUnusedImportSubGraphs(graph);
            this.ontGraphRepository.remap(graph);
        }
    }

    private boolean isNameTriple(Triple t) {
        return t.getPredicate().equals((Object)RDF.type.asNode()) && t.getObject().equals((Object)OWL2.Ontology.asNode()) || t.getPredicate().equals((Object)OWL2.versionIRI.asNode()) && t.getObject().isURI();
    }

    private boolean isImportTriple(Triple t, Graph g) {
        if (!t.getObject().isURI() || !OWL2.imports.asNode().equals((Object)t.getPredicate())) {
            return false;
        }
        Node subject = Graphs.ontologyNode(g).orElse(null);
        return t.getSubject().equals((Object)subject);
    }
}

