/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.AllDifferent;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.OntResourceImpl;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class AllDifferentImpl
extends OntResourceImpl
implements AllDifferent {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new AllDifferentImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + String.valueOf(n) + " to AllDifferent");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, AllDifferent.class);
        }
    };

    public AllDifferentImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setDistinctMembers(RDFList members) {
        this.setPropertyValue(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", members);
    }

    @Override
    public void addDistinctMember(Resource res) {
        this.addListPropertyValue(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", res);
    }

    @Override
    public void addDistinctMembers(Iterator<? extends Resource> individuals) {
        while (individuals.hasNext()) {
            this.addDistinctMember(individuals.next());
        }
    }

    @Override
    public RDFList getDistinctMembers() {
        return this.objectAs(this.getProfile().DISTINCT_MEMBERS(), "DISTINCT_MEMBERS", RDFList.class);
    }

    @Override
    public ExtendedIterator<? extends OntResource> listDistinctMembers() {
        return this.getDistinctMembers().mapWith(o -> o.as(OntResource.class));
    }

    @Override
    public boolean hasDistinctMember(Resource res) {
        return this.getDistinctMembers().contains(res);
    }

    @Override
    public void removeDistinctMember(Resource res) {
        this.setDistinctMembers(this.getDistinctMembers().remove(res));
    }
}

