/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog.rotate;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.jena.rdfpatch.filelog.rotate.Filename;
import org.apache.jena.rdfpatch.filelog.rotate.Roller;

class RollerFixed
implements Roller {
    private final Path directory;
    private final String baseFilename;
    private Path filename = null;

    RollerFixed(Path directory, String baseFilename) {
        this.directory = directory;
        this.baseFilename = baseFilename;
        this.filename = directory.resolve(baseFilename);
    }

    @Override
    public Stream<Filename> files() {
        return Stream.of(new Filename(this.directory, this.baseFilename, null, null, null));
    }

    @Override
    public Path directory() {
        return this.directory;
    }

    @Override
    public void startSection() {
    }

    @Override
    public void finishSection() {
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void rotate() {
    }

    @Override
    public Path latestFilename() {
        return Files.exists(this.filename, new LinkOption[0]) ? this.filename : null;
    }

    @Override
    public Path nextFilename() {
        return this.filename;
    }
}

