/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.util.List;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.engine.main.QueryEngineMainQuad;
import org.apache.jena.sparql.engine.ref.QueryEngineRef;
import org.apache.jena.sparql.engine.ref.QueryEngineRefQuad;

public class ModEngine
extends ModBase {
    protected final ArgDecl engineDecl = new ArgDecl(true, "engine");
    protected final ArgDecl unEngineDecl = new ArgDecl(true, "unengine", "unEngine", "removeEngine", "removeengine");
    private boolean timing = false;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query Engine");
        cmdLine.add(this.engineDecl, "--engine=EngineName", "Register another engine factory[ref]");
        cmdLine.add(this.unEngineDecl, "--unengine=EngineName", "Unregister an engine factory");
    }

    public void resetRegistrations() {
        QueryEngineRef.unregister();
        QueryEngineRefQuad.unregister();
        QueryEngineMainQuad.unregister();
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        List<String> engineDecls = cmdLine.getValues(this.engineDecl);
        block26: for (String engineName : engineDecls) {
            switch (engineName.toLowerCase()) {
                case "reference": 
                case "ref": {
                    QueryEngineRef.register();
                    continue block26;
                }
                case "refquad": {
                    QueryEngineRefQuad.register();
                    continue block26;
                }
                case "main": {
                    QueryEngineMain.register();
                    continue block26;
                }
                case "quad": {
                    QueryEngineMainQuad.register();
                    continue block26;
                }
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
        List<String> unEngineDecls = cmdLine.getValues(this.unEngineDecl);
        block27: for (String engineName : unEngineDecls) {
            switch (engineName.toLowerCase()) {
                case "reference": 
                case "ref": {
                    QueryEngineRef.unregister();
                    continue block27;
                }
                case "refquad": {
                    QueryEngineRefQuad.unregister();
                    continue block27;
                }
                case "main": {
                    QueryEngineMain.unregister();
                    continue block27;
                }
                case "quad": {
                    QueryEngineMainQuad.unregister();
                    continue block27;
                }
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
    }
}

