/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.SegmentCacheable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;

public abstract class Weight
implements SegmentCacheable {
    protected final Query parentQuery;

    protected Weight(Query query2) {
        this.parentQuery = query2;
    }

    public Matches matches(LeafReaderContext context2, int doc) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        Scorer scorer = scorerSupplier.get(1L);
        TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        if (twoPhase == null ? scorer.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
            return null;
        }
        return MatchesUtils.MATCH_WITH_NO_TERMS;
    }

    public abstract Explanation explain(LeafReaderContext var1, int var2) throws IOException;

    public final Query getQuery() {
        return this.parentQuery;
    }

    public abstract Scorer scorer(LeafReaderContext var1) throws IOException;

    public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
        final Scorer scorer = this.scorer(context2);
        if (scorer == null) {
            return null;
        }
        return new ScorerSupplier(){

            @Override
            public Scorer get(long leadCost) {
                return scorer;
            }

            @Override
            public long cost() {
                return scorer.iterator().cost();
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context2) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
        if (scorerSupplier == null) {
            return null;
        }
        scorerSupplier.setTopLevelScoringClause();
        return new DefaultBulkScorer(scorerSupplier.get(Long.MAX_VALUE));
    }

    public int count(LeafReaderContext context2) throws IOException {
        return -1;
    }

    protected static class DefaultBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final DocIdSetIterator iterator;
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(Scorer scorer) {
            if (scorer == null) {
                throw new NullPointerException();
            }
            this.scorer = scorer;
            this.iterator = scorer.iterator();
            this.twoPhase = scorer.twoPhaseIterator();
        }

        @Override
        public long cost() {
            return this.iterator.cost();
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
            collector.setScorer(this.scorer);
            DocIdSetIterator scorerIterator = this.twoPhase == null ? this.iterator : this.twoPhase.approximation();
            DocIdSetIterator competitiveIterator = collector.competitiveIterator();
            if (competitiveIterator == null && scorerIterator.docID() == -1 && min2 == 0 && max2 == Integer.MAX_VALUE) {
                DefaultBulkScorer.scoreAll(collector, scorerIterator, this.twoPhase, acceptDocs);
                return Integer.MAX_VALUE;
            }
            return DefaultBulkScorer.scoreRange(collector, scorerIterator, this.twoPhase, competitiveIterator, acceptDocs, min2, max2);
        }

        static int scoreRange(LeafCollector collector, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, DocIdSetIterator competitiveIterator, Bits acceptDocs, int min2, int max2) throws IOException {
            int doc;
            if (competitiveIterator != null && competitiveIterator.docID() > min2) {
                min2 = competitiveIterator.docID();
                min2 = Math.min(min2, max2);
            }
            if ((doc = iterator.docID()) < min2) {
                doc = doc == min2 - 1 ? iterator.nextDoc() : iterator.advance(min2);
            }
            if (twoPhase == null && competitiveIterator == null) {
                while (doc < max2) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = iterator.nextDoc();
                }
            } else {
                while (doc < max2) {
                    if (competitiveIterator != null) {
                        assert (competitiveIterator.docID() <= doc);
                        if (competitiveIterator.docID() < doc) {
                            competitiveIterator.advance(doc);
                        }
                        if (competitiveIterator.docID() != doc) {
                            doc = iterator.advance(competitiveIterator.docID());
                            continue;
                        }
                    }
                    if ((acceptDocs == null || acceptDocs.get(doc)) && (twoPhase == null || twoPhase.matches())) {
                        collector.collect(doc);
                    }
                    doc = iterator.nextDoc();
                }
            }
            return doc;
        }

        static void scoreAll(LeafCollector collector, DocIdSetIterator iterator, TwoPhaseIterator twoPhase, Bits acceptDocs) throws IOException {
            if (twoPhase == null) {
                int doc = iterator.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector.collect(doc);
                    }
                    doc = iterator.nextDoc();
                }
            } else {
                int doc = iterator.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector.collect(doc);
                    }
                    doc = iterator.nextDoc();
                }
            }
        }
    }
}

