/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hbase.table.scanner;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.EmptyResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.hbase.table.row.Column;
import org.apache.knox.gateway.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateScanner {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }

        public String getScannerId() {
            String location;
            int position;
            Header locationHeader = this.response().getFirstHeader("Location");
            if (locationHeader != null && locationHeader.getValue() != null && !locationHeader.getValue().isEmpty() && (position = (location = locationHeader.getValue()).lastIndexOf("/")) != -1) {
                return location.substring(position + 1);
            }
            return null;
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private static final String ELEMENT_SCANNER = "Scanner";
        private static final String ELEMENT_COLUMN = "column";
        private static final String ELEMENT_FILTER = "filter";
        private static final String ATTRIBUTE_START_ROW = "startRow";
        private static final String ATTRIBUTE_END_ROW = "endRow";
        private static final String ATTRIBUTE_BATCH = "batch";
        private static final String ATTRIBUTE_START_TIME = "startTime";
        private static final String ATTRIBUTE_END_TIME = "endTime";
        private static final String ATTRIBUTE_MAX_VERSIONS = "maxVersions";
        private String tableName;
        private String startRow;
        private String endRow;
        private List<Column> columns = new ArrayList<Column>();
        private Integer batch;
        private Long startTime;
        private Long endTime;
        private String filter;
        private Integer maxVersions;

        public Request(KnoxSession session, String tableName) {
            super(session);
            this.tableName = tableName;
        }

        public Request rows(String startRow, String endRow) {
            this.startRow = startRow;
            this.endRow = endRow;
            return this;
        }

        public Request startRow(String startRow) {
            this.startRow = startRow;
            return this;
        }

        public Request endRow(String endRow) {
            this.endRow = endRow;
            return this;
        }

        public Request column(String family, String qualifier) {
            Column column = new Column(family, qualifier);
            this.columns.add(column);
            return this;
        }

        public Request column(String family) {
            return this.column(family, null);
        }

        public Request batch(Integer batch) {
            this.batch = batch;
            return this;
        }

        public Request times(Long startTime, Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            return this;
        }

        public Request startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Request endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Request filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Request maxVersions(Integer maxVersions) {
            this.maxVersions = maxVersions;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    Document document = XmlUtils.createDocument();
                    Element root = document.createElement(Request.ELEMENT_SCANNER);
                    if (startRow != null) {
                        root.setAttribute(Request.ATTRIBUTE_START_ROW, Base64.encodeBase64String((byte[])startRow.getBytes(StandardCharsets.UTF_8)));
                    }
                    if (endRow != null) {
                        root.setAttribute(Request.ATTRIBUTE_END_ROW, Base64.encodeBase64String((byte[])endRow.getBytes(StandardCharsets.UTF_8)));
                    }
                    if (batch != null) {
                        root.setAttribute(Request.ATTRIBUTE_BATCH, batch.toString());
                    }
                    if (startTime != null) {
                        root.setAttribute(Request.ATTRIBUTE_START_TIME, startTime.toString());
                    }
                    if (endTime != null) {
                        root.setAttribute(Request.ATTRIBUTE_END_TIME, endTime.toString());
                    }
                    if (maxVersions != null) {
                        root.setAttribute(Request.ATTRIBUTE_MAX_VERSIONS, maxVersions.toString());
                    }
                    document.appendChild(root);
                    for (Column column : columns) {
                        Element columnElement = document.createElement(Request.ELEMENT_COLUMN);
                        columnElement.setTextContent(Base64.encodeBase64String((byte[])column.toURIPart().getBytes(StandardCharsets.UTF_8)));
                        root.appendChild(columnElement);
                    }
                    if (filter != null && !filter.isEmpty()) {
                        Element filterElement = document.createElement(Request.ELEMENT_FILTER);
                        filterElement.setTextContent(filter);
                        root.appendChild(filterElement);
                    }
                    StringWriter writer = new StringWriter();
                    Transformer t = XmlUtils.getTransformer((boolean)true, (boolean)false, (int)0, (boolean)false);
                    XmlUtils.writeXml((Document)document, (Writer)writer, (Transformer)t);
                    URIBuilder uri = this.uri(new String[]{"/hbase", "/", tableName, "/scanner"});
                    HttpPut request = new HttpPut(uri.build());
                    StringEntity entity = new StringEntity(writer.toString(), ContentType.create((String)"text/xml", (Charset)StandardCharsets.UTF_8));
                    request.setEntity((HttpEntity)entity);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

