/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.manager;

import java.util.List;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.manager.DeployResourceRequest;
import org.apache.knox.gateway.shell.manager.ListDescriptorsRequest;
import org.apache.knox.gateway.shell.manager.ListProviderConfigurationsRequest;
import org.apache.knox.gateway.shell.manager.ListTopologiesRequest;
import org.apache.knox.gateway.shell.manager.ResourceType;
import org.apache.knox.gateway.shell.manager.UndeployResourceRequest;

public class Manager {
    public static List<String> listDescriptors(KnoxSession session) throws Exception {
        return new ListDescriptorsRequest(session).execute();
    }

    public static void deployDescriptor(KnoxSession session, String name, String descriptorFileName) throws Exception {
        new DeployResourceRequest(session, ResourceType.Descriptor, name, descriptorFileName).execute();
    }

    public static void undeployDescriptor(KnoxSession session, String name) throws Exception {
        new UndeployResourceRequest(session, ResourceType.Descriptor, name).execute();
    }

    public static List<String> listProviderConfigurations(KnoxSession session) throws Exception {
        return new ListProviderConfigurationsRequest(session).execute();
    }

    public static void deployProviderConfiguration(KnoxSession session, String name, String providerConfigFileName) throws Exception {
        new DeployResourceRequest(session, ResourceType.ProviderConfiguration, name, providerConfigFileName).execute();
    }

    public static void undeployProviderConfiguration(KnoxSession session, String name) throws Exception {
        new UndeployResourceRequest(session, ResourceType.ProviderConfiguration, name).execute();
    }

    public static List<String> listTopologies(KnoxSession session) throws Exception {
        return new ListTopologiesRequest(session).execute();
    }
}

