/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.knox.gateway.websockets.MessageEventCallback;

public class ProxyInboundClient
extends Endpoint {
    private MessageEventCallback callback;
    protected Session session;
    protected EndpointConfig config;

    public ProxyInboundClient(MessageEventCallback callback) {
        this.callback = callback;
    }

    public void onOpen(Session backendSession, EndpointConfig config) {
        this.session = backendSession;
        this.config = config;
        this.session.setMaxBinaryMessageBufferSize(Integer.MAX_VALUE);
        this.session.setMaxTextMessageBufferSize(Integer.MAX_VALUE);
        this.session.addMessageHandler((MessageHandler)new MessageHandler.Whole<byte[]>(){

            public void onMessage(byte[] message) {
                ProxyInboundClient.this.callback.onMessageBinary(message, true, ProxyInboundClient.this.session);
            }
        });
        this.session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                ProxyInboundClient.this.callback.onMessageText(message, ProxyInboundClient.this.session);
            }
        });
        this.callback.onConnectionOpen(backendSession);
    }

    public void onClose(Session backendSession, CloseReason closeReason) {
        this.callback.onConnectionClose(closeReason);
        this.session = null;
    }

    public void onError(Session backendSession, Throwable cause) {
        this.callback.onError(cause);
        this.session = null;
    }
}

