/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.hadoopauth.HadoopAuthMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public class HadoopAuthPostFilter
implements Filter {
    private static HadoopAuthMessages log = (HadoopAuthMessages)MessagesFactory.get(HadoopAuthMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String principal = httpRequest.getRemoteUser();
        if (principal != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new PrimaryPrincipal(principal));
            log.hadoopAuthAssertedPrincipal(principal);
            auditService.getContext().setUsername(principal);
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            auditor.audit("authentication", sourceUri, "uri", "success");
            this.doAs((ServletRequest)httpRequest, response, chain, subject);
        } else {
            ((HttpServletResponse)response).sendError(403, "User not authenticated");
        }
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }
}

