/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.codec.api.MessageEncoderException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.util.Strings;

public class LdapEncoder {
    private LdapApiService codec;

    public LdapEncoder(LdapApiService codec) {
        if (codec == null) {
            throw new NullPointerException("codec argument cannot be null");
        }
        this.codec = codec;
    }

    private int computeControlLength(Control control) {
        int controlValueLength = ((CodecControl)control).computeLength();
        int oidLengh = Strings.getBytesUtf8(control.getOid()).length;
        int controlLength = 1 + TLV.getNbBytes(oidLengh) + oidLengh;
        if (control.isCritical()) {
            controlLength += 3;
        }
        if (controlValueLength != 0) {
            controlLength += 1 + TLV.getNbBytes(controlValueLength) + controlValueLength;
        }
        return controlLength;
    }

    private ByteBuffer encodeControl(ByteBuffer buffer, Control control) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            int controlLength = this.computeControlLength(control);
            buffer.put(TLV.getBytes(controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
        }
        BerValue.encode(buffer, Strings.getBytesUtf8(control.getOid()));
        if (control.isCritical()) {
            BerValue.encode(buffer, control.isCritical());
        }
        return buffer;
    }

    public ByteBuffer encodeMessage(Message message) throws EncoderException {
        MessageDecorator<Message> decorator = MessageDecorator.getDecorator(this.codec, message);
        int length = this.computeMessageLength(decorator);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        try {
            try {
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(decorator.getMessageLength()));
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
            }
            BerValue.encode(buffer, message.getMessageId());
            decorator.encode(buffer);
            Map<String, Control> controls = decorator.getControls();
            if (controls != null && controls.size() > 0) {
                buffer.put((byte)-96);
                buffer.put(TLV.getBytes(decorator.getControlsLength()));
                for (Control control : controls.values()) {
                    this.encodeControl(buffer, control);
                    int controlValueLength = ((CodecControl)control).computeLength();
                    if (controlValueLength <= 0) continue;
                    buffer.put(UniversalTag.OCTET_STRING.getValue());
                    buffer.put(TLV.getBytes(controlValueLength));
                    ((CodecControl)control).encode(buffer);
                }
            }
        }
        catch (EncoderException ee) {
            throw new MessageEncoderException(message.getMessageId(), ee.getMessage(), ee);
        }
        buffer.flip();
        return buffer;
    }

    private int computeMessageLength(MessageDecorator<? extends Message> messageDecorator) {
        int ldapMessageLength = 2 + BerValue.getNbBytes(messageDecorator.getDecorated().getMessageId());
        ldapMessageLength += messageDecorator.computeLength();
        Map<String, Control> controls = messageDecorator.getControls();
        if (controls.size() > 0) {
            int controlsSequenceLength = 0;
            for (Control control : controls.values()) {
                int controlLength = this.computeControlLength(control);
                controlsSequenceLength += 1 + TLV.getNbBytes(controlLength) + controlLength;
            }
            messageDecorator.setControlsLength(controlsSequenceLength);
            ldapMessageLength += 1 + TLV.getNbBytes(controlsSequenceLength) + controlsSequenceLength;
        }
        messageDecorator.setMessageLength(ldapMessageLength);
        return 1 + ldapMessageLength + TLV.getNbBytes(ldapMessageLength);
    }

    public static void encodeReferral(ByteBuffer buffer, Referral referral) throws EncoderException {
        Collection<byte[]> ldapUrlsBytes = referral.getLdapUrlsBytes();
        if (ldapUrlsBytes != null && !ldapUrlsBytes.isEmpty()) {
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes(referral.getReferralLength()));
            for (byte[] ldapUrlBytes : ldapUrlsBytes) {
                BerValue.encode(buffer, ldapUrlBytes);
            }
        }
    }

    public static int computeReferralLength(Referral referral) {
        if (referral != null) {
            Collection<String> ldapUrls = referral.getLdapUrls();
            if (ldapUrls != null && !ldapUrls.isEmpty()) {
                int referralLength = 0;
                for (String ldapUrl : ldapUrls) {
                    byte[] ldapUrlBytes = Strings.getBytesUtf8(ldapUrl);
                    referralLength += 1 + TLV.getNbBytes(ldapUrlBytes.length) + ldapUrlBytes.length;
                    referral.addLdapUrlBytes(ldapUrlBytes);
                }
                referral.setReferralLength(referralLength);
                return referralLength;
            }
            return 0;
        }
        return 0;
    }
}

