/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.aci.ACIItem;
import org.apache.directory.api.ldap.aci.ACIItemParser;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleCache {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCache.class);
    private final Map<String, List<ACITuple>> tuples = new HashMap<String, List<ACITuple>>();
    private final DirectoryService directoryService;
    private final DnFactory dnFactory;
    private final PartitionNexus nexus;
    private final ACIItemParser aciParser;

    public TupleCache(CoreSession session) throws LdapException {
        this.directoryService = session.getDirectoryService();
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        this.dnFactory = this.directoryService.getDnFactory();
        this.nexus = this.directoryService.getPartitionNexus();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(schemaManager);
        this.aciParser = new ACIItemParser(ncn, schemaManager);
        this.initialize(session);
    }

    private Dn parseNormalized(String name) throws LdapException {
        Dn dn = this.dnFactory.create(name);
        return dn;
    }

    private void initialize(CoreSession session) throws LdapException {
        Set<String> suffixes = this.nexus.listSuffixes();
        for (String suffix : suffixes) {
            Dn baseDn = this.parseNormalized(suffix);
            EqualityNode<String> filter = new EqualityNode<String>(this.directoryService.getAtProvider().getObjectClass(), new StringValue("accessControlSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"*", "+"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(session, baseDn, filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            try {
                while (results.next()) {
                    Entry result = (Entry)results.get();
                    Dn subentryDn = result.getDn().apply(session.getDirectoryService().getSchemaManager());
                    Attribute aci = result.get(this.directoryService.getAtProvider().getPrescriptiveACI());
                    if (aci == null) {
                        LOG.warn("Found accessControlSubentry '" + subentryDn + "' without any " + "prescriptiveACI");
                        continue;
                    }
                    this.subentryAdded(subentryDn, result);
                }
                results.close();
            }
            catch (Exception e) {
                throw new LdapOperationErrorException(e.getMessage(), e);
            }
        }
    }

    private boolean hasPrescriptiveACI(Entry entry) throws LdapException {
        Attribute aci = entry.get(this.directoryService.getAtProvider().getPrescriptiveACI());
        if (aci == null) {
            if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), "accessControlSubentry")) {
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, "");
            }
            return false;
        }
        return true;
    }

    public void subentryAdded(Dn dn, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        Attribute prescriptiveAci = entry.get(this.directoryService.getAtProvider().getPrescriptiveACI());
        ArrayList<ACITuple> entryTuples = new ArrayList<ACITuple>();
        for (Value value : prescriptiveAci) {
            String aci = value.getString();
            ACIItem item = null;
            try {
                item = this.aciParser.parse(aci);
                entryTuples.addAll(item.toTuples());
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_28, item);
                LOG.error(msg, e);
            }
        }
        this.tuples.put(dn.getNormName(), entryTuples);
    }

    public void subentryDeleted(Dn normName, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        this.tuples.remove(normName.toString());
    }

    public void subentryModified(Dn normName, List<Modification> mods, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        for (Modification mod : mods) {
            if (!mod.getAttribute().isInstanceOf(this.directoryService.getAtProvider().getPrescriptiveACI())) continue;
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public void subentryModified(Dn normName, Entry mods, Entry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        if (mods.get(this.directoryService.getAtProvider().getPrescriptiveACI()) != null) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<ACITuple> getACITuples(String subentryDn) {
        List<ACITuple> aciTuples = this.tuples.get(subentryDn);
        if (aciTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aciTuples);
    }

    public void subentryRenamed(Dn oldName, Dn newName) {
        this.tuples.put(newName.getNormName(), this.tuples.remove(oldName.getNormName()));
    }
}

