/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLPropertyConfig;

class AmbariDynamicServiceURLCreator
implements ServiceURLCreator {
    static final String MAPPING_CONFIG_OVERRIDE_FILE = "ambari-discovery-url-mappings.xml";
    static final String MAPPING_CONFIG_OVERRIDE_PROPERTY = "org.apache.gateway.topology.discovery.ambari.config";
    private AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private AmbariCluster cluster = null;
    private ServiceURLPropertyConfig config;

    AmbariDynamicServiceURLCreator() {
    }

    AmbariDynamicServiceURLCreator(AmbariCluster cluster) {
        this();
        this.init(cluster);
    }

    AmbariDynamicServiceURLCreator(AmbariCluster cluster, File mappingConfiguration) throws IOException {
        this.cluster = cluster;
        this.config = new ServiceURLPropertyConfig(new FileInputStream(mappingConfiguration));
    }

    AmbariDynamicServiceURLCreator(AmbariCluster cluster, String mappings) {
        this.cluster = cluster;
        this.config = new ServiceURLPropertyConfig(new ByteArrayInputStream(mappings.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void init(AmbariCluster cluster) {
        File mappingConfigFile;
        File overridesFile;
        this.cluster = cluster;
        this.config = new ServiceURLPropertyConfig();
        String mappingConfiguration = null;
        String gatewayConfDir = System.getProperty("org.apache.knox.gateway.conf.dir");
        if (gatewayConfDir != null && (overridesFile = new File(gatewayConfDir, MAPPING_CONFIG_OVERRIDE_FILE)).exists()) {
            mappingConfiguration = overridesFile.getAbsolutePath();
        }
        if (mappingConfiguration == null) {
            mappingConfiguration = System.getProperty(MAPPING_CONFIG_OVERRIDE_PROPERTY);
        }
        if (mappingConfiguration != null && (mappingConfigFile = new File(mappingConfiguration)).exists()) {
            try {
                ServiceURLPropertyConfig overrides = new ServiceURLPropertyConfig(mappingConfigFile);
                this.log.loadedComponentConfigMappings(mappingConfigFile.getAbsolutePath());
                this.config.setAll(overrides);
            }
            catch (Exception e) {
                this.log.failedToLoadComponentConfigMappings(mappingConfigFile.getAbsolutePath(), e);
            }
        }
    }

    @Override
    public String getTargetService() {
        return null;
    }

    @Override
    public List<String> create(String serviceName, Map<String, String> serviceParams) {
        ArrayList<String> urls = new ArrayList<String>();
        HashMap<String, String> placeholderValues = new HashMap<String, String>();
        ArrayList<String> componentHostnames = new ArrayList<String>();
        String hostNamePlaceholder = null;
        ServiceURLPropertyConfig.URLPattern pattern = this.config.getURLPattern(serviceName);
        if (pattern != null) {
            for (String propertyName : pattern.getPlaceholders()) {
                ServiceURLPropertyConfig.Property configProperty = this.config.getConfigProperty(serviceName, propertyName);
                String propertyValue = null;
                if (configProperty != null) {
                    String propertyType = configProperty.getType();
                    if ("SERVICE".equals(propertyType)) {
                        this.log.lookingUpServiceConfigProperty(configProperty.getService(), configProperty.getServiceConfig(), configProperty.getValue());
                        AmbariCluster.ServiceConfiguration svcConfig = this.cluster.getServiceConfiguration(configProperty.getService(), configProperty.getServiceConfig());
                        if (svcConfig != null) {
                            propertyValue = svcConfig.getProperties().get(configProperty.getValue());
                        }
                    } else if ("COMPONENT".equals(propertyType)) {
                        AmbariComponent component;
                        String compName = configProperty.getComponent();
                        if (compName != null && (component = this.cluster.getComponent(compName)) != null) {
                            if ("component.host.name".equals(configProperty.getValue())) {
                                this.log.lookingUpComponentHosts(compName);
                                componentHostnames.addAll(component.getHostNames());
                                hostNamePlaceholder = propertyName;
                            } else {
                                this.log.lookingUpComponentConfigProperty(compName, configProperty.getValue());
                                propertyValue = component.getConfigProperty(configProperty.getValue());
                            }
                        }
                    } else {
                        this.log.handlingDerivedProperty(serviceName, configProperty.getType(), configProperty.getName());
                        ServiceURLPropertyConfig.Property p = this.config.getConfigProperty(serviceName, configProperty.getName());
                        propertyValue = p.getValue();
                        if (propertyValue == null && p.getConditionHandler() != null) {
                            propertyValue = p.getConditionHandler().evaluate(this.config, this.cluster);
                        }
                    }
                }
                this.log.determinedPropertyValue(configProperty.getName(), propertyValue);
                placeholderValues.put(configProperty.getName(), propertyValue);
            }
            if (!componentHostnames.isEmpty()) {
                for (String componentHostname : componentHostnames) {
                    String url = pattern.get().replace("{" + hostNamePlaceholder + "}", componentHostname);
                    urls.add(this.createURL(url, placeholderValues));
                }
            } else {
                urls.add(this.createURL(pattern.get(), placeholderValues));
            }
        }
        return urls;
    }

    private String createURL(String pattern, Map<String, String> placeholderValues) {
        String url = null;
        if (pattern != null) {
            url = pattern;
            for (Map.Entry<String, String> placeHolder : placeholderValues.entrySet()) {
                String value = placeHolder.getValue();
                if (value == null) continue;
                url = url.replace("{" + placeHolder.getKey() + "}", value);
            }
        }
        return url;
    }
}

