/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.service.definition.ServiceDefinitionChangeListener;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.services.topology.monitor.DescriptorsMonitor;
import org.apache.knox.gateway.services.topology.monitor.SharedProviderConfigMonitor;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.TopologyEvent;
import org.apache.knox.gateway.topology.TopologyListener;
import org.apache.knox.gateway.topology.TopologyMonitor;
import org.apache.knox.gateway.topology.TopologyProvider;
import org.apache.knox.gateway.topology.Version;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitorServiceFactory;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorFactory;
import org.apache.knox.gateway.topology.validation.TopologyValidator;
import org.apache.knox.gateway.util.ServiceDefinitionsLoader;
import org.apache.knox.gateway.util.TopologyUtils;
import org.xml.sax.SAXException;

public class DefaultTopologyService
extends FileAlterationListenerAdaptor
implements TopologyService,
TopologyMonitor,
TopologyProvider,
FileFilter,
FileAlterationListener,
ServiceDefinitionChangeListener {
    private static final JAXBContext jaxbContext = DefaultTopologyService.getJAXBContext();
    private static final String TOPOLOGY_CLOSING_XML_ELEMENT = "</topology>";
    private static final String REDEPLOY_TIME_TEMPLATE = "   <redeployTime>%d</redeployTime>\n</topology>";
    private static final Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    public static final List<String> SUPPORTED_TOPOLOGY_FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("xml", "conf"));
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final Map<String, FileAlterationMonitor> monitors = new ConcurrentHashMap<String, FileAlterationMonitor>();
    private File topologiesDirectory;
    private File sharedProvidersDirectory;
    private File descriptorsDirectory;
    private DescriptorsMonitor descriptorsMonitor;
    private Set<TopologyListener> listeners;
    private Map<File, Topology> topologies;
    private AliasService aliasService;
    private RemoteConfigurationMonitor remoteMonitor;
    private GatewayConfig config;

    private static JAXBContext getJAXBContext() {
        String pkgName = Topology.class.getPackage().getName();
        String bindingFile = pkgName.replace(".", "/") + "/topology_binding-xml.xml";
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("eclipselink.oxm.metadata-source", bindingFile);
        try {
            return JAXBContext.newInstance((String)pkgName, (ClassLoader)Topology.class.getClassLoader(), properties);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private Topology loadTopology(File file) throws IOException, SAXException, InterruptedException {
        Topology topology;
        long TIMEOUT = 250L;
        long DELAY = 50L;
        log.loadingTopologyFile(file.getAbsolutePath());
        long start = System.currentTimeMillis();
        while (true) {
            try {
                topology = this.loadTopologyAttempt(file);
            }
            catch (IOException | SAXException e) {
                if (System.currentTimeMillis() - start < 250L) {
                    log.failedToLoadTopologyRetrying(file.getAbsolutePath(), Long.toString(50L), e);
                    Thread.sleep(50L);
                    continue;
                }
                throw e;
            }
            break;
        }
        return topology;
    }

    public Topology parse(String content) throws IOException, SAXException {
        return TopologyUtils.parse(content);
    }

    private Topology loadTopologyAttempt(File file) throws IOException, SAXException {
        String topologyContent = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Topology topology = this.parse(topologyContent);
        if (topology != null) {
            topology.setUri(file.toURI());
            topology.setName(FilenameUtils.removeExtension((String)file.getName()));
            topology.setTimestamp(file.lastModified());
        }
        return topology;
    }

    private void redeployTopology(Topology topology) {
        File topologyFile = new File(topology.getUri());
        try {
            TopologyValidator tv = new TopologyValidator(topology);
            if (!tv.validateTopology()) {
                if (this.config != null && this.config.isTopologyValidationEnabled()) {
                    throw new SAXException(tv.getErrorString());
                }
                log.failedToValidateTopology(topology.getName(), tv.getErrorString());
            }
            try {
                String currentTopologyContent = FileUtils.readFileToString((File)topologyFile, (Charset)StandardCharsets.UTF_8);
                String updated = currentTopologyContent.replaceAll("^*<redeployTime>.*", "");
                updated = updated.replace(TOPOLOGY_CLOSING_XML_ELEMENT, String.format(Locale.getDefault(), REDEPLOY_TIME_TEMPLATE, System.currentTimeMillis()));
                FileUtils.write((File)topologyFile, (CharSequence)updated, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                auditor.audit("redeploy", topology.getName(), "topology", "failure");
                log.failedToRedeployTopology(topology.getName(), e);
            }
        }
        catch (SAXException e) {
            auditor.audit("redeploy", topology.getName(), "topology", "failure");
            log.failedToRedeployTopology(topology.getName(), e);
        }
    }

    private List<TopologyEvent> createChangeEvents(Map<File, Topology> oldTopologies, Map<File, Topology> newTopologies) {
        ArrayList<TopologyEvent> events = new ArrayList<TopologyEvent>();
        for (Map.Entry<File, Topology> oldTopology : oldTopologies.entrySet()) {
            if (newTopologies.containsKey(oldTopology.getKey())) continue;
            events.add(new TopologyEvent(TopologyEvent.Type.DELETED, oldTopology.getValue()));
        }
        for (Map.Entry<File, Topology> newTopology : newTopologies.entrySet()) {
            if (oldTopologies.containsKey(newTopology.getKey())) {
                Topology oldTopology = oldTopologies.get(newTopology.getKey());
                if (!this.shouldMarkTopologyUpdated(newTopology.getValue(), oldTopology)) continue;
                events.add(new TopologyEvent(TopologyEvent.Type.UPDATED, newTopology.getValue()));
                continue;
            }
            events.add(new TopologyEvent(TopologyEvent.Type.CREATED, newTopology.getValue()));
        }
        return events;
    }

    private boolean shouldMarkTopologyUpdated(Topology newTopology, Topology oldTopology) {
        boolean topologyChanged;
        boolean timestampUpdated = newTopology.getTimestamp() > oldTopology.getTimestamp();
        boolean bl = topologyChanged = !oldTopology.equals((Object)newTopology);
        if (topologyChanged) {
            return true;
        }
        return this.config.topologyRedeploymentRequiresChanges() ? false : timestampUpdated;
    }

    private File calculateAbsoluteTopologiesDir(GatewayConfig config) {
        File topoDir = new File(config.getGatewayTopologyDir());
        topoDir = topoDir.getAbsoluteFile();
        return topoDir;
    }

    private File calculateAbsoluteConfigDir(GatewayConfig config) {
        String path = config.getGatewayConfDir();
        File configDir = path != null ? new File(path) : new File(config.getGatewayTopologyDir()).getParentFile();
        return configDir.getAbsoluteFile();
    }

    private void initListener(String monitorName, FileAlterationMonitor monitor, File directory, FileFilter filter, FileAlterationListener listener) {
        this.monitors.put(monitorName, monitor);
        FileAlterationObserver observer = new FileAlterationObserver(directory, filter);
        observer.addListener(listener);
        monitor.addObserver(observer);
    }

    private void initListener(String monitorName, File directory, FileFilter filter, FileAlterationListener listener) {
        this.initListener(monitorName, new FileAlterationMonitor(5000L), directory, filter, listener);
    }

    private Map<File, Topology> loadTopologies(File directory) {
        File[] existingTopologies;
        HashMap<File, Topology> map = new HashMap<File, Topology>();
        if (directory.isDirectory() && directory.canRead() && (existingTopologies = directory.listFiles(this)) != null) {
            for (File file : existingTopologies) {
                try {
                    Topology loadTopology = this.loadTopology(file);
                    if (null != loadTopology) {
                        map.put(file, loadTopology);
                        continue;
                    }
                    auditor.audit("load", file.getAbsolutePath(), "topology", "failure");
                    log.failedToLoadTopology(file.getAbsolutePath());
                }
                catch (Exception e) {
                    auditor.audit("load", file.getAbsolutePath(), "topology", "failure");
                    log.failedToLoadTopology(file.getAbsolutePath(), e);
                }
            }
        }
        return map;
    }

    public void setAliasService(AliasService as) {
        this.aliasService = as;
    }

    public void deployTopology(Topology t) {
        try {
            File temp = new File(this.topologiesDirectory.getAbsolutePath() + "/" + t.getName() + ".xml.temp");
            Marshaller mr = jaxbContext.createMarshaller();
            mr.setProperty("jaxb.formatted.output", (Object)true);
            mr.marshal((Object)t, temp);
            File topology = new File(this.topologiesDirectory.getAbsolutePath() + "/" + t.getName() + ".xml");
            if (!temp.renameTo(topology)) {
                FileUtils.forceDelete((File)temp);
                throw new IOException("Could not rename temp file");
            }
            TopologyValidator validator = new TopologyValidator(topology.getAbsolutePath());
            if (!validator.validateTopology()) {
                throw new SAXException(validator.getErrorString());
            }
        }
        catch (IOException | JAXBException | SAXException e) {
            auditor.audit("deploy", t.getName(), "topology", "failure");
            log.failedToDeployTopology(t.getName(), e);
        }
        this.reloadTopologies();
    }

    public void redeployTopology(String topologyName) {
        for (Topology topology : this.getTopologies()) {
            if (topologyName != null && !topologyName.equals(topology.getName())) continue;
            this.redeployTopology(topology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTopologies() {
        try {
            DefaultTopologyService defaultTopologyService = this;
            synchronized (defaultTopologyService) {
                Map<File, Topology> oldTopologies = this.topologies;
                Map<File, Topology> newTopologies = this.loadTopologies(this.topologiesDirectory);
                List<TopologyEvent> events = this.createChangeEvents(oldTopologies, newTopologies);
                this.topologies = newTopologies;
                if (!events.isEmpty()) {
                    this.notifyChangeListeners(events);
                }
            }
        }
        catch (Exception e) {
            log.failedToReloadTopologies(e);
        }
    }

    public void deleteTopology(Topology t) {
        File topoDir = this.topologiesDirectory;
        if (topoDir.isDirectory() && topoDir.canRead()) {
            for (File f : DefaultTopologyService.listFiles(topoDir)) {
                String fName = FilenameUtils.getBaseName((String)f.getName());
                if (!fName.equals(t.getName())) continue;
                f.delete();
            }
        }
        this.reloadTopologies();
    }

    private void notifyChangeListeners(List<TopologyEvent> events) {
        for (TopologyListener listener : this.listeners) {
            try {
                listener.handleTopologyEvent(events);
            }
            catch (RuntimeException e) {
                auditor.audit("load", "Topology_Event", "topology", "failure");
                log.failedToHandleTopologyEvents(e);
            }
        }
    }

    public Map<String, List<String>> getServiceTestURLs(Topology t, GatewayConfig config) {
        File tFile = null;
        HashMap<String, List<String>> urls = new HashMap<String, List<String>>();
        if (this.topologiesDirectory.isDirectory() && this.topologiesDirectory.canRead()) {
            for (File f : DefaultTopologyService.listFiles(this.topologiesDirectory)) {
                if (!FilenameUtils.removeExtension((String)f.getName()).equals(t.getName())) continue;
                tFile = f;
            }
        }
        if (tFile != null) {
            Set<ServiceDefinition> defs = ServiceDefinitionsLoader.getServiceDefinitions(new File(config.getGatewayServicesDir()));
            for (ServiceDefinition def : defs) {
                urls.put(def.getRole(), def.getTestURLs());
            }
        }
        return urls;
    }

    public Collection<Topology> getTopologies() {
        Map<File, Topology> map = this.topologies;
        return Collections.unmodifiableCollection(map.values());
    }

    public boolean deployProviderConfiguration(String name, String content) {
        boolean result = DefaultTopologyService.writeConfig(this.sharedProvidersDirectory, name, content);
        if (this.remoteMonitor != null) {
            this.remoteMonitor.createProvider(name, content);
        }
        return result;
    }

    public Collection<File> getProviderConfigurations() {
        ArrayList<File> providerConfigs = new ArrayList<File>();
        for (File providerConfig : DefaultTopologyService.listFiles(this.sharedProvidersDirectory)) {
            if (!SharedProviderConfigMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)providerConfig.getName()))) continue;
            providerConfigs.add(providerConfig);
        }
        return providerConfigs;
    }

    public boolean deleteProviderConfiguration(String name) {
        return this.deleteProviderConfiguration(name, false);
    }

    public boolean deleteProviderConfiguration(String name, boolean force) {
        boolean result = false;
        boolean hasReferences = false;
        File providerConfig = DefaultTopologyService.getExistingFile(this.sharedProvidersDirectory, name);
        if (providerConfig != null) {
            List<String> references = this.descriptorsMonitor.getReferencingDescriptors(providerConfig.getAbsolutePath());
            hasReferences = !references.isEmpty();
        } else {
            result = true;
        }
        if (force || providerConfig == null || !hasReferences) {
            if (this.remoteMonitor != null) {
                this.remoteMonitor.deleteProvider(providerConfig.getName());
            }
            result = providerConfig == null || !providerConfig.exists() || providerConfig.delete();
        } else {
            log.preventedDeletionOfSharedProviderConfiguration(providerConfig.getAbsolutePath());
        }
        return result;
    }

    public boolean deployDescriptor(String name, String content) {
        boolean result = DefaultTopologyService.writeConfig(this.descriptorsDirectory, name, content);
        if (this.remoteMonitor != null) {
            return this.remoteMonitor.createDescriptor(name, content);
        }
        return result;
    }

    public Collection<File> getDescriptors() {
        ArrayList<File> descriptors = new ArrayList<File>();
        for (File descriptor : DefaultTopologyService.listFiles(this.descriptorsDirectory)) {
            if (!DescriptorsMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)descriptor.getName()))) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public boolean deleteDescriptor(String name) {
        boolean result;
        File descriptor = DefaultTopologyService.getExistingFile(this.descriptorsDirectory, name);
        boolean bl = result = descriptor == null || descriptor.delete();
        if (this.remoteMonitor != null && descriptor != null) {
            this.remoteMonitor.deleteDescriptor(descriptor.getName());
        }
        return result;
    }

    public void addTopologyChangeListener(TopologyListener listener) {
        this.listeners.add(listener);
    }

    public void onServiceDefinitionChange(String name, String role, String version) {
        this.getTopologies().stream().filter(topology -> topology.getServices().stream().anyMatch(service -> this.isRelevantService((Service)service, role, name, version))).forEach(topology -> {
            log.redeployingTopologyOnServiceDefinitionChange(topology.getName(), name, role, version);
            this.redeployTopology((Topology)topology);
        });
    }

    private boolean isRelevantService(Service service, String role, String name, String version) {
        return service.getRole().equalsIgnoreCase(role) && (service.getName() == null || service.getName().equalsIgnoreCase(name) && (service.getVersion() == null || service.getVersion().equals((Object)new Version(version))));
    }

    public void startMonitor() throws Exception {
        for (Map.Entry<String, FileAlterationMonitor> monitor : this.monitors.entrySet()) {
            monitor.getValue().start();
            log.startedMonitor(monitor.getKey());
        }
        if (this.remoteMonitor != null) {
            try {
                this.remoteMonitor.start();
            }
            catch (Exception e) {
                log.remoteConfigurationMonitorStartFailure(this.remoteMonitor.getClass().getTypeName(), e.getLocalizedMessage());
            }
        }
        this.reloadDescriptors();
    }

    public void reloadDescriptors() {
        log.loadingDescriptorsFromDirectory(this.descriptorsDirectory.getAbsolutePath());
        for (File descriptor : this.getDescriptors()) {
            this.descriptorsMonitor.onFileChange(descriptor);
        }
    }

    public void stopMonitor() throws Exception {
        for (Map.Entry<String, FileAlterationMonitor> monitor : this.monitors.entrySet()) {
            monitor.getValue().stop();
            log.stoppedMonitor(monitor.getKey());
        }
        if (this.remoteMonitor != null) {
            this.remoteMonitor.stop();
        }
    }

    @Override
    public boolean accept(File file) {
        String extension;
        boolean accept = false;
        if (!file.isDirectory() && file.canRead() && SUPPORTED_TOPOLOGY_FILE_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
            accept = true;
        }
        return accept;
    }

    public void onFileCreate(File file) {
        this.onFileChange(file);
    }

    public void onFileDelete(File file) {
        this.onFileChange(file);
    }

    public void onFileChange(File file) {
        this.reloadTopologies();
    }

    public void stop() {
    }

    public void start() {
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        GatewayServices gwServices;
        this.config = config;
        String gatewayConfDir = config.getGatewayConfDir();
        if (gatewayConfDir != null) {
            System.setProperty("org.apache.knox.gateway.conf.dir", gatewayConfDir);
        }
        if ((gwServices = GatewayServer.getGatewayServices()) != null) {
            ClusterConfigurationMonitorService ccms = (ClusterConfigurationMonitorService)gwServices.getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE);
            ccms.addListener((ClusterConfigurationMonitor.ConfigurationChangeListener)new TopologyDiscoveryTrigger(this, ccms));
        }
        try {
            this.listeners = new HashSet<TopologyListener>();
            this.topologies = new HashMap<File, Topology>();
            this.topologiesDirectory = this.calculateAbsoluteTopologiesDir(config);
            File configDirectory = this.calculateAbsoluteConfigDir(config);
            this.descriptorsDirectory = new File(configDirectory, "descriptors");
            this.sharedProvidersDirectory = new File(configDirectory, "shared-providers");
            this.initListener("topologies", this.topologiesDirectory, this, this);
            log.configuredMonitoringTopologyChangesInDirectory(this.topologiesDirectory.getAbsolutePath());
            this.descriptorsMonitor = new DescriptorsMonitor(config, this.topologiesDirectory, this.aliasService);
            this.initListener("simple descriptors", this.descriptorsDirectory, this.descriptorsMonitor, (FileAlterationListener)this.descriptorsMonitor);
            log.configuredMonitoringDescriptorChangesInDirectory(this.descriptorsDirectory.getAbsolutePath());
            SharedProviderConfigMonitor spm = new SharedProviderConfigMonitor(this.descriptorsMonitor, this.descriptorsDirectory);
            this.initListener("shared provider configurations", this.sharedProvidersDirectory, spm, (FileAlterationListener)spm);
            log.configuredMonitoringProviderConfigChangesInDirectory(this.sharedProvidersDirectory.getAbsolutePath());
            if (gwServices != null) {
                RemoteConfigurationMonitorServiceFactory provider = new RemoteConfigurationMonitorServiceFactory();
                this.remoteMonitor = (RemoteConfigurationMonitor)provider.create(gwServices, ServiceType.REMOTE_CONFIGURATION_MONITOR, config, Collections.emptyMap());
            }
        }
        catch (Exception e) {
            throw new ServiceLifecycleException(e.getMessage(), e);
        }
    }

    private static Collection<File> listFiles(File directory) {
        return FileUtils.listFiles((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    private static File getExistingFile(File directory, String basename) {
        File match = null;
        for (File file : DefaultTopologyService.listFiles(directory)) {
            if (!FilenameUtils.getBaseName((String)file.getName()).equals(basename)) continue;
            match = file;
            break;
        }
        return match;
    }

    private static boolean writeConfig(File dest, String name, String content) {
        boolean result = false;
        File destFile = new File(dest, name);
        try {
            FileUtils.writeStringToFile((File)destFile, (String)content, (Charset)StandardCharsets.UTF_8);
            log.wroteConfigurationFile(destFile.getAbsolutePath());
            result = true;
        }
        catch (IOException e) {
            log.failedToWriteConfigurationFile(destFile.getAbsolutePath(), e);
        }
        return result;
    }

    private static class TopologyDiscoveryTrigger
    implements ClusterConfigurationMonitor.ConfigurationChangeListener {
        private final TopologyService topologyService;
        private final ClusterConfigurationMonitorService ccms;

        TopologyDiscoveryTrigger(TopologyService topologyService, ClusterConfigurationMonitorService ccms) {
            this.topologyService = topologyService;
            this.ccms = ccms;
        }

        public void onConfigurationChange(String source, String clusterName) {
            log.noticedClusterConfigurationChange(source, clusterName);
            boolean affectedDescriptors = false;
            for (File descriptor : this.topologyService.getDescriptors()) {
                try {
                    SimpleDescriptor sd = SimpleDescriptorFactory.parse((String)descriptor.getAbsolutePath());
                    if (!source.equals(sd.getDiscoveryAddress()) || !clusterName.equals(sd.getCluster())) continue;
                    affectedDescriptors = true;
                    log.triggeringTopologyRegeneration(source, clusterName, descriptor.getAbsolutePath());
                    descriptor.setLastModified(System.currentTimeMillis());
                }
                catch (IOException e) {
                    log.errorRespondingToConfigChange(source, clusterName, descriptor.getName(), e);
                }
            }
            if (!affectedDescriptors) {
                this.ccms.clearCache(source, clusterName);
            }
        }
    }
}

