/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.sharepoint;

import com.microsoft.schemas.sharepoint.soap.directory.GetGroupCollectionFromUserResponseGetGroupCollectionFromUserResult;
import com.microsoft.schemas.sharepoint.soap.directory.GetRoleCollectionFromUserResponseGetRoleCollectionFromUserResult;
import com.microsoft.schemas.sharepoint.soap.directory.GetUserInfoResponseGetUserInfoResult;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupLocator;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupSoap;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupSoapStub;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.http.client.HttpClient;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.w3c.dom.Element;

public class SPSProxyHelper {
    public static final String HTTPCLIENT_PROPERTY = "ManifoldCF_HttpClient";
    private final String serverUrl;
    private final String serverLocation;
    private final String decodedServerLocation;
    private final String baseUrl;
    private final String userName;
    private final String password;
    private final boolean isClaimSpace;
    private final EngineConfiguration configuration;
    private final HttpClient httpClient;

    public SPSProxyHelper(String serverUrl, String serverLocation, String decodedServerLocation, String userName, String password, Class resourceClass, String configFileName, HttpClient httpClient, boolean isClaimSpace) {
        this.serverUrl = serverUrl;
        this.serverLocation = serverLocation;
        this.decodedServerLocation = decodedServerLocation;
        this.baseUrl = serverLocation.equals("/") ? serverUrl : serverUrl + serverLocation;
        this.userName = userName;
        this.password = password;
        this.configuration = new ResourceProvider(resourceClass, configFileName);
        this.httpClient = httpClient;
        this.isClaimSpace = isClaimSpace;
    }

    public List<String> getAccessTokens(String site, String userLoginName) throws ManifoldCFException {
        try {
            MessageElement groups;
            MessageElement users;
            if (site.compareTo("/") == 0) {
                site = "";
            }
            userLoginName = this.mapToClaimSpace(userLoginName);
            UserGroupWS userService = new UserGroupWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            UserGroupSoap userCall = userService.getUserGroupSoapHandler();
            GetUserInfoResponseGetUserInfoResult userResp = userCall.getUserInfo(userLoginName);
            MessageElement[] usersList = userResp.get_any();
            if (usersList.length != 1) {
                throw new ManifoldCFException("Bad response - expecting one outer 'GetUserInfo' node, saw " + Integer.toString(usersList.length));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("SharePoint authority: getUserInfo xml response: '" + usersList[0].toString() + "'"));
            }
            if (!(users = usersList[0]).getElementName().getLocalName().equals("GetUserInfo")) {
                throw new ManifoldCFException("Bad response - outer node should have been 'GetUserInfo' node");
            }
            String userID = null;
            String userName = null;
            Iterator userIter = users.getChildElements();
            while (userIter.hasNext()) {
                MessageElement child = (MessageElement)userIter.next();
                if (!child.getElementName().getLocalName().equals("User")) continue;
                userID = child.getAttribute("ID");
                userName = child.getAttribute("LoginName");
            }
            if (userID == null) {
                return null;
            }
            ArrayList<String> accessTokens = new ArrayList<String>();
            accessTokens.add("U" + userName);
            GetGroupCollectionFromUserResponseGetGroupCollectionFromUserResult userGroupResp = userCall.getGroupCollectionFromUser(userLoginName);
            MessageElement[] groupsList = userGroupResp.get_any();
            if (groupsList.length != 1) {
                throw new ManifoldCFException("Bad response - expecting one outer 'GetGroupCollectionFromUser' node, saw " + Integer.toString(groupsList.length));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("SharePoint authority: getGroupCollectionFromUser xml response: '" + groupsList[0].toString() + "'"));
            }
            if (!(groups = groupsList[0]).getElementName().getLocalName().equals("GetGroupCollectionFromUser")) {
                throw new ManifoldCFException("Bad response - outer node should have been 'GetGroupCollectionFromUser' node");
            }
            Iterator groupsIter = groups.getChildElements();
            while (groupsIter.hasNext()) {
                MessageElement child = (MessageElement)groupsIter.next();
                if (!child.getElementName().getLocalName().equals("Groups")) continue;
                Iterator groupIter = child.getChildElements();
                while (groupIter.hasNext()) {
                    MessageElement group = (MessageElement)groupIter.next();
                    if (!group.getElementName().getLocalName().equals("Group")) continue;
                    String groupID = group.getAttribute("ID");
                    String groupName = group.getAttribute("Name");
                    accessTokens.add("G" + groupName);
                }
            }
            try {
                MessageElement roles;
                GetRoleCollectionFromUserResponseGetRoleCollectionFromUserResult userRoleResp = userCall.getRoleCollectionFromUser(userLoginName);
                MessageElement[] rolesList = userRoleResp.get_any();
                if (rolesList.length != 1) {
                    throw new ManifoldCFException("Bad response - expecting one outer 'GetRoleCollectionFromUser' node, saw " + Integer.toString(rolesList.length));
                }
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("SharePoint authority: getRoleCollectionFromUser xml response: '" + rolesList[0].toString() + "'"));
                }
                if (!(roles = rolesList[0]).getElementName().getLocalName().equals("GetRoleCollectionFromUser")) {
                    throw new ManifoldCFException("Bad response - outer node should have been 'GetRoleCollectionFromUser' node");
                }
                Iterator rolesIter = roles.getChildElements();
                while (rolesIter.hasNext()) {
                    MessageElement child = (MessageElement)rolesIter.next();
                    if (!child.getElementName().getLocalName().equals("Roles")) continue;
                    Iterator roleIter = child.getChildElements();
                    while (roleIter.hasNext()) {
                        MessageElement role = (MessageElement)roleIter.next();
                        if (!role.getElementName().getLocalName().equals("Role")) continue;
                        String roleID = role.getAttribute("ID");
                        String roleName = role.getAttribute("Name");
                        accessTokens.add("R" + roleName);
                    }
                }
            }
            catch (AxisFault e) {
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                    if (elem != null) {
                        elem.normalize();
                        String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                        if (!sharepointErrorCode.equals("0x80131600")) {
                            throw e;
                        }
                    }
                }
                throw e;
            }
            return accessTokens;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("SharePoint: Got a service exception getting the acls for site " + site), (Throwable)e);
            }
            throw new ManifoldCFException("Service exception: " + e.getMessage(), (Throwable)e);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("SharePoint: The page at " + this.baseUrl + site + " did not exist"));
                        }
                        throw new ManifoldCFException("The page at " + this.baseUrl + site + " did not exist");
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("SharePoint: The user did not have access to the usergroups service for " + this.baseUrl + site));
                        }
                        throw new ManifoldCFException("The user did not have access to the usergroups service at " + this.baseUrl + site);
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x80131600")) {
                        return null;
                    }
                    if (Logging.authorityConnectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.authorityConnectors.debug((Object)("SharePoint: Getting usergroups in site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString), (Throwable)e);
                    }
                    throw new ManifoldCFException("SharePoint server error code: " + sharepointErrorCode);
                }
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("SharePoint: Unknown SharePoint server error getting usergroups for site " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString()), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown SharePoint server error: " + e.getMessage());
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("SharePoint: Got an unknown remote exception getting usergroups for " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString()), (Throwable)e);
            }
            throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("SharePoint: Got an unexpected remote exception usergroups for site " + site), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkConnection(String site) throws ManifoldCFException {
        try {
            if (site.equals("/")) {
                site = "";
            }
            UserGroupWS userService = new UserGroupWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            UserGroupSoap userCall = userService.getUserGroupSoapHandler();
            GetUserInfoResponseGetUserInfoResult userResp = userCall.getUserInfo(this.mapToClaimSpace(this.userName));
            MessageElement[] userList = userResp.get_any();
            return true;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)"SharePoint: Got a service exception checking connection", (Throwable)e);
            }
            throw new ManifoldCFException("Service exception: " + e.getMessage(), (Throwable)e);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        throw new ManifoldCFException("The site at " + this.baseUrl + site + " did not exist");
                    }
                    if (httpErrorCode.equals("401")) {
                        throw new ManifoldCFException("User did not authenticate properly, or has insufficient permissions to access " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                    String errorString = "";
                    if (elem != null) {
                        errorString = elem2.getFirstChild().getNodeValue().trim();
                    }
                    throw new ManifoldCFException("Accessing site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString, (Throwable)e);
                }
                throw new ManifoldCFException("Unknown SharePoint server error accessing site " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            throw new ManifoldCFException("Got an unknown remote exception accessing site " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Got an unexpected remote exception accessing site " + site + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected String mapToClaimSpace(String userLoginName) {
        if (this.isClaimSpace) {
            return "i:0#.w|" + userLoginName.toLowerCase(Locale.ROOT);
        }
        return userLoginName;
    }

    protected static class ResourceProvider
    implements WSDDEngineConfiguration {
        private WSDDDeployment deployment = null;
        private Class resourceClass;
        private String resourceName;

        public ResourceProvider(Class resourceClass, String resourceName) {
            this.resourceClass = resourceClass;
            this.resourceName = resourceName;
        }

        public WSDDDeployment getDeployment() {
            return this.deployment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureEngine(AxisEngine engine) throws ConfigurationException {
            try {
                InputStream resourceStream = this.resourceClass.getResourceAsStream(this.resourceName);
                if (resourceStream == null) {
                    throw new ConfigurationException("Resource not found: '" + this.resourceName + "'");
                }
                try {
                    WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument((InputStream)resourceStream));
                    this.deployment = doc.getDeployment();
                    this.deployment.configureEngine(engine);
                    engine.refreshGlobalOptions();
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }

        public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
        }

        public Handler getHandler(QName qname) throws ConfigurationException {
            return this.deployment.getHandler(qname);
        }

        public SOAPService getService(QName qname) throws ConfigurationException {
            SOAPService service = this.deployment.getService(qname);
            if (service == null) {
                throw new ConfigurationException(Messages.getMessage((String)"noService10", (String)qname.toString()));
            }
            return service;
        }

        public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
            return this.deployment.getServiceByNamespaceURI(namespace);
        }

        public Handler getTransport(QName qname) throws ConfigurationException {
            return this.deployment.getTransport(qname);
        }

        public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
            return this.deployment.getTypeMappingRegistry();
        }

        public Handler getGlobalRequest() throws ConfigurationException {
            return this.deployment.getGlobalRequest();
        }

        public Handler getGlobalResponse() throws ConfigurationException {
            return this.deployment.getGlobalResponse();
        }

        public Hashtable getGlobalOptions() throws ConfigurationException {
            WSDDGlobalConfiguration globalConfig = this.deployment.getGlobalConfiguration();
            if (globalConfig != null) {
                return globalConfig.getParametersTable();
            }
            return null;
        }

        public Iterator getDeployedServices() throws ConfigurationException {
            return this.deployment.getDeployedServices();
        }

        public List getRoles() {
            return this.deployment.getRoles();
        }
    }

    protected static class UserGroupWS
    extends UserGroupLocator {
        private static final long serialVersionUID = -2052484076803624502L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public UserGroupWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/usergroup.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public UserGroupSoap getUserGroupSoapHandler() throws ServiceException, AxisFault {
            UserGroupSoapStub _stub = new UserGroupSoapStub(this.endPoint, this);
            _stub.setPortName(this.getUserGroupSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }
}

