/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.mappers.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.manifoldcf.authorities.mappers.BaseMappingConnector;
import org.apache.manifoldcf.authorities.mappers.ldap.LDAPProtocolEnum;
import org.apache.manifoldcf.authorities.mappers.ldap.Messages;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.common.LDAPSSLSocketFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ISSLSocketFactoryProducer;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class LDAPMapper
extends BaseMappingConnector {
    public static final String _rcsid = "@(#)$Id$";
    private LdapContext session = null;
    private StartTlsResponse tls = null;
    private long sessionExpirationTime = -1L;
    private String bindUser;
    private String bindPass;
    private String serverProtocol;
    private String serverName;
    private String serverPort;
    private String serverBase;
    private String userBase;
    private String userSearch;
    private String ldapUserNameReplace;
    private String ldapAttributeCondition;
    private String ldapAttributeRegexpCondition;
    private Pattern ldapAttributeRegexpConditionPattern;
    private String ldapUserNameReplaceTrue;
    private List<String> forcedTokens;
    private String userNameAttr;
    private String sslKeystoreData;
    private IKeystoreManager sslKeystore;
    private final long responseLifetime = 60000L;
    private final int LRUsize = 1000;

    public String check() throws ManifoldCFException {
        this.disconnectSession();
        this.getSession();
        return super.check();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() > this.sessionExpirationTime) {
            this.disconnectSession();
        }
        super.poll();
    }

    protected void disconnectSession() {
        if (this.session != null) {
            try {
                if (this.tls != null) {
                    this.tls.close();
                }
                this.session.close();
            }
            catch (NamingException namingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.tls = null;
            this.session = null;
            this.sessionExpirationTime = -1L;
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.disconnectSession();
        super.disconnect();
        this.serverName = null;
        this.serverPort = null;
        this.serverBase = null;
        this.userBase = null;
        this.userSearch = null;
        this.userNameAttr = null;
        this.ldapUserNameReplace = null;
        this.ldapAttributeCondition = null;
        this.ldapAttributeRegexpCondition = null;
        this.ldapAttributeRegexpConditionPattern = null;
        this.ldapUserNameReplaceTrue = null;
        this.forcedTokens = null;
        this.sslKeystoreData = null;
        this.sslKeystore = null;
    }

    private LDAPProtocolEnum retrieveLDAPProtocol() {
        LDAPProtocolEnum ldapProtocol;
        if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
            return LDAPProtocolEnum.LDAP;
        }
        switch (this.serverProtocol.toUpperCase(Locale.ENGLISH)) {
            case "LDAP": {
                ldapProtocol = LDAPProtocolEnum.LDAP;
                break;
            }
            case "LDAPS": {
                ldapProtocol = LDAPProtocolEnum.LDAPS;
                break;
            }
            case "LDAP+TLS": {
                ldapProtocol = LDAPProtocolEnum.LDAP_TLS;
                break;
            }
            case "LDAPS+TLS": {
                ldapProtocol = LDAPProtocolEnum.LDAPS_TLS;
                break;
            }
            default: {
                ldapProtocol = LDAPProtocolEnum.LDAP;
            }
        }
        return ldapProtocol;
    }

    private boolean isLDAPTLS(LDAPProtocolEnum ldapProtocol) {
        return LDAPProtocolEnum.LDAP_TLS.equals((Object)ldapProtocol) || LDAPProtocolEnum.LDAPS_TLS.equals((Object)ldapProtocol);
    }

    private boolean isLDAPS(LDAPProtocolEnum ldapProtocol) {
        return LDAPProtocolEnum.LDAPS.equals((Object)ldapProtocol) || LDAPProtocolEnum.LDAPS_TLS.equals((Object)ldapProtocol);
    }

    private String printLdapContextEnvironment(Hashtable env) {
        Hashtable<String, String> copyEnv = new Hashtable<String, String>(env);
        if (copyEnv.containsKey("java.naming.security.credentials")) {
            copyEnv.put("java.naming.security.credentials", "********");
        }
        return Arrays.toString(copyEnv.entrySet().toArray());
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.bindUser = configParams.getParameter("ldapBindUser");
        this.bindPass = configParams.getObfuscatedParameter("ldapBindPass");
        this.serverProtocol = configParams.getParameter("ldapProtocol");
        this.serverName = configParams.getParameter("ldapServerName");
        this.serverPort = configParams.getParameter("ldapServerPort");
        this.serverBase = configParams.getParameter("ldapServerBase");
        this.sslKeystoreData = configParams.getParameter("sslKeystore");
        this.userBase = configParams.getParameter("ldapUserBase");
        this.userSearch = configParams.getParameter("ldapUserSearch");
        this.userNameAttr = configParams.getParameter("ldapUserNameAttr");
        this.ldapAttributeCondition = configParams.getParameter("ldapAttributeCondition");
        this.ldapAttributeRegexpCondition = configParams.getParameter("ldapAttributeRegexpCondition");
        this.ldapUserNameReplaceTrue = configParams.getParameter("ldapUserNameReplaceTrue");
        this.ldapUserNameReplace = configParams.getParameter("ldapUserNameReplace");
        if (this.ldapAttributeCondition != null) {
            this.ldapAttributeRegexpConditionPattern = Pattern.compile(this.ldapAttributeRegexpCondition);
        }
        this.forcedTokens = new ArrayList<String>();
        int i = 0;
        while (i < configParams.getChildCount()) {
            ConfigNode sn;
            if (!(sn = configParams.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            this.forcedTokens.add(token);
        }
    }

    protected LdapContext getSession() throws ManifoldCFException {
        try {
            LDAPProtocolEnum ldapProtocol = this.retrieveLDAPProtocol();
            if (this.session == null) {
                if (this.serverName == null || this.serverName.length() == 0) {
                    Logging.mappingConnectors.error((Object)"Server name parameter missing but required");
                    throw new ManifoldCFException("Server name parameter missing but required");
                }
                if (this.serverPort == null || this.serverPort.length() == 0) {
                    Logging.mappingConnectors.error((Object)"Server port parameter missing but required");
                    throw new ManifoldCFException("Server port parameter missing but required");
                }
                if (this.serverBase == null) {
                    Logging.mappingConnectors.error((Object)"Server base parameter missing but required");
                    throw new ManifoldCFException("Server base parameter missing but required");
                }
                if (this.userBase == null) {
                    Logging.mappingConnectors.error((Object)"User base parameter missing but required");
                    throw new ManifoldCFException("User base parameter missing but required");
                }
                if (this.userSearch == null || this.userSearch.length() == 0) {
                    Logging.mappingConnectors.error((Object)"User search expression missing but required");
                    throw new ManifoldCFException("User search expression missing but required");
                }
                if (this.ldapUserNameReplace == null || this.ldapUserNameReplace.length() == 0) {
                    Logging.mappingConnectors.error((Object)"User name replace attribute missing but required");
                    throw new ManifoldCFException("User name replace attribute missing but required");
                }
                if (this.userNameAttr == null || this.userNameAttr.length() == 0) {
                    Logging.mappingConnectors.error((Object)"User name attribute missing but required");
                    throw new ManifoldCFException("User name attribute missing but required");
                }
                this.sslKeystore = this.sslKeystoreData != null ? KeystoreManagerFactory.make((String)"", (String)this.sslKeystoreData) : KeystoreManagerFactory.make((String)"");
                Hashtable<String, Object> env = new Hashtable<String, Object>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + this.serverName + ":" + this.serverPort + "/" + this.serverBase);
                if (LDAPProtocolEnum.LDAPS.equals((Object)ldapProtocol)) {
                    LDAPSSLSocketFactory.setSocketFactoryProducer((ISSLSocketFactoryProducer)this.sslKeystore);
                    env.put("java.naming.security.protocol", "ssl");
                    env.put("java.naming.ldap.factory.socket", "org.apache.manifoldcf.core.common.LDAPSSLSocketFactory");
                }
                if (this.bindUser != null && !this.bindUser.isEmpty()) {
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.security.principal", this.bindUser);
                    env.put("java.naming.security.credentials", this.bindPass);
                }
                Logging.mappingConnectors.info((Object)("LDAP Context environment properties: " + this.printLdapContextEnvironment(env)));
                this.session = new InitialLdapContext(env, null);
                if (this.isLDAPTLS(ldapProtocol)) {
                    StartTlsResponse tls = (StartTlsResponse)this.session.extendedOperation(new StartTlsRequest());
                    tls.negotiate(this.sslKeystore.getSecureSocketFactory());
                }
            } else {
                if (this.isLDAPS(ldapProtocol)) {
                    LDAPSSLSocketFactory.setSocketFactoryProducer((ISSLSocketFactoryProducer)this.sslKeystore);
                }
                this.session.reconnect(null);
            }
            this.sessionExpirationTime = System.currentTimeMillis() + 300000L;
            return this.session;
        }
        catch (AuthenticationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.mappingConnectors.error((Object)("Authentication error: " + e.getMessage() + ", explanation: " + e.getExplanation()), (Throwable)e);
            throw new ManifoldCFException("Authentication error: " + e.getMessage() + ", explanation: " + e.getExplanation(), (Throwable)e);
        }
        catch (CommunicationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.mappingConnectors.error((Object)("Communication error: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Communication error: " + e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.mappingConnectors.error((Object)("Naming exception: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Naming exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.mappingConnectors.error((Object)("Interrupted IO error: " + e.getMessage()));
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.mappingConnectors.error((Object)("IO error: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected SearchResult getUserEntry(LdapContext ctx, String userName) throws ManifoldCFException {
        String searchFilter = this.userSearch.replaceAll("\\{0\\}", LDAPMapper.escapeDN(userName));
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String[] attrIds = new String[4];
        attrIds[0] = this.userNameAttr;
        attrIds[1] = this.ldapUserNameReplace;
        if (this.ldapAttributeCondition != null && this.ldapAttributeCondition.length() > 0) {
            attrIds[2] = this.ldapAttributeCondition;
            attrIds[3] = this.ldapUserNameReplaceTrue;
        }
        searchCtls.setReturningAttributes(attrIds);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(this.userBase, searchFilter, searchCtls);
            if (answer.hasMoreElements()) {
                return answer.next();
            }
            return null;
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public static String escapeDN(String name) {
        StringBuilder sb = new StringBuilder();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public String mapUser(String userName) throws ManifoldCFException {
        LdapContext lcontext = this.getSession();
        try {
            SearchResult answer;
            String searchFilter = this.userSearch.replaceAll("\\{0\\}", LDAPMapper.escapeDN(userName));
            if (Logging.mappingConnectors.isDebugEnabled()) {
                Logging.mappingConnectors.debug((Object)("SearchFilter=" + searchFilter));
            }
            if ((answer = this.getUserEntry(lcontext, userName)) != null) {
                Attribute attrCondition;
                if (Logging.mappingConnectors.isDebugEnabled()) {
                    Logging.mappingConnectors.debug((Object)("Found answer=" + answer.toString()));
                }
                Attributes attrs = answer.getAttributes();
                String outputUserName = null;
                Attribute attrReplace = null;
                attrReplace = attrs.get(this.ldapUserNameReplace);
                if (this.ldapAttributeCondition != null && this.ldapAttributeCondition.length() > 0 && (attrCondition = attrs.get(this.ldapAttributeCondition)) != null) {
                    String valueCondition = (String)attrCondition.get(0);
                    Matcher matcher = this.ldapAttributeRegexpConditionPattern.matcher(valueCondition);
                    if (matcher.find()) {
                        attrReplace = attrs.get(this.ldapUserNameReplaceTrue);
                        if (Logging.mappingConnectors.isDebugEnabled()) {
                            Logging.mappingConnectors.debug((Object)"LDAPMapper: condition matches");
                        }
                    } else if (Logging.mappingConnectors.isDebugEnabled()) {
                        Logging.mappingConnectors.debug((Object)"LDAPMapper: condition not matches");
                    }
                }
                outputUserName = (String)attrReplace.get(0);
                if (Logging.mappingConnectors.isDebugEnabled()) {
                    Logging.mappingConnectors.debug((Object)("LDAPMapper: Input user name '" + userName + "'; output user name '" + outputUserName + "'"));
                }
                return outputUserName;
            }
            if (Logging.mappingConnectors.isDebugEnabled()) {
                Logging.mappingConnectors.debug((Object)("No Found answer for userName =" + userName));
            }
            return userName;
        }
        catch (Exception e) {
            Logging.mappingConnectors.error((Object)("replace error for user : '" + userName + "' error :" + e.getMessage()));
            throw new ManifoldCFException("replace error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LDAP.LDAPMapperTab"));
        Logging.mappingConnectors.info((Object)("LDAP.LDAPMapperTab=" + Messages.getString(locale, "LDAP.LDAPMapperTab")));
        tabsArray.add(Messages.getString(locale, "LDAP.ForcedTokens"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        LDAPMapper.fillInLDAPTab(paramMap, out, parameters);
        LDAPMapper.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "configuration.css", paramMap);
    }

    private static String getParam(ConfigParams parameters, String name, String def) {
        String rval = parameters.getParameter(name);
        return rval != null ? rval : def;
    }

    protected static void fillInForcedTokensTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        ArrayList<String> forcedTokenList = new ArrayList<String>();
        for (int i = 0; i < parameters.getChildCount(); ++i) {
            ConfigNode sn = parameters.getChild(i);
            if (!sn.getType().equals("access")) continue;
            forcedTokenList.add(sn.getAttributeValue("token"));
        }
        velocityContext.put("FORCEDTOKENS", forcedTokenList);
    }

    protected static void fillInLDAPTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        velocityContext.put("FSERVERPROTOCOL", LDAPMapper.getParam(parameters, "ldapProtocol", "ldap"));
        velocityContext.put("FSERVERNAME", LDAPMapper.getParam(parameters, "ldapServerName", ""));
        velocityContext.put("FSERVERPORT", LDAPMapper.getParam(parameters, "ldapServerPort", "389"));
        velocityContext.put("FSERVERBASE", LDAPMapper.getParam(parameters, "ldapServerBase", ""));
        String sslKeystoreData = parameters.getParameter("sslkeystore");
        if (sslKeystoreData != null) {
            velocityContext.put("SSLKEYSTOREDATA", sslKeystoreData);
        }
        velocityContext.put("FUSERBASE", LDAPMapper.getParam(parameters, "ldapUserBase", "ou=People"));
        velocityContext.put("FUSERSEARCH", LDAPMapper.getParam(parameters, "ldapUserSearch", "(&(objectClass=inetOrgPerson)(mail={0}))"));
        velocityContext.put("FUSERNAMEATTR", LDAPMapper.getParam(parameters, "ldapUserNameAttr", "mail"));
        velocityContext.put("FUSERNAMEREPLACE", LDAPMapper.getParam(parameters, "ldapUserNameReplace", "cn"));
        velocityContext.put("ATTRIBUTECONDITION", LDAPMapper.getParam(parameters, "ldapAttributeCondition", "displayName"));
        velocityContext.put("ATTRIBUTEREGEXPCONDITION", LDAPMapper.getParam(parameters, "ldapAttributeRegexpCondition", "^a.*$"));
        velocityContext.put("FUSERNAMETRUEREPLACE", LDAPMapper.getParam(parameters, "ldapUserNameReplaceTrue", "givenName"));
        velocityContext.put("FBINDUSER", LDAPMapper.getParam(parameters, "ldapBindUser", ""));
        String fBindPass = parameters.getObfuscatedParameter("ldapBindPass");
        fBindPass = fBindPass == null ? "" : out.mapPasswordToKey(fBindPass);
        velocityContext.put("FBINDPASS", fBindPass);
        HashMap<String, String> sslCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localSslKeystore = sslKeystoreData == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)sslKeystoreData);
            String[] contents = localSslKeystore.getContents();
            if (contents.length > 0) {
                sslCertificatesMap = new HashMap<String, String>();
                for (String alias : contents) {
                    Object description = localSslKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    sslCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.mappingConnectors.warn((Object)e);
        }
        if (sslCertificatesMap != null) {
            velocityContext.put("SSLCERTIFICATESMAP", sslCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        LDAPMapper.fillInLDAPTab(paramMap, out, parameters);
        LDAPMapper.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_LDAP.html", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_ForcedTokens.html", paramMap);
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            return false;
        }
        parameters.setParameter(name, val);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String xc;
        this.copyParam(variableContext, parameters, "ldapProtocol");
        this.copyParam(variableContext, parameters, "ldapServerName");
        this.copyParam(variableContext, parameters, "ldapServerPort");
        this.copyParam(variableContext, parameters, "ldapServerBase");
        this.copyParam(variableContext, parameters, "ldapUserBase");
        this.copyParam(variableContext, parameters, "ldapUserSearch");
        this.copyParam(variableContext, parameters, "ldapUserNameAttr");
        this.copyParam(variableContext, parameters, "ldapUserNameReplace");
        this.copyParam(variableContext, parameters, "ldapAttributeCondition");
        this.copyParam(variableContext, parameters, "ldapAttributeRegexpCondition");
        this.copyParam(variableContext, parameters, "ldapUserNameReplaceTrue");
        this.copyParam(variableContext, parameters, "ldapBindUser");
        String bindPass = variableContext.getParameter("ldapBindPass");
        if (bindPass != null) {
            parameters.setObfuscatedParameter("ldapBindPass", variableContext.mapKeyToPassword(bindPass));
        }
        if ((xc = variableContext.getParameter("tokencount")) != null) {
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode sn = parameters.getChild(i);
                if (sn.getType().equals("access")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = "accessop" + accessDescription;
                String command = variableContext.getParameter(accessOpName);
                if (command != null && command.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessSpec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessspec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        String sslKeystoreValue = variableContext.getParameter("sslkeystoredata");
        String sslConfigOp = variableContext.getParameter("sslconfigop");
        if (sslConfigOp != null) {
            String alias;
            if (sslConfigOp.equals("Delete")) {
                alias = variableContext.getParameter("sslkeystorealias");
                IKeystoreManager mgr = sslKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)sslKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                sslKeystoreValue = mgr.getString();
            } else if (sslConfigOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("sslcertificate");
                IKeystoreManager mgr = sslKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)sslKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                sslKeystoreValue = mgr.getString();
            }
        }
        if (sslKeystoreValue != null) {
            parameters.setParameter("sslkeystore", sslKeystoreValue);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        LDAPMapper.fillInLDAPTab(paramMap, out, parameters);
        LDAPMapper.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "configuration.css", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html", paramMap);
    }
}

