/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.processing.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sis.internal.feature.j2d.PathBuilder;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class IsolineTracer {
    static final int UPPER_LEFT = 1;
    static final int UPPER_RIGHT = 2;
    static final int LOWER_LEFT = 4;
    static final int LOWER_RIGHT = 8;
    private final double[] window;
    private final int pixelStride;
    int x;
    int y;
    private final double translateX;
    private final double translateY;
    private final MathTransform gridToCRS;

    IsolineTracer(double[] dArray, int n, Rectangle rectangle, MathTransform mathTransform) {
        this.window = dArray;
        this.pixelStride = n;
        this.translateX = rectangle.x;
        this.translateY = rectangle.y;
        this.gridToCRS = mathTransform;
    }

    private Joiner writeTo(Joiner joiner, Polyline[] polylineArray, boolean bl) throws TransformException {
        for (int i = 0; i < polylineArray.length; ++i) {
            Polyline polyline = polylineArray[i];
            if (polyline == null) continue;
            int n = polyline.size;
            if (n == 0) {
                assert (polyline.isEmpty());
                continue;
            }
            if (joiner == null) {
                joiner = new Joiner(this.gridToCRS);
            }
            joiner.append(polyline.coordinates, n, (i & 1) == 0);
            polyline.clear();
        }
        if (joiner != null) {
            joiner.createPolyline(bl);
        }
        return joiner;
    }

    private static final class Joiner
    extends PathBuilder {
        private final MathTransform gridToCRS;

        Joiner(MathTransform mathTransform) {
            this.gridToCRS = mathTransform;
        }

        @Override
        protected int filterChunk(double[] dArray, int n, int n2) {
            int n3;
            double d;
            int n4 = n;
            int n5 = n;
            if (n5 < n2) {
                double d2 = dArray[n5++];
                d = dArray[n5++];
                int n6 = 3;
                while (n5 < n2) {
                    int n7 = n6;
                    if (dArray[n5++] != d2) {
                        n6 &= 0xFFFFFFFE;
                    }
                    if (dArray[n5++] != d) {
                        n6 &= 0xFFFFFFFD;
                    }
                    if (n6 != 0) continue;
                    n6 = n7;
                    n5 -= 2;
                    break;
                }
                while (n4 > 0) {
                    if (dArray[--n4] != d) {
                        n6 &= 0xFFFFFFFD;
                    }
                    if (dArray[--n4] != d2) {
                        n6 &= 0xFFFFFFFE;
                    }
                    if (n6 != 0) continue;
                    n4 += 2;
                    break;
                }
            }
            int n8 = n5;
            while ((n3 = n4 + 4) < n8) {
                d = dArray[n4++];
                double d3 = dArray[n4++];
                n5 = n8;
                do {
                    if (dArray[n5 - 2] != d || dArray[n5 - 1] != d3) continue;
                    System.arraycopy(dArray, n5, dArray, n4, n2 - n5);
                    return n2 - (n5 - n4);
                } while ((n5 -= 2) > n3);
            }
            return n2;
        }

        @Override
        protected int filterFull(double[] dArray, int n) throws TransformException {
            if (this.gridToCRS != null) {
                this.gridToCRS.transform(dArray, 0, dArray, 0, n / 2);
            }
            return n;
        }
    }

    private static final class Polyline {
        static final int DIMENSION = 2;
        double[] coordinates;
        int size;
        Polyline opposite;

        Polyline() {
            this.coordinates = ArraysExt.EMPTY_DOUBLE;
        }

        Polyline(double[] dArray) {
            this.coordinates = dArray;
            this.size = dArray.length;
        }

        final void clear() {
            this.opposite = null;
            this.size = 0;
        }

        final boolean isEmpty() {
            return this.size == 0 & this.opposite == null;
        }

        final Polyline attach(Polyline polyline) {
            assert (this.opposite == null & polyline.opposite == null);
            polyline.opposite = this;
            this.opposite = polyline;
            return this;
        }

        final Polyline transferFrom(Polyline polyline) {
            assert (this.isEmpty());
            double[] dArray = this.coordinates;
            this.coordinates = polyline.coordinates;
            this.size = polyline.size;
            this.opposite = polyline.opposite;
            if (this.opposite != null) {
                this.opposite.opposite = this;
            }
            polyline.clear();
            polyline.coordinates = dArray;
            return this;
        }

        final boolean transferToOpposite() {
            if (this.opposite == null) {
                return false;
            }
            int n = this.size + this.opposite.size;
            double[] dArray = this.opposite.coordinates;
            if (n > dArray.length) {
                dArray = new double[n];
            }
            System.arraycopy(this.opposite.coordinates, 0, dArray, this.size, this.opposite.size);
            int n2 = 0;
            int n3 = this.size;
            while ((n3 -= 2) >= 0) {
                dArray[n3] = this.coordinates[n2++];
                dArray[n3 + 1] = this.coordinates[n2++];
            }
            this.opposite.size = n;
            this.opposite.coordinates = dArray;
            this.opposite.opposite = null;
            this.clear();
            return true;
        }

        final void append(double d, double d2) {
            if (this.size >= this.coordinates.length) {
                this.coordinates = Arrays.copyOf(this.coordinates, Math.max(Math.multiplyExact(this.size, 2), 32));
            }
            this.coordinates[this.size++] = d;
            this.coordinates[this.size++] = d2;
        }

        public String toString() {
            return PathBuilder.toString(this.coordinates, this.size);
        }
    }

    private static final class Unclosed
    extends ArrayList<double[]> {
        private Point firstPoint;
        private Point lastPoint;

        Unclosed(Polyline polyline, Polyline polyline2) {
            Polyline polyline3;
            int n = 0;
            do {
                int n2;
                Polyline polyline4 = polyline3 = (n & 2) == 0 ? polyline : polyline2;
                if (n % 3 == 0 && polyline3 != null) {
                    polyline3 = polyline3.opposite;
                }
                if (polyline3 != null && (n2 = polyline3.size) != 0) {
                    boolean bl;
                    double d;
                    double d2;
                    double[] dArray = polyline3.coordinates;
                    if ((n & 1) == 0) {
                        d2 = dArray[--n2];
                        d = dArray[--n2];
                    } else {
                        d = dArray[0];
                        d2 = dArray[1];
                    }
                    boolean bl2 = bl = n >= 6;
                    if (Double.isFinite(d) && Double.isFinite(d2)) {
                        Point point = new Point((int)d, (int)d2);
                        if (d != Math.floor(d)) {
                            point.x ^= 0xFFFFFFFF;
                        }
                        if (d2 != Math.floor(d2)) {
                            point.y ^= 0xFFFFFFFF;
                        }
                        if (bl) {
                            this.lastPoint = point;
                            break;
                        }
                        this.firstPoint = point;
                    } else if (bl) {
                        if (this.firstPoint != null) break;
                        return;
                    }
                    n = 6;
                    continue;
                }
                if (++n != 4) continue;
                return;
            } while (n <= 9);
            this.take(polyline.opposite);
            this.take(polyline);
            if (polyline2 != null) {
                polyline3 = polyline2.opposite;
                this.take(polyline2);
                this.take(polyline3);
            }
        }

        private void take(Polyline polyline) {
            if (polyline != null && polyline.size != 0) {
                this.add(Arrays.copyOf(polyline.coordinates, polyline.size));
                polyline.clear();
            } else {
                this.add(null);
            }
        }

        final boolean isExtremity(Point point) {
            return point.equals(this.firstPoint) || point.equals(this.lastPoint);
        }

        final boolean addOrMerge(Map<Point, Unclosed> map) {
            Unclosed unclosed = map.remove(this.firstPoint);
            Unclosed unclosed2 = map.remove(this.lastPoint);
            if (unclosed != null) {
                map.remove(this.addAll(unclosed, true));
            }
            if (unclosed2 != null) {
                map.remove(this.addAll(unclosed2, false));
            }
            if (this.firstPoint != null && this.firstPoint.equals(this.lastPoint)) {
                map.remove(this.firstPoint);
                map.remove(this.lastPoint);
                return true;
            }
            if (this.firstPoint != null) {
                map.put(this.firstPoint, this);
            }
            if (this.lastPoint != null) {
                map.put(this.lastPoint, this);
            }
            return false;
        }

        private Point addAll(Unclosed unclosed, boolean bl) {
            int n;
            assert (((this.size() | unclosed.size()) & 1) == 0);
            if (this.lastPoint != null && this.lastPoint.equals(unclosed.firstPoint)) {
                n = 0;
            } else if (this.firstPoint != null && this.firstPoint.equals(unclosed.firstPoint)) {
                n = 1;
            } else if (this.lastPoint != null && this.lastPoint.equals(unclosed.lastPoint)) {
                n = 2;
            } else if (this.firstPoint != null && this.firstPoint.equals(unclosed.lastPoint)) {
                n = 3;
            } else {
                throw new AssertionError();
            }
            if (bl) {
                n ^= 3;
            }
            if ((n & 1) != 0) {
                this.reverse();
            }
            if ((n & 2) != 0) {
                unclosed.reverse();
            }
            if (bl) {
                this.addAll(0, unclosed);
                this.firstPoint = unclosed.firstPoint;
                return unclosed.lastPoint;
            }
            this.addAll(unclosed);
            this.lastPoint = unclosed.lastPoint;
            return unclosed.firstPoint;
        }

        private void reverse() {
            Collections.reverse(this);
            Point point = this.firstPoint;
            this.firstPoint = this.lastPoint;
            this.lastPoint = point;
        }

        final Polyline[] toPolylines() {
            Polyline[] polylineArray = new Polyline[this.size()];
            for (int i = 0; i < polylineArray.length; ++i) {
                double[] dArray = (double[])this.get(i);
                if (dArray == null) continue;
                polylineArray[i] = new Polyline(dArray);
            }
            return polylineArray;
        }
    }

    final class Level {
        private final int band;
        final double value;
        int isDataAbove;
        private final Polyline polylineOnLeft;
        private final Polyline[] polylinesOnTop;
        private final Map<Point, Unclosed> partialPaths;
        private Joiner path;
        Shape shape;

        Level(int n, double d, int n2) {
            this.band = n;
            this.value = d;
            this.partialPaths = new HashMap<Point, Unclosed>();
            this.polylineOnLeft = new Polyline();
            this.polylinesOnTop = new Polyline[n2];
            for (int i = 0; i < n2; ++i) {
                this.polylinesOnTop[i] = new Polyline();
            }
        }

        final void nextColumn() {
            this.isDataAbove = (this.isDataAbove & 0xA) >>> 1;
        }

        final void interpolate() throws TransformException {
            switch (this.isDataAbove) {
                default: {
                    throw new AssertionError(this.isDataAbove);
                }
                case 0: 
                case 15: {
                    assert (this.polylinesOnTop[IsolineTracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    break;
                }
                case 3: 
                case 12: {
                    assert (this.polylinesOnTop[IsolineTracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnRightSide();
                    break;
                }
                case 5: 
                case 10: {
                    assert (this.polylineOnLeft.isEmpty());
                    Polyline polyline = this.polylinesOnTop[IsolineTracer.this.x];
                    this.interpolateMissingTopSide(polyline);
                    this.interpolateOnBottomSide(polyline);
                    break;
                }
                case 4: 
                case 11: {
                    assert (this.polylinesOnTop[IsolineTracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[IsolineTracer.this.x].transferFrom(this.polylineOnLeft));
                    break;
                }
                case 2: 
                case 13: {
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(this.polylinesOnTop[IsolineTracer.this.x]));
                    this.interpolateOnRightSide();
                    break;
                }
                case 7: 
                case 8: {
                    assert (this.polylinesOnTop[IsolineTracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateOnRightSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[IsolineTracer.this.x].attach(this.polylineOnLeft));
                    break;
                }
                case 1: 
                case 14: {
                    this.closeLeftWithTop(this.polylinesOnTop[IsolineTracer.this.x]);
                    break;
                }
                case 6: 
                case 9: {
                    double d = 0.0;
                    double[] dArray = IsolineTracer.this.window;
                    int n = this.band;
                    do {
                        d += dArray[n];
                    } while ((n += IsolineTracer.this.pixelStride) < dArray.length);
                    assert ((n -= this.band) == IsolineTracer.this.pixelStride * 4) : n;
                    boolean bl = this.isDataAbove == 6;
                    boolean bl2 = (d /= 4.0) <= this.value;
                    Polyline polyline = this.polylinesOnTop[IsolineTracer.this.x];
                    if (bl ^= bl2) {
                        this.closeLeftWithTop(polyline);
                        this.interpolateOnRightSide();
                        this.interpolateOnBottomSide(polyline.attach(this.polylineOnLeft));
                        break;
                    }
                    this.interpolateMissingLeftSide();
                    Polyline polyline2 = new Polyline().transferFrom(polyline);
                    this.interpolateOnBottomSide(polyline.transferFrom(this.polylineOnLeft));
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(polyline2));
                    this.interpolateOnRightSide();
                    break;
                }
            }
        }

        private void interpolateMissingLeftSide() {
            if (this.polylineOnLeft.size == 0) {
                this.polylineOnLeft.append(IsolineTracer.this.translateX + (double)IsolineTracer.this.x, IsolineTracer.this.translateY + ((double)IsolineTracer.this.y + this.interpolate(0, 2 * IsolineTracer.this.pixelStride)));
            }
        }

        private void interpolateMissingTopSide(Polyline polyline) {
            if (polyline.size == 0) {
                this.interpolateOnTopSide(polyline);
            }
        }

        private void interpolateOnTopSide(Polyline polyline) {
            polyline.append(IsolineTracer.this.translateX + ((double)IsolineTracer.this.x + this.interpolate(0, IsolineTracer.this.pixelStride)), IsolineTracer.this.translateY + (double)IsolineTracer.this.y);
        }

        private void interpolateOnRightSide() {
            this.polylineOnLeft.append(IsolineTracer.this.translateX + (double)(IsolineTracer.this.x + 1), IsolineTracer.this.translateY + ((double)IsolineTracer.this.y + this.interpolate(IsolineTracer.this.pixelStride, 3 * IsolineTracer.this.pixelStride)));
        }

        private void interpolateOnBottomSide(Polyline polyline) {
            polyline.append(IsolineTracer.this.translateX + ((double)IsolineTracer.this.x + this.interpolate(2 * IsolineTracer.this.pixelStride, 3 * IsolineTracer.this.pixelStride)), IsolineTracer.this.translateY + (double)(IsolineTracer.this.y + 1));
        }

        private double interpolate(int n, int n2) {
            double[] dArray = IsolineTracer.this.window;
            int n3 = this.band;
            double d = dArray[n3 + n];
            double d2 = dArray[n3 + n2];
            return (this.value - d) / (d2 - d);
        }

        private void closeLeftWithTop(Polyline polyline) throws TransformException {
            Polyline[] polylineArray;
            this.interpolateMissingLeftSide();
            this.interpolateMissingTopSide(polyline);
            if (this.polylineOnLeft.opposite == polyline) {
                assert (polyline.opposite == this.polylineOnLeft);
                polylineArray = new Polyline[]{polyline, this.polylineOnLeft};
            } else {
                Unclosed unclosed = new Unclosed(this.polylineOnLeft, polyline);
                if (unclosed.isEmpty()) {
                    polylineArray = new Polyline[]{this.polylineOnLeft.opposite, this.polylineOnLeft, polyline, polyline.opposite};
                } else if (unclosed.addOrMerge(this.partialPaths)) {
                    polylineArray = unclosed.toPolylines();
                } else {
                    return;
                }
            }
            this.path = IsolineTracer.this.writeTo(this.path, polylineArray, true);
        }

        private void writeUnclosed(Polyline polyline) throws TransformException {
            Polyline[] polylineArray;
            boolean bl;
            Unclosed unclosed = new Unclosed(polyline, null);
            if (unclosed.isEmpty()) {
                bl = false;
                polylineArray = new Polyline[]{polyline.opposite, polyline};
            } else {
                bl = unclosed.addOrMerge(this.partialPaths);
                if (!bl) {
                    return;
                }
                polylineArray = unclosed.toPolylines();
            }
            this.path = IsolineTracer.this.writeTo(this.path, polylineArray, bl);
        }

        final void finishedRow() throws TransformException {
            if (!this.polylineOnLeft.transferToOpposite()) {
                this.writeUnclosed(this.polylineOnLeft);
            }
            this.isDataAbove = 0;
        }

        final void finish() throws TransformException {
            assert (this.polylineOnLeft.isEmpty());
            this.polylineOnLeft.coordinates = null;
            for (int i = 0; i < this.polylinesOnTop.length; ++i) {
                this.writeUnclosed(this.polylinesOnTop[i]);
                this.polylinesOnTop[i] = null;
            }
            assert (this.isConsistent());
        }

        private boolean isConsistent() {
            for (Map.Entry<Point, Unclosed> entry : this.partialPaths.entrySet()) {
                if (entry.getValue().isExtremity(entry.getKey())) continue;
                return false;
            }
            return true;
        }

        final void merge(Level level) throws TransformException {
            assert (level != this && level.value == this.value);
            if (this.path == null) {
                this.path = level.path;
            } else {
                this.path.append(level.path);
            }
            level.path = null;
            assert (this.isConsistent());
            assert (level.isConsistent());
            IdentityHashMap<Unclosed, Boolean> identityHashMap = new IdentityHashMap<Unclosed, Boolean>(level.partialPaths.size() / 2);
            for (Map.Entry<Point, Unclosed> entry : level.partialPaths.entrySet()) {
                Unclosed unclosed = entry.getValue();
                if (identityHashMap.put(unclosed, Boolean.TRUE) == null) {
                    assert (unclosed.isExtremity(entry.getKey()));
                    if (unclosed.addOrMerge(this.partialPaths)) {
                        this.path = IsolineTracer.this.writeTo(this.path, unclosed.toPolylines(), true);
                        unclosed.clear();
                    }
                }
                entry.setValue(null);
            }
        }

        final void flush() throws TransformException {
            for (Map.Entry<Point, Unclosed> entry : this.partialPaths.entrySet()) {
                Unclosed unclosed = entry.getValue();
                assert (unclosed.isExtremity(entry.getKey()));
                if (!unclosed.isEmpty()) {
                    this.path = IsolineTracer.this.writeTo(this.path, unclosed.toPolylines(), false);
                    unclosed.clear();
                }
                entry.setValue(null);
            }
            if (this.path != null) {
                this.shape = this.path.build();
                this.path = null;
            }
        }
    }
}

