/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;

final class VirtualFileObject
extends AbstractFolder {
    private final boolean folder;

    public VirtualFileObject(FileSystem fileSystem, FileObject myObj, String nameExt, boolean folder) {
        super(fileSystem, myObj, nameExt);
        this.folder = folder;
        this.validFlag = false;
    }

    @Override
    void setAttribute(String attrName, Object value, boolean fire) throws IOException {
        throw new IOException();
    }

    @Override
    protected String[] list() {
        return new String[0];
    }

    @Override
    protected AbstractFolder createFile(String name) {
        return new VirtualFileObject(this.getFileSystem(), this, name, false);
    }

    @Override
    void handleDelete(FileLock lock) throws IOException {
        throw new IOException();
    }

    @Override
    public void rename(FileLock lock, String name, String ext) throws IOException {
        throw new IOException();
    }

    @Override
    public boolean isFolder() {
        return this.folder;
    }

    @Override
    public Date lastModified() {
        return this.getParent().lastModified();
    }

    @Override
    public boolean isData() {
        return !this.folder;
    }

    @Override
    public Object getAttribute(String attrName) {
        return null;
    }

    @Override
    public void setAttribute(String attrName, Object value) throws IOException {
        throw new IOException();
    }

    @Override
    public Enumeration<String> getAttributes() {
        return Enumerations.empty();
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException();
    }

    @Override
    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException();
    }

    @Override
    public FileLock lock() throws IOException {
        throw new IOException();
    }

    @Override
    public void setImportant(boolean b) {
    }

    @Override
    public FileObject createFolder(String name) throws IOException {
        throw new IOException();
    }

    @Override
    public FileObject createData(String name, String ext) throws IOException {
        throw new IOException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    URL computeURL() {
        URL url = this.getParent().computeURL();
        try {
            return new URL(url, this.getNameExt());
        }
        catch (MalformedURLException ex) {
            return super.computeURL();
        }
    }
}

