/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.date.ToUTCTimestampFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;

public class ToTimezoneTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_timezone(NS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function timestamp = args.getQuick(0);
        Function timezone = args.getQuick(1);
        if (timezone.isConstant()) {
            return ToUTCTimestampFunctionFactory.getTimestampFunction(argPositions, timestamp, timezone, 1);
        }
        return new ToTimezoneFunctionVar(timestamp, timezone);
    }

    private static class ToTimezoneFunctionVar
    extends TimestampFunction
    implements BinaryFunction {
        private final Function timestamp;
        private final Function timezone;

        public ToTimezoneFunctionVar(Function timestamp, Function timezone) {
            this.timestamp = timestamp;
            this.timezone = timezone;
        }

        @Override
        public Function getLeft() {
            return this.timestamp;
        }

        @Override
        public String getName() {
            return "to_timezone";
        }

        @Override
        public Function getRight() {
            return this.timezone;
        }

        @Override
        public long getTimestamp(Record rec) {
            long timestampValue = this.timestamp.getTimestamp(rec);
            try {
                CharSequence tz = this.timezone.getStr(rec);
                return tz != null ? Timestamps.toTimezone(timestampValue, TimestampFormatUtils.enLocale, tz) : timestampValue;
            }
            catch (NumericException e) {
                return timestampValue;
            }
        }
    }
}

