/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Numbers;
import io.questdb.std.str.Path;

public final class PrefixedPath
extends Path {
    private final int prefixLen;

    public PrefixedPath(CharSequence prefix, int capacity) {
        super(capacity);
        super.of(prefix);
        this.ensureSeparator();
        this.prefixLen = this.length();
    }

    public PrefixedPath(CharSequence prefix) {
        this(prefix, Numbers.ceilPow2(prefix.length() + 32));
    }

    public PrefixedPath rewind() {
        this.trimTo(this.prefixLen);
        return this;
    }
}

