/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.InputStream;

public class DisableOnCloseInputStream
extends InputStream {
    private final InputStream wrapped;
    private boolean closed = false;

    public DisableOnCloseInputStream(InputStream wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        return this.wrapped.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkClosed();
        return this.wrapped.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        return this.wrapped.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        return this.wrapped.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
        if (!this.closed) {
            this.wrapped.mark(readlimit);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.wrapped.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }
}

