/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.util.WebUtils;

public class SanitizeContextPathFilter
implements Filter {
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER_NAME = "allowedContextPaths";
    private String allowedContextPaths = "";
    private List<String> parsedAllowedContextPaths = Collections.emptyList();

    public void init(FilterConfig filterConfig) throws ServletException {
        String providedAllowedList = filterConfig.getServletContext().getInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER_NAME);
        if (StringUtils.isNotBlank((CharSequence)providedAllowedList)) {
            this.allowedContextPaths = providedAllowedList;
            this.parsedAllowedContextPaths = Arrays.asList(StringUtils.split((String)providedAllowedList, (char)','));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.injectContextPathAttribute(request);
        filterChain.doFilter(request, response);
    }

    protected void injectContextPathAttribute(ServletRequest request) {
        String contextPath = WebUtils.sanitizeContextPath(request, this.parsedAllowedContextPaths, "");
        request.setAttribute("contextPath", (Object)contextPath);
    }

    public void destroy() {
    }

    protected String getAllowedContextPaths() {
        return this.allowedContextPaths;
    }
}

