/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties.configuration;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.configuration.BootstrapPropertiesClientProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkClient;

public abstract class AbstractAwsClientProvider<T extends SdkClient>
extends BootstrapPropertiesClientProvider<T> {
    private static final String ACCESS_KEY_PROPS_NAME = "aws.access.key.id";
    private static final String SECRET_KEY_PROPS_NAME = "aws.secret.access.key";
    private static final String REGION_KEY_PROPS_NAME = "aws.region";

    public AbstractAwsClientProvider() {
        super(BootstrapProperties.BootstrapPropertyKey.AWS_SENSITIVE_PROPERTY_PROVIDER_CONF);
    }

    protected T getConfiguredClient(Properties clientProperties) {
        String accessKey = clientProperties.getProperty(ACCESS_KEY_PROPS_NAME);
        String secretKey = clientProperties.getProperty(SECRET_KEY_PROPS_NAME);
        String region = clientProperties.getProperty(REGION_KEY_PROPS_NAME);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessKey, secretKey, region})) {
            this.logger.debug("AWS Credentials Location: Client Properties");
            try {
                AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
                return this.createClient((AwsCredentials)credentials, region);
            }
            catch (RuntimeException e) {
                throw new SensitivePropertyProtectionException("AWS Client Builder Failed using Client Properties", (Throwable)e);
            }
        }
        this.logger.debug("AWS Credentials Location: Default Credentials Provider");
        try {
            DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.builder().build();
            return this.createDefaultClient((AwsCredentialsProvider)credentialsProvider);
        }
        catch (RuntimeException e) {
            throw new SensitivePropertyProtectionException("AWS Client Builder Failed using Default Credentials Provider", (Throwable)e);
        }
    }

    protected abstract T createClient(AwsCredentials var1, String var2);

    protected abstract T createDefaultClient(AwsCredentialsProvider var1);
}

