/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.mvstore.db;

import java.util.List;
import v14.h2.command.dml.AllColumnsForPlan;
import v14.h2.engine.Session;
import v14.h2.index.BaseIndex;
import v14.h2.index.Cursor;
import v14.h2.index.IndexType;
import v14.h2.message.DbException;
import v14.h2.mvstore.MVMap;
import v14.h2.mvstore.db.MVIndex;
import v14.h2.mvstore.db.MVPrimaryIndex;
import v14.h2.mvstore.db.MVTable;
import v14.h2.result.Row;
import v14.h2.result.SearchRow;
import v14.h2.result.SortOrder;
import v14.h2.table.Column;
import v14.h2.table.IndexColumn;
import v14.h2.table.TableFilter;
import v14.h2.value.Value;
import v14.h2.value.ValueLong;
import v14.h2.value.VersionedValue;

public class MVDelegateIndex
extends BaseIndex
implements MVIndex {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable mVTable, int n, String string, MVPrimaryIndex mVPrimaryIndex, IndexType indexType) {
        super(mVTable, n, string, IndexColumn.wrap(new Column[]{mVTable.getColumn(mVPrimaryIndex.getMainIndexColumn())}), indexType);
        this.mainIndex = mVPrimaryIndex;
        if (n < 0) {
            throw DbException.throwInternalError(string);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> list) {
        throw DbException.throwInternalError();
    }

    public MVMap<Value, VersionedValue> getMVMap() {
        return this.mainIndex.getMVMap();
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.mainIndex.getRow(session, l);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        ValueLong valueLong = this.mainIndex.getKey(searchRow, ValueLong.MIN, ValueLong.MIN);
        ValueLong valueLong2 = this.mainIndex.getKey(searchRow2, ValueLong.MAX, ValueLong.MIN);
        return this.mainIndex.find(session, valueLong, valueLong2);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        return this.mainIndex.findFirstOrLast(session, bl);
    }

    @Override
    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.getColumnIndex(column) == 0;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCountApproximation(), tableFilterArray, n, sortOrder, true, allColumnsForPlan);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void update(Session session, Row row, Row row2) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

