/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Settings {
    private Settings() {
    }

    @Nullable
    public static String get(@NotNull Store settingsStore, @NotNull String name) {
        return (String)settingsStore.getEnvironment().computeInTransaction(txn -> Settings.get(txn, settingsStore, name));
    }

    @Nullable
    public static String get(@NotNull Transaction txn, @NotNull Store settingsStore, @NotNull String name) {
        try {
            ByteIterable entry = settingsStore.get(txn, (ByteIterable)StringBinding.stringToEntry((String)name));
            if (entry != null) {
                return StringBinding.entryToString((ByteIterable)entry);
            }
        }
        catch (ExodusException exodusException) {
            // empty catch block
        }
        return null;
    }

    public static void set(@NotNull Store settingsStore, @NotNull String name, @NotNull String setting) {
        settingsStore.getEnvironment().executeInTransaction(txn -> Settings.set(txn, settingsStore, name, setting));
    }

    public static void set(@NotNull Transaction txn, @NotNull Store settingsStore, @NotNull String name, @NotNull String setting) {
        settingsStore.put(txn, (ByteIterable)StringBinding.stringToEntry((String)name), (ByteIterable)StringBinding.stringToEntry((String)setting));
    }

    public static void delete(@NotNull Store settingsStore, @NotNull String name) {
        settingsStore.getEnvironment().executeInTransaction(txn -> settingsStore.delete(txn, (ByteIterable)StringBinding.stringToEntry((String)name)));
    }
}

