/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.TableWriter;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.StorageStatus;
import org.apache.nifi.controller.status.history.questdb.QuestDbWritingTemplate;

class StorageStatusWritingTemplate
extends QuestDbWritingTemplate<Pair<Instant, NodeStatus>> {
    public StorageStatusWritingTemplate() {
        super("storageStatus");
    }

    @Override
    protected void addRows(TableWriter tableWriter, Collection<Pair<Instant, NodeStatus>> entries) {
        for (Pair<Instant, NodeStatus> entry : entries) {
            TableWriter.Row row;
            long capturedAt;
            for (StorageStatus contentRepository : ((NodeStatus)entry.getRight()).getContentRepositories()) {
                capturedAt = TimeUnit.MILLISECONDS.toMicros(((Instant)entry.getLeft()).toEpochMilli());
                row = tableWriter.newRow(capturedAt);
                row.putSym(1, (CharSequence)contentRepository.getName());
                row.putShort(2, Integer.valueOf(0).shortValue());
                row.putLong(3, contentRepository.getFreeSpace());
                row.putLong(4, contentRepository.getUsedSpace());
                row.append();
            }
            for (StorageStatus provenanceRepository : ((NodeStatus)entry.getRight()).getProvenanceRepositories()) {
                capturedAt = TimeUnit.MILLISECONDS.toMicros(((Instant)entry.getLeft()).toEpochMilli());
                row = tableWriter.newRow(capturedAt);
                row.putSym(1, (CharSequence)provenanceRepository.getName());
                row.putShort(2, Integer.valueOf(1).shortValue());
                row.putLong(3, provenanceRepository.getFreeSpace());
                row.putLong(4, provenanceRepository.getUsedSpace());
                row.append();
            }
        }
    }
}

