/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.h2.database.migration;

import java.sql.Driver;

enum DatabaseVersion {
    UNKNOWN("0", 0, false, (Driver)new org.h2.Driver()),
    VERSION_1_4("1.4", 1, false, (Driver)new v14.h2.Driver()),
    VERSION_2_1("2.1", 2, true, (Driver)new v21.h2.Driver()),
    VERSION_2_2("2.2", 3, true, (Driver)new org.h2.Driver());

    private final String version;
    private final int formatVersion;
    private final Driver driver;
    private final String packageName;
    private final boolean repackagingRequired;

    private DatabaseVersion(String version, int formatVersion, boolean repackagingRequired, Driver driver) {
        this.version = version;
        this.formatVersion = formatVersion;
        this.repackagingRequired = repackagingRequired;
        this.driver = driver;
        this.packageName = driver.getClass().getName().replace(".Driver", "");
    }

    String getVersion() {
        return this.version;
    }

    int getFormatVersion() {
        return this.formatVersion;
    }

    boolean isRepackagingRequired() {
        return this.repackagingRequired;
    }

    String getPackageName() {
        return this.packageName;
    }

    Driver getDriver() {
        return this.driver;
    }
}

