/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.encryptor.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorBuilder;
import org.apache.nifi.flow.encryptor.StandardFlowEncryptor;
import org.apache.nifi.security.util.EncryptionMethod;

class FlowEncryptorCommand
implements Runnable {
    protected static final String PROPERTIES_FILE_PATH = "nifi.properties.file.path";
    protected static final String PROPS_KEY = "nifi.sensitive.props.key";
    protected static final String PROPS_ALGORITHM = "nifi.sensitive.props.algorithm";
    protected static final String CONFIGURATION_FILE = "nifi.flow.configuration.file";
    protected static final String CONFIGURATION_JSON_FILE = "nifi.flow.configuration.json.file";
    private static final List<String> CONFIGURATION_FILES = Arrays.asList("nifi.flow.configuration.file", "nifi.flow.configuration.json.file");
    private static final String FLOW_PREFIX = "nifi.flow.";
    private static final String GZ_EXTENSION = ".gz";
    private static final String DEFAULT_PROPERTIES_ALGORITHM = EncryptionMethod.MD5_256AES.getAlgorithm();
    private static final String DEFAULT_PROPERTIES_KEY = "nififtw!";
    private static final String SENSITIVE_PROPERTIES_KEY = String.format("%s=", "nifi.sensitive.props.key");
    private static final String SENSITIVE_PROPERTIES_ALGORITHM = String.format("%s=", "nifi.sensitive.props.algorithm");
    private String requestedPropertiesKey;
    private String requestedPropertiesAlgorithm;

    FlowEncryptorCommand() {
    }

    void setRequestedPropertiesKey(String requestedPropertiesKey) {
        this.requestedPropertiesKey = Objects.requireNonNull(requestedPropertiesKey, "Key required");
    }

    void setRequestedPropertiesAlgorithm(String requestedPropertiesAlgorithm) {
        this.requestedPropertiesAlgorithm = Objects.requireNonNull(requestedPropertiesAlgorithm, "Algorithm required");
    }

    @Override
    public void run() {
        String propertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
        if (propertiesFilePath == null) {
            throw new IllegalStateException(String.format("System property not defined [%s]", PROPERTIES_FILE_PATH));
        }
        File propertiesFile = new File(propertiesFilePath);
        Properties properties = this.loadProperties(propertiesFile);
        this.processFlowConfigurationFiles(properties);
        try {
            this.storeProperties(propertiesFile);
            System.out.printf("NiFi Properties Processed [%s]%n", propertiesFilePath);
        }
        catch (IOException e) {
            String message = String.format("Failed to Process NiFi Properties [%s]", propertiesFilePath);
            throw new UncheckedIOException(message, e);
        }
    }

    private void processFlowConfigurationFiles(Properties properties) {
        String outputAlgorithm = this.requestedPropertiesAlgorithm == null ? this.getAlgorithm(properties) : this.requestedPropertiesAlgorithm;
        String outputKey = this.requestedPropertiesKey == null ? this.getKey(properties) : this.requestedPropertiesKey;
        PropertyEncryptor outputEncryptor = this.getPropertyEncryptor(outputKey, outputAlgorithm);
        for (String configurationFilePropertyName : CONFIGURATION_FILES) {
            String configurationFileProperty = properties.getProperty(configurationFilePropertyName);
            if (configurationFileProperty == null || configurationFileProperty.isEmpty()) {
                System.out.printf("Flow Configuration Property not specified [%s]%n", configurationFileProperty);
                continue;
            }
            File configurationFile = new File(configurationFileProperty);
            if (!configurationFile.exists()) continue;
            this.processFlowConfiguration(configurationFile, properties, outputEncryptor);
        }
    }

    private void processFlowConfiguration(File flowConfigurationFile, Properties properties, PropertyEncryptor outputEncryptor) {
        try (GZIPInputStream flowInputStream = new GZIPInputStream(new FileInputStream(flowConfigurationFile));){
            File flowOutputFile = this.getFlowOutputFile();
            Path flowOutputPath = flowOutputFile.toPath();
            try (GZIPOutputStream flowOutputStream = new GZIPOutputStream(new FileOutputStream(flowOutputFile));){
                String inputAlgorithm = this.getAlgorithm(properties);
                String inputPropertiesKey = this.getKey(properties);
                PropertyEncryptor inputEncryptor = this.getPropertyEncryptor(inputPropertiesKey, inputAlgorithm);
                StandardFlowEncryptor flowEncryptor = new StandardFlowEncryptor();
                flowEncryptor.processFlow(flowInputStream, flowOutputStream, inputEncryptor, outputEncryptor);
            }
            Path flowConfigurationPath = flowConfigurationFile.toPath();
            Files.move(flowOutputPath, flowConfigurationPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.printf("Flow Configuration Processed [%s]%n", flowConfigurationPath);
        }
        catch (IOException | RuntimeException e) {
            System.err.printf("Failed to process Flow Configuration [%s]%n", flowConfigurationFile);
            e.printStackTrace();
        }
    }

    private String getAlgorithm(Properties properties) {
        String algorithm = properties.getProperty(PROPS_ALGORITHM, DEFAULT_PROPERTIES_ALGORITHM);
        if (algorithm.length() == 0) {
            algorithm = DEFAULT_PROPERTIES_ALGORITHM;
        }
        return algorithm;
    }

    private String getKey(Properties properties) {
        String key = properties.getProperty(PROPS_KEY, DEFAULT_PROPERTIES_KEY);
        if (key.length() == 0) {
            key = DEFAULT_PROPERTIES_KEY;
        }
        return key;
    }

    private File getFlowOutputFile() throws IOException {
        File flowOutputFile = File.createTempFile(FLOW_PREFIX, GZ_EXTENSION);
        flowOutputFile.deleteOnExit();
        return flowOutputFile;
    }

    private Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(propertiesFile);){
            properties.load(reader);
        }
        catch (IOException e) {
            String message = String.format("Failed to read NiFi Properties [%s]", propertiesFile);
            throw new UncheckedIOException(message, e);
        }
        return properties;
    }

    private void storeProperties(File propertiesFile) throws IOException {
        Path propertiesFilePath = propertiesFile.toPath();
        List<String> lines = Files.readAllLines(propertiesFilePath);
        List updatedLines = lines.stream().map(line -> {
            if (line.startsWith(SENSITIVE_PROPERTIES_KEY)) {
                return this.requestedPropertiesKey == null ? line : SENSITIVE_PROPERTIES_KEY + this.requestedPropertiesKey;
            }
            if (line.startsWith(SENSITIVE_PROPERTIES_ALGORITHM)) {
                return this.requestedPropertiesAlgorithm == null ? line : SENSITIVE_PROPERTIES_ALGORITHM + this.requestedPropertiesAlgorithm;
            }
            return line;
        }).collect(Collectors.toList());
        Files.write(propertiesFilePath, updatedLines, new OpenOption[0]);
    }

    private PropertyEncryptor getPropertyEncryptor(String propertiesKey, String propertiesAlgorithm) {
        return new PropertyEncryptorBuilder(propertiesKey).setAlgorithm(propertiesAlgorithm).build();
    }
}

